/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.query.processor;

import com.db4o.foundation.Iterator4;
import com.db4o.internal.Transaction;
import com.db4o.internal.query.processor.QCandidate;
import com.db4o.internal.query.processor.QCon;
import com.db4o.internal.query.processor.QPending;

public class QConJoin
extends QCon {
    public boolean i_and;
    public QCon i_constraint1;
    public QCon i_constraint2;

    public QConJoin() {
    }

    QConJoin(Transaction a_trans, QCon a_c1, QCon a_c2, boolean a_and) {
        super(a_trans);
        this.i_constraint1 = a_c1;
        this.i_constraint2 = a_c2;
        this.i_and = a_and;
    }

    @Override
    void doNotInclude(QCandidate a_root) {
        this.i_constraint1.doNotInclude(a_root);
        this.i_constraint2.doNotInclude(a_root);
    }

    @Override
    void exchangeConstraint(QCon a_exchange, QCon a_with) {
        super.exchangeConstraint(a_exchange, a_with);
        if (a_exchange == this.i_constraint1) {
            this.i_constraint1 = a_with;
        }
        if (a_exchange == this.i_constraint2) {
            this.i_constraint2 = a_with;
        }
    }

    void evaluatePending(QCandidate a_root, QPending a_pending, int a_secondResult) {
        boolean res = this.i_evaluator.not(this.i_and ? a_pending._result + a_secondResult > 0 : a_pending._result + a_secondResult > -4);
        if (this.hasJoins()) {
            Iterator4 i = this.iterateJoins();
            while (i.moveNext()) {
                QConJoin qcj = (QConJoin)i.current();
                a_root.evaluate(new QPending(qcj, this, res));
            }
        } else if (!res) {
            this.i_constraint1.doNotInclude(a_root);
            this.i_constraint2.doNotInclude(a_root);
        }
    }

    public QCon getOtherConstraint(QCon a_constraint) {
        if (a_constraint == this.i_constraint1) {
            return this.i_constraint2;
        }
        if (a_constraint == this.i_constraint2) {
            return this.i_constraint1;
        }
        throw new IllegalArgumentException();
    }

    @Override
    String logObject() {
        return "";
    }

    boolean removeForParent(QCon a_constraint) {
        if (this.i_and) {
            QCon other = this.getOtherConstraint(a_constraint);
            other.removeJoin(this);
            other.remove();
            return true;
        }
        return false;
    }

    public String toString() {
        String str = "QConJoin " + (this.i_and ? "AND " : "OR");
        if (this.i_constraint1 != null) {
            str = str + "\n   " + this.i_constraint1;
        }
        if (this.i_constraint2 != null) {
            str = str + "\n   " + this.i_constraint2;
        }
        return str;
    }

    public boolean isOr() {
        return !this.i_and;
    }
}

