/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.handlers;

import com.db4o.CorruptionException;
import com.db4o.foundation.Coercion4;
import com.db4o.foundation.PreparedComparison;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.handlers.PrimitiveHandler;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.marshall.ReadContext;
import com.db4o.marshall.WriteContext;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.Reflector;

public class IntHandler
extends PrimitiveHandler {
    private static final Integer DEFAULTVALUE = new Integer(0);

    @Override
    public Object coerce(Reflector reflector, ReflectClass claxx, Object obj) {
        return Coercion4.toInt(obj);
    }

    @Override
    public Object defaultValue() {
        return DEFAULTVALUE;
    }

    @Override
    public Class primitiveJavaClass() {
        return Integer.TYPE;
    }

    @Override
    public int linkLength() {
        return 4;
    }

    @Override
    public Object read(MarshallerFamily mf, StatefulBuffer writer, boolean redirect) throws CorruptionException {
        return mf._primitive.readInteger(writer);
    }

    @Override
    Object read1(ByteArrayBuffer a_bytes) {
        return new Integer(a_bytes.readInt());
    }

    @Override
    public void write(Object obj, ByteArrayBuffer writer) {
        this.write((Integer)obj, writer);
    }

    public void write(int intValue, ByteArrayBuffer writer) {
        IntHandler.writeInt(intValue, writer);
    }

    public static final void writeInt(int a_int, ByteArrayBuffer a_bytes) {
        a_bytes.writeInt(a_int);
    }

    @Override
    public void defragIndexEntry(DefragmentContextImpl context) {
        context.incrementIntSize();
    }

    @Override
    public Object read(ReadContext context) {
        return new Integer(context.readInt());
    }

    @Override
    public void write(WriteContext context, Object obj) {
        context.writeInt((Integer)obj);
    }

    @Override
    public PreparedComparison internalPrepareComparison(Object source) {
        return this.newPrepareCompare((Integer)source);
    }

    public PreparedComparison newPrepareCompare(int i) {
        return new PreparedIntComparison(i);
    }

    public final class PreparedIntComparison
    implements PreparedComparison {
        private final int _sourceInt;

        public PreparedIntComparison(int sourceInt) {
            this._sourceInt = sourceInt;
        }

        @Override
        public int compareTo(Object target) {
            if (target == null) {
                return 1;
            }
            int targetInt = (Integer)target;
            return this._sourceInt == targetInt ? 0 : (this._sourceInt < targetInt ? -1 : 1);
        }
    }
}

