/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.fieldindex;

import com.db4o.foundation.Iterator4;
import com.db4o.foundation.MappingIterator;
import com.db4o.foundation.Tree;
import com.db4o.internal.TreeInt;
import com.db4o.internal.btree.FieldIndexKey;
import com.db4o.internal.fieldindex.IndexedNode;
import com.db4o.internal.query.processor.QCandidates;

public class FieldIndexProcessorResult {
    public static final FieldIndexProcessorResult NO_INDEX_FOUND = new FieldIndexProcessorResult(null);
    public static final FieldIndexProcessorResult FOUND_INDEX_BUT_NO_MATCH = new FieldIndexProcessorResult(null);
    private final IndexedNode _indexedNode;

    public FieldIndexProcessorResult(IndexedNode indexedNode) {
        this._indexedNode = indexedNode;
    }

    public Tree toQCandidate(QCandidates candidates) {
        return TreeInt.toQCandidate(this.toTreeInt(), candidates);
    }

    public TreeInt toTreeInt() {
        if (this.foundMatch()) {
            return this._indexedNode.toTreeInt();
        }
        return null;
    }

    public boolean foundMatch() {
        return this.foundIndex() && !this.noMatch();
    }

    public boolean foundIndex() {
        return this != NO_INDEX_FOUND;
    }

    public boolean noMatch() {
        return this == FOUND_INDEX_BUT_NO_MATCH;
    }

    public Iterator4 iterateIDs() {
        return new MappingIterator(this._indexedNode.iterator()){

            @Override
            protected Object map(Object current) {
                FieldIndexKey composite = (FieldIndexKey)current;
                return new Integer(composite.parentID());
            }
        };
    }
}

