/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterator4Impl;
import com.db4o.foundation.List4;
import com.db4o.foundation.Predicate4;
import com.db4o.foundation.Queue4;

public class NonblockingQueue
implements Queue4 {
    private List4 _insertionPoint;
    private List4 _next;

    @Override
    public final void add(Object obj) {
        List4 newNode = new List4(null, obj);
        if (this._insertionPoint == null) {
            this._next = newNode;
        } else {
            this._insertionPoint._next = newNode;
        }
        this._insertionPoint = newNode;
    }

    @Override
    public final Object next() {
        if (this._next == null) {
            return null;
        }
        Object ret = this._next._element;
        this.removeNext();
        return ret;
    }

    private void removeNext() {
        this._next = this._next._next;
        if (this._next == null) {
            this._insertionPoint = null;
        }
    }

    @Override
    public Object nextMatching(Predicate4 condition) {
        if (null == condition) {
            throw new ArgumentNullException();
        }
        List4 current = this._next;
        List4 previous = null;
        while (null != current) {
            Object element = current._element;
            if (condition.match(element)) {
                if (previous == null) {
                    this.removeNext();
                } else {
                    previous._next = current._next;
                }
                return element;
            }
            previous = current;
            current = current._next;
        }
        return null;
    }

    @Override
    public final boolean hasNext() {
        return this._next != null;
    }

    @Override
    public Iterator4 iterator() {
        final List4 origInsertionPoint = this._insertionPoint;
        final List4 origNext = this._next;
        return new Iterator4Impl(this._next){

            @Override
            public boolean moveNext() {
                if (this.queueWasModified()) {
                    throw new IllegalStateException();
                }
                return super.moveNext();
            }

            private boolean queueWasModified() {
                return origInsertionPoint != NonblockingQueue.this._insertionPoint || origNext != NonblockingQueue.this._next;
            }
        };
    }
}

