/*
 * Decompiled with CFR 0.152.
 */
package SevenZip;

import SevenZip.Compression.LZMA.Decoder;
import SevenZip.Compression.LZMA.Encoder;
import SevenZip.LzmaBench;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class LzmaAlone {
    static void PrintHelp() {
        System.out.println("\nUsage:  LZMA <e|d> [<switches>...] inputFile outputFile\n  e: encode file\n  d: decode file\n  b: Benchmark\n<Switches>\n  -d{N}:  set dictionary - [0,28], default: 23 (8MB)\n  -fb{N}: set number of fast bytes - [5, 273], default: 128\n  -lc{N}: set number of literal context bits - [0, 8], default: 3\n  -lp{N}: set number of literal pos bits - [0, 4], default: 0\n  -pb{N}: set number of pos bits - [0, 4], default: 2\n  -mf{MF_ID}: set Match Finder: [bt2, bt4], default: bt4\n  -eos:   write End Of Stream marker\n");
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("\nLZMA (Java) 4.61  2008-11-23\n");
        if (stringArray.length < 1) {
            LzmaAlone.PrintHelp();
            return;
        }
        CommandLine commandLine = new CommandLine();
        if (!commandLine.Parse(stringArray)) {
            System.out.println("\nIncorrect command");
            return;
        }
        if (commandLine.Command == 2) {
            int n = 0x200000;
            if (commandLine.DictionarySizeIsDefined) {
                n = commandLine.DictionarySize;
            }
            if (commandLine.MatchFinder > 1) {
                throw new Exception("Unsupported match finder");
            }
            LzmaBench.LzmaBenchmark(commandLine.NumBenchmarkPasses, n);
        } else if (commandLine.Command == 0 || commandLine.Command == 1) {
            File file = new File(commandLine.InFile);
            File file2 = new File(commandLine.OutFile);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            boolean bl = false;
            if (commandLine.Eos) {
                bl = true;
            }
            if (commandLine.Command == 0) {
                Encoder encoder = new Encoder();
                if (!encoder.SetAlgorithm(commandLine.Algorithm)) {
                    throw new Exception("Incorrect compression mode");
                }
                if (!encoder.SetDictionarySize(commandLine.DictionarySize)) {
                    throw new Exception("Incorrect dictionary size");
                }
                if (!encoder.SetNumFastBytes(commandLine.Fb)) {
                    throw new Exception("Incorrect -fb value");
                }
                if (!encoder.SetMatchFinder(commandLine.MatchFinder)) {
                    throw new Exception("Incorrect -mf value");
                }
                if (!encoder.SetLcLpPb(commandLine.Lc, commandLine.Lp, commandLine.Pb)) {
                    throw new Exception("Incorrect -lc or -lp or -pb value");
                }
                encoder.SetEndMarkerMode(bl);
                encoder.WriteCoderProperties(bufferedOutputStream);
                long l = bl ? -1L : file.length();
                for (int i = 0; i < 8; ++i) {
                    bufferedOutputStream.write((int)(l >>> 8 * i) & 0xFF);
                }
                encoder.Code(bufferedInputStream, bufferedOutputStream, -1L, -1L, null);
            } else {
                int n = 5;
                byte[] byArray = new byte[n];
                if (bufferedInputStream.read(byArray, 0, n) != n) {
                    throw new Exception("input .lzma file is too short");
                }
                Decoder decoder = new Decoder();
                if (!decoder.SetDecoderProperties(byArray)) {
                    throw new Exception("Incorrect stream properties");
                }
                long l = 0L;
                for (int i = 0; i < 8; ++i) {
                    int n2 = bufferedInputStream.read();
                    if (n2 < 0) {
                        throw new Exception("Can't read stream size");
                    }
                    l |= (long)n2 << 8 * i;
                }
                if (!decoder.Code(bufferedInputStream, bufferedOutputStream, l)) {
                    throw new Exception("Error in data stream");
                }
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            bufferedInputStream.close();
        } else {
            throw new Exception("Incorrect command");
        }
    }

    public static class CommandLine {
        public static final int kEncode = 0;
        public static final int kDecode = 1;
        public static final int kBenchmak = 2;
        public int Command = -1;
        public int NumBenchmarkPasses = 10;
        public int DictionarySize = 0x800000;
        public boolean DictionarySizeIsDefined = false;
        public int Lc = 3;
        public int Lp = 0;
        public int Pb = 2;
        public int Fb = 128;
        public boolean FbIsDefined = false;
        public boolean Eos = false;
        public int Algorithm = 2;
        public int MatchFinder = 1;
        public String InFile;
        public String OutFile;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean ParseSwitch(String string) {
            if (string.startsWith("d")) {
                this.DictionarySize = 1 << Integer.parseInt(string.substring(1));
                this.DictionarySizeIsDefined = true;
                return true;
            } else if (string.startsWith("fb")) {
                this.Fb = Integer.parseInt(string.substring(2));
                this.FbIsDefined = true;
                return true;
            } else if (string.startsWith("a")) {
                this.Algorithm = Integer.parseInt(string.substring(1));
                return true;
            } else if (string.startsWith("lc")) {
                this.Lc = Integer.parseInt(string.substring(2));
                return true;
            } else if (string.startsWith("lp")) {
                this.Lp = Integer.parseInt(string.substring(2));
                return true;
            } else if (string.startsWith("pb")) {
                this.Pb = Integer.parseInt(string.substring(2));
                return true;
            } else if (string.startsWith("eos")) {
                this.Eos = true;
                return true;
            } else {
                if (!string.startsWith("mf")) return false;
                String string2 = string.substring(2);
                if (string2.equals("bt2")) {
                    this.MatchFinder = 0;
                    return true;
                } else if (string2.equals("bt4")) {
                    this.MatchFinder = 1;
                    return true;
                } else {
                    if (!string2.equals("bt4b")) return false;
                    this.MatchFinder = 2;
                }
            }
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean Parse(String[] stringArray) throws Exception {
            int n = 0;
            boolean bl = true;
            for (int i = 0; i < stringArray.length; ++i) {
                block20: {
                    String string = stringArray[i];
                    if (string.length() == 0) {
                        return false;
                    }
                    if (bl) {
                        if (string.compareTo("--") == 0) {
                            bl = false;
                            continue;
                        }
                        if (string.charAt(0) == '-') {
                            String string2 = string.substring(1).toLowerCase();
                            if (string2.length() == 0) {
                                return false;
                            }
                            try {
                                if (this.ParseSwitch(string2)) continue;
                                return false;
                            }
                            catch (NumberFormatException numberFormatException) {
                                return false;
                            }
                        }
                    }
                    if (n == 0) {
                        if (string.equalsIgnoreCase("e")) {
                            this.Command = 0;
                        } else if (string.equalsIgnoreCase("d")) {
                            this.Command = 1;
                        } else {
                            if (!string.equalsIgnoreCase("b")) return false;
                            this.Command = 2;
                        }
                    } else if (n == 1) {
                        if (this.Command == 2) {
                            try {
                                this.NumBenchmarkPasses = Integer.parseInt(string);
                                if (this.NumBenchmarkPasses < 1) {
                                    return false;
                                }
                                break block20;
                            }
                            catch (NumberFormatException numberFormatException) {
                                return false;
                            }
                        }
                        this.InFile = string;
                    } else {
                        if (n != 2) return false;
                        this.OutFile = string;
                    }
                }
                ++n;
            }
            return true;
        }
    }
}

