/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.crypt.AEADCryptBucket;
import freenet.crypt.EncryptedRandomAccessBucket;
import freenet.crypt.EncryptedRandomAccessBuffer;
import freenet.crypt.MasterSecret;
import freenet.crypt.SHA256;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.api.LockableRandomAccessBuffer;
import freenet.support.api.RandomAccessBucket;
import freenet.support.api.RandomAccessBuffer;
import freenet.support.io.ArrayBucket;
import freenet.support.io.ArrayBucketFactory;
import freenet.support.io.Closer;
import freenet.support.io.DelayedFreeBucket;
import freenet.support.io.DelayedFreeRandomAccessBucket;
import freenet.support.io.DelayedFreeRandomAccessBuffer;
import freenet.support.io.FileBucket;
import freenet.support.io.FileRandomAccessBuffer;
import freenet.support.io.FileUtil;
import freenet.support.io.FilenameGenerator;
import freenet.support.io.NoFreeBucket;
import freenet.support.io.PaddedBucket;
import freenet.support.io.PaddedEphemerallyEncryptedBucket;
import freenet.support.io.PaddedRandomAccessBucket;
import freenet.support.io.PaddedRandomAccessBuffer;
import freenet.support.io.PersistentFileTracker;
import freenet.support.io.PersistentTempFileBucket;
import freenet.support.io.PooledFileRandomAccessBuffer;
import freenet.support.io.RAFBucket;
import freenet.support.io.ReadOnlyFileSliceBucket;
import freenet.support.io.ReadOnlyRandomAccessBuffer;
import freenet.support.io.ResumeFailedException;
import freenet.support.io.StorageFormatException;
import freenet.support.math.MersenneTwister;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Random;

public class BucketTools {
    private static final int BUFFER_SIZE = 65536;
    private static volatile boolean logMINOR;
    static final ArrayBucketFactory ARRAY_FACTORY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Bucket src, Bucket dst) throws IOException {
        OutputStream out = dst.getOutputStreamUnbuffered();
        InputStream in = src.getInputStreamUnbuffered();
        ReadableByteChannel readChannel = Channels.newChannel(in);
        WritableByteChannel writeChannel = Channels.newChannel(out);
        try {
            ByteBuffer buffer = ByteBuffer.allocate(65536);
            while (readChannel.read(buffer) != -1) {
                buffer.flip();
                while (buffer.hasRemaining()) {
                    writeChannel.write(buffer);
                }
                buffer.clear();
            }
        }
        finally {
            writeChannel.close();
            readChannel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zeroPad(Bucket b, long size) throws IOException {
        try (OutputStream out = b.getOutputStreamUnbuffered();){
            long nRequired;
            byte[] buffer = new byte[16384];
            for (long count = 0L; count < size; count += nRequired) {
                nRequired = buffer.length;
                if (nRequired > size - count) {
                    nRequired = size - count;
                }
                out.write(buffer, 0, (int)nRequired);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paddedCopy(Bucket from, Bucket to, long nBytes, int blockSize) throws IOException {
        if (nBytes > (long)blockSize) {
            throw new IllegalArgumentException("nBytes > blockSize");
        }
        OutputStream out = null;
        InputStream in = null;
        try {
            long count;
            long nRead;
            out = to.getOutputStreamUnbuffered();
            byte[] buffer = new byte[16384];
            in = from.getInputStreamUnbuffered();
            for (count = 0L; count != nBytes; count += nRead) {
                long nRequired = nBytes - count;
                if (nRequired > (long)buffer.length) {
                    nRequired = buffer.length;
                }
                if ((nRead = (long)in.read(buffer, 0, (int)nRequired)) == -1L) {
                    throw new IOException("Not enough data in source bucket.");
                }
                out.write(buffer, 0, (int)nRead);
            }
            if (count < (long)blockSize) {
                long padLength = buffer.length;
                if (padLength > (long)blockSize - nBytes) {
                    padLength = (long)blockSize - nBytes;
                }
                int i = 0;
                while ((long)i < padLength) {
                    buffer[i] = 0;
                    ++i;
                }
                while (count != (long)blockSize) {
                    long nRequired = (long)blockSize - count;
                    if ((long)blockSize - count > (long)buffer.length) {
                        nRequired = buffer.length;
                    }
                    out.write(buffer, 0, (int)nRequired);
                    count += nRequired;
                }
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static Bucket[] makeBuckets(BucketFactory bf, int count, int size) throws IOException {
        Bucket[] ret = new Bucket[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = bf.makeBucket(size);
        }
        return ret;
    }

    public static int[] nullIndices(Bucket[] array) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) continue;
            list.add(i);
        }
        int[] ret = new int[list.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Integer)list.get(i);
        }
        return ret;
    }

    public static int[] nonNullIndices(Bucket[] array) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            list.add(i);
        }
        int[] ret = new int[list.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Integer)list.get(i);
        }
        return ret;
    }

    public static Bucket[] nonNullBuckets(Bucket[] array) {
        ArrayList<Bucket> list = new ArrayList<Bucket>(array.length);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            list.add(array[i]);
        }
        Bucket[] ret = new Bucket[list.size()];
        return list.toArray(ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(Bucket bucket) throws IOException {
        long size = bucket.size();
        if (size > Integer.MAX_VALUE) {
            throw new OutOfMemoryError();
        }
        byte[] data = new byte[(int)size];
        InputStream is = bucket.getInputStreamUnbuffered();
        DataInputStream dis = null;
        try {
            dis = new DataInputStream(is);
            dis.readFully(data);
        }
        catch (Throwable throwable) {
            Closer.close(dis);
            Closer.close(is);
            throw throwable;
        }
        Closer.close(dis);
        Closer.close(is);
        return data;
    }

    public static int toByteArray(Bucket bucket, byte[] output) throws IOException {
        long size = bucket.size();
        if (size > (long)output.length) {
            throw new IllegalArgumentException("Data does not fit in provided buffer");
        }
        try (InputStream is = null;){
            is = bucket.getInputStreamUnbuffered();
            int moved = 0;
            while (true) {
                if ((long)moved == size) {
                    int n = moved;
                    return n;
                }
                int x = is.read(output, moved, (int)(size - (long)moved));
                if (x == -1) {
                    int n = moved;
                    return n;
                }
                moved += x;
            }
        }
    }

    public static RandomAccessBucket makeImmutableBucket(BucketFactory bucketFactory, byte[] data) throws IOException {
        return BucketTools.makeImmutableBucket(bucketFactory, data, data.length);
    }

    public static RandomAccessBucket makeImmutableBucket(BucketFactory bucketFactory, byte[] data, int length) throws IOException {
        return BucketTools.makeImmutableBucket(bucketFactory, data, 0, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RandomAccessBucket makeImmutableBucket(BucketFactory bucketFactory, byte[] data, int offset, int length) throws IOException {
        RandomAccessBucket bucket = bucketFactory.makeBucket(length);
        try (OutputStream os = bucket.getOutputStreamUnbuffered();){
            os.write(data, offset, length);
        }
        bucket.setReadOnly();
        return bucket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] hash(Bucket data) throws IOException {
        try (InputStream is = data.getInputStreamUnbuffered();){
            byte[] byArray;
            MessageDigest md = SHA256.getMessageDigest();
            try {
                byte[] retval;
                long bytesRead;
                int readBytes;
                long bucketLength = data.size();
                byte[] buf = new byte[65536];
                for (bytesRead = 0L; (bytesRead < bucketLength || bucketLength == -1L) && (readBytes = is.read(buf)) >= 0; bytesRead += (long)readBytes) {
                    if (readBytes <= 0) continue;
                    md.update(buf, 0, readBytes);
                }
                if (bytesRead < bucketLength && bucketLength > 0L) {
                    throw new EOFException();
                }
                if (bytesRead != bucketLength && bucketLength > 0L) {
                    throw new IOException("Read " + bytesRead + " but bucket length " + bucketLength + " on " + data + '!');
                }
                byArray = retval = md.digest();
            }
            catch (Throwable throwable) {
                SHA256.returnMessageDigest(md);
                throw throwable;
            }
            SHA256.returnMessageDigest(md);
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copyTo(Bucket decodedData, OutputStream os, long truncateLength) throws IOException {
        if (truncateLength == 0L) {
            return 0L;
        }
        if (truncateLength < 0L) {
            truncateLength = Long.MAX_VALUE;
        }
        InputStream is = decodedData.getInputStreamUnbuffered();
        try {
            long moved;
            int bytes;
            int bufferSize = 65536;
            if (truncateLength > 0L && truncateLength < (long)bufferSize) {
                bufferSize = (int)truncateLength;
            }
            byte[] buf = new byte[bufferSize];
            for (moved = 0L; moved < truncateLength; moved += (long)bytes) {
                bytes = (int)Math.min((long)buf.length, truncateLength - moved);
                if (bytes <= 0) {
                    throw new IllegalStateException("bytes=" + bytes + ", truncateLength=" + truncateLength + ", moved=" + moved);
                }
                if ((bytes = is.read(buf, 0, bytes)) <= 0) {
                    if (truncateLength == Long.MAX_VALUE) break;
                    IOException ioException = new IOException("Could not move required quantity of data in copyTo: " + bytes + " (moved " + moved + " of " + truncateLength + "): unable to read from " + is);
                    ioException.printStackTrace();
                    throw ioException;
                }
                os.write(buf, 0, bytes);
            }
            long l = moved;
            return l;
        }
        finally {
            is.close();
            os.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFrom(Bucket bucket, InputStream is, long truncateLength) throws IOException {
        OutputStream os = bucket.getOutputStreamUnbuffered();
        byte[] buf = new byte[65536];
        if (truncateLength < 0L) {
            truncateLength = Long.MAX_VALUE;
        }
        try {
            int bytes;
            for (long moved = 0L; moved < truncateLength; moved += (long)bytes) {
                bytes = (int)Math.min((long)buf.length, truncateLength - moved);
                if (bytes <= 0) {
                    throw new IllegalStateException("bytes=" + bytes + ", truncateLength=" + truncateLength + ", moved=" + moved);
                }
                if ((bytes = is.read(buf, 0, bytes)) <= 0) {
                    if (truncateLength == Long.MAX_VALUE) {
                        break;
                    }
                    IOException ioException = new IOException("Could not move required quantity of data in copyFrom: " + bytes + " (moved " + moved + " of " + truncateLength + "): unable to read from " + is);
                    ioException.printStackTrace();
                    throw ioException;
                }
                os.write(buf, 0, bytes);
            }
        }
        finally {
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bucket[] split(Bucket origData, int splitSize, BucketFactory bf, boolean freeData, boolean persistent) throws IOException {
        long length;
        if (origData instanceof FileBucket) {
            if (freeData) {
                Logger.error(BucketTools.class, "Asked to free data when splitting a FileBucket ?!?!? Not freeing as this would clobber the split result...");
            }
            Bucket[] buckets = ((FileBucket)origData).split(splitSize);
            if (persistent) {
                return buckets;
            }
        }
        if ((length = origData.size()) > Integer.MAX_VALUE * (long)splitSize) {
            throw new IllegalArgumentException("Way too big!: " + length + " for " + splitSize);
        }
        int bucketCount = (int)(length / (long)splitSize);
        if (length % (long)splitSize > 0L) {
            ++bucketCount;
        }
        if (logMINOR) {
            Logger.minor(BucketTools.class, "Splitting bucket " + origData + " of size " + length + " into " + bucketCount + " buckets");
        }
        Bucket[] buckets = new Bucket[bucketCount];
        InputStream is = origData.getInputStreamUnbuffered();
        DataInputStream dis = null;
        try {
            dis = new DataInputStream(is);
            long remainingLength = length;
            byte[] buf = new byte[splitSize];
            for (int i = 0; i < bucketCount; ++i) {
                int len = (int)Math.min((long)splitSize, remainingLength);
                RandomAccessBucket bucket = bf.makeBucket(len);
                buckets[i] = bucket;
                dis.readFully(buf, 0, len);
                remainingLength -= (long)len;
                try (OutputStream os = bucket.getOutputStreamUnbuffered();){
                    os.write(buf, 0, len);
                    continue;
                }
            }
        }
        finally {
            if (dis != null) {
                dis.close();
            } else {
                is.close();
            }
        }
        if (freeData) {
            origData.free();
        }
        return buckets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bucket pad(Bucket oldBucket, int blockLength, BucketFactory bf, int length) throws IOException {
        byte[] hash = BucketTools.hash(oldBucket);
        RandomAccessBucket b = bf.makeBucket(blockLength);
        MersenneTwister mt = new MersenneTwister(hash);
        OutputStream os = b.getOutputStreamUnbuffered();
        try {
            int thisCycle;
            BucketTools.copyTo(oldBucket, os, length);
            byte[] buf = new byte[65536];
            for (int x = length; x < blockLength; x += thisCycle) {
                int remaining = blockLength - x;
                thisCycle = Math.min(remaining, buf.length);
                mt.nextBytes(buf);
                os.write(buf, 0, thisCycle);
            }
            os.close();
            os = null;
            if (b.size() != (long)blockLength) {
                throw new IllegalStateException("The bucket's size is " + b.size() + " whereas it should be " + blockLength + '!');
            }
            RandomAccessBucket randomAccessBucket = b;
            return randomAccessBucket;
        }
        finally {
            Closer.close(os);
        }
    }

    public static byte[] pad(byte[] orig, int blockSize, int length) throws IOException {
        ArrayBucket b = new ArrayBucket(orig);
        Bucket ret = BucketTools.pad(b, blockSize, ARRAY_FACTORY, length);
        return BucketTools.toByteArray(ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean equalBuckets(Bucket a, Bucket b) throws IOException {
        if (a.size() != b.size()) {
            return false;
        }
        long size = a.size();
        InputStream aIn = null;
        InputStream bIn = null;
        try {
            aIn = a.getInputStreamUnbuffered();
            bIn = b.getInputStreamUnbuffered();
            boolean bl = FileUtil.equalStreams(aIn, bIn, size);
            return bl;
        }
        finally {
            aIn.close();
            bIn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fill(Bucket bucket, Random random, long length) throws IOException {
        try (OutputStream os = null;){
            os = bucket.getOutputStreamUnbuffered();
            FileUtil.fill(os, random, length);
        }
    }

    public static void fill(RandomAccessBuffer raf, Random random, long offset, long length) throws IOException {
        int toRead;
        byte[] buf = new byte[65536];
        for (long moved = 0L; moved < length; moved += (long)toRead) {
            toRead = (int)Math.min(65536L, length - moved);
            random.nextBytes(buf);
            raf.pwrite(offset + moved, buf, 0, toRead);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fill(Bucket bucket, long length) throws IOException {
        try (OutputStream os = null;){
            os = bucket.getOutputStreamUnbuffered();
            FileUtil.fill(os, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copyTo(Bucket bucket, RandomAccessBuffer raf, long fileOffset, long truncateLength) throws IOException {
        if (truncateLength == 0L) {
            return 0L;
        }
        if (truncateLength < 0L) {
            truncateLength = Long.MAX_VALUE;
        }
        try (InputStream is = bucket.getInputStreamUnbuffered();){
            int bufferSize = 65536;
            if (truncateLength > 0L && truncateLength < (long)bufferSize) {
                bufferSize = (int)truncateLength;
            }
            byte[] buf = new byte[bufferSize];
            long moved = 0L;
            while (moved < truncateLength) {
                int bytes = (int)Math.min((long)buf.length, truncateLength - moved);
                if (bytes <= 0) {
                    throw new IllegalStateException("bytes=" + bytes + ", truncateLength=" + truncateLength + ", moved=" + moved);
                }
                if ((bytes = is.read(buf, 0, bytes)) <= 0) {
                    if (truncateLength == Long.MAX_VALUE) break;
                    IOException ioException = new IOException("Could not move required quantity of data in copyTo: " + bytes + " (moved " + moved + " of " + truncateLength + "): unable to read from " + is);
                    ioException.printStackTrace();
                    throw ioException;
                }
                raf.pwrite(fileOffset, buf, 0, bytes);
                moved += (long)bytes;
                fileOffset += (long)bytes;
            }
            long l = moved;
            return l;
        }
    }

    public static Bucket restoreFrom(DataInputStream dis, FilenameGenerator fg, PersistentFileTracker persistentFileTracker, MasterSecret masterKey) throws IOException, StorageFormatException, ResumeFailedException {
        int magic = dis.readInt();
        switch (magic) {
            case -1302646058: {
                return new AEADCryptBucket(dis, fg, persistentFileTracker, masterKey);
            }
            case -1880693733: {
                return new FileBucket(dis);
            }
            case 805164239: {
                return new PersistentTempFileBucket(dis);
            }
            case 1318885891: {
                return new DelayedFreeBucket(dis, fg, persistentFileTracker, masterKey);
            }
            case -1567675859: {
                return new DelayedFreeRandomAccessBucket(dis, fg, persistentFileTracker, masterKey);
            }
            case -1467111998: {
                return new NoFreeBucket(dis, fg, persistentFileTracker, masterKey);
            }
            case 1724325833: {
                return new PaddedEphemerallyEncryptedBucket(dis, fg, persistentFileTracker, masterKey);
            }
            case 161371332: {
                return new ReadOnlyFileSliceBucket(dis);
            }
            case -620797563: {
                return new PaddedBucket(dis, fg, persistentFileTracker, masterKey);
            }
            case -1782305228: {
                return new PaddedRandomAccessBucket(dis, fg, persistentFileTracker, masterKey);
            }
            case -1993707382: {
                return new RAFBucket(dis, fg, persistentFileTracker, masterKey);
            }
            case -658879362: {
                return new EncryptedRandomAccessBucket(dis, fg, persistentFileTracker, masterKey);
            }
        }
        throw new StorageFormatException("Unknown magic value for bucket " + magic);
    }

    public static LockableRandomAccessBuffer restoreRAFFrom(DataInputStream dis, FilenameGenerator fg, PersistentFileTracker persistentFileTracker, MasterSecret masterSecret) throws IOException, StorageFormatException, ResumeFailedException {
        int magic = dis.readInt();
        switch (magic) {
            case 696014090: {
                return new PooledFileRandomAccessBuffer(dis, fg, persistentFileTracker);
            }
            case -586200398: {
                return new FileRandomAccessBuffer(dis);
            }
            case 1686971610: {
                return new ReadOnlyRandomAccessBuffer(dis, fg, persistentFileTracker, masterSecret);
            }
            case 1068910046: {
                return new DelayedFreeRandomAccessBuffer(dis, fg, persistentFileTracker, masterSecret);
            }
            case 971674818: {
                return EncryptedRandomAccessBuffer.create(dis, fg, persistentFileTracker, masterSecret);
            }
            case 514519856: {
                return new PaddedRandomAccessBuffer(dis, fg, persistentFileTracker, masterSecret);
            }
        }
        throw new StorageFormatException("Unknown magic value for RAF " + magic);
    }

    public static RandomAccessBucket toRandomAccessBucket(Bucket bucket, BucketFactory bf) throws IOException {
        RandomAccessBucket ret;
        if (bucket instanceof RandomAccessBucket) {
            return (RandomAccessBucket)bucket;
        }
        if (bucket instanceof DelayedFreeBucket && (ret = ((DelayedFreeBucket)bucket).toRandomAccessBucket()) != null) {
            return ret;
        }
        ret = bf.makeBucket(bucket.size());
        BucketTools.copy(bucket, ret);
        bucket.free();
        return ret;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        ARRAY_FACTORY = new ArrayBucketFactory();
    }
}

