/*
 * Decompiled with CFR 0.152.
 */
package freenet.store;

import freenet.crypt.DSAPublicKey;
import freenet.keys.KeyVerifyException;
import freenet.node.stats.StoreAccessStats;
import freenet.store.BlockMetadata;
import freenet.store.FreenetStore;
import freenet.store.StorableBlock;
import java.io.IOException;

public abstract class StoreCallback<T extends StorableBlock> {
    protected FreenetStore<T> store;

    public abstract int dataLength();

    public abstract int headerLength();

    public abstract int routingKeyLength();

    public abstract boolean storeFullKeys();

    public abstract boolean constructNeedsKey();

    public abstract int fullKeyLength();

    public abstract boolean collisionPossible();

    public void setStore(FreenetStore<T> store) {
        this.store = store;
    }

    public FreenetStore<T> getStore() {
        return this.store;
    }

    public abstract T construct(byte[] var1, byte[] var2, byte[] var3, byte[] var4, boolean var5, boolean var6, BlockMetadata var7, DSAPublicKey var8) throws KeyVerifyException;

    public void setMaxKeys(long maxStoreKeys, boolean shrinkNow) throws IOException {
        this.store.setMaxKeys(maxStoreKeys, shrinkNow);
    }

    public long getMaxKeys() {
        return this.store.getMaxKeys();
    }

    public long hits() {
        return this.store.hits();
    }

    public long misses() {
        return this.store.misses();
    }

    public long writes() {
        return this.store.writes();
    }

    public long keyCount() {
        return this.store.keyCount();
    }

    public long getBloomFalsePositive() {
        return this.store.getBloomFalsePositive();
    }

    public abstract byte[] routingKeyFromFullKey(byte[] var1);

    public StoreAccessStats getSessionAccessStats() {
        return this.store.getSessionAccessStats();
    }

    public StoreAccessStats getTotalAccessStats() {
        return this.store.getTotalAccessStats();
    }

    public int getTotalBlockSize() {
        return this.dataLength() + this.headerLength() + this.fullKeyLength() + this.routingKeyLength();
    }
}

