/*
 * Decompiled with CFR 0.152.
 */
package freenet.store;

import freenet.crypt.CryptFormatException;
import freenet.crypt.DSAPublicKey;
import freenet.keys.KeyVerifyException;
import freenet.keys.PubkeyVerifyException;
import freenet.store.BlockMetadata;
import freenet.store.KeyCollisionException;
import freenet.store.StoreCallback;
import freenet.support.Logger;
import java.io.IOException;

public class PubkeyStore
extends StoreCallback<DSAPublicKey> {
    private static final byte[] empty = new byte[0];

    @Override
    public boolean collisionPossible() {
        return false;
    }

    @Override
    public DSAPublicKey construct(byte[] data, byte[] headers, byte[] routingKey, byte[] fullKey, boolean canReadClientCache, boolean canReadSlashdotCache, BlockMetadata meta, DSAPublicKey ignored) throws KeyVerifyException {
        if (data == null) {
            throw new PubkeyVerifyException("Need data to construct pubkey");
        }
        try {
            return DSAPublicKey.create(data);
        }
        catch (CryptFormatException e) {
            throw new PubkeyVerifyException(e);
        }
    }

    public DSAPublicKey fetch(byte[] hash, boolean dontPromote, boolean ignoreOldBlocks, BlockMetadata meta) throws IOException {
        return (DSAPublicKey)this.store.fetch(hash, null, dontPromote, false, false, ignoreOldBlocks, meta);
    }

    public void put(byte[] hash, DSAPublicKey key, boolean isOldBlock) throws IOException {
        try {
            this.store.put(key, key.asPaddedBytes(), empty, false, isOldBlock);
        }
        catch (KeyCollisionException e) {
            Logger.error(this, "Impossible for PubkeyStore: " + e, (Throwable)e);
        }
    }

    @Override
    public int dataLength() {
        return 1024;
    }

    @Override
    public int fullKeyLength() {
        return 32;
    }

    @Override
    public int headerLength() {
        return 0;
    }

    @Override
    public int routingKeyLength() {
        return 32;
    }

    @Override
    public boolean storeFullKeys() {
        return false;
    }

    @Override
    public boolean constructNeedsKey() {
        return false;
    }

    @Override
    public byte[] routingKeyFromFullKey(byte[] keyBuf) {
        return keyBuf;
    }
}

