/*
 * Decompiled with CFR 0.152.
 */
package freenet.pluginmanager;

import freenet.client.HighLevelSimpleClient;
import freenet.client.async.PersistenceDisabledException;
import freenet.client.filter.FilterCallback;
import freenet.clients.fcp.FCPPluginConnection;
import freenet.clients.http.PageMaker;
import freenet.clients.http.SessionManager;
import freenet.clients.http.ToadletContainer;
import freenet.config.SubConfig;
import freenet.node.Node;
import freenet.pluginmanager.FredPlugin;
import freenet.pluginmanager.FredPluginFCPMessageHandler;
import freenet.pluginmanager.FredPluginTalker;
import freenet.pluginmanager.PluginInfoWrapper;
import freenet.pluginmanager.PluginNotFoundException;
import freenet.pluginmanager.PluginStore;
import freenet.pluginmanager.PluginStores;
import freenet.pluginmanager.PluginTalker;
import freenet.support.HTMLNode;
import freenet.support.URIPreEncoder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.UUID;

public class PluginRespirator {
    private static final ArrayList<SessionManager> sessionManagers = new ArrayList(4);
    private final HighLevelSimpleClient hlsc;
    private final Node node;
    private final FredPlugin plugin;
    private final PluginInfoWrapper pi;
    private final PluginStores stores;
    private PluginStore store;

    public PluginRespirator(Node node, PluginInfoWrapper pi) {
        this.node = node;
        this.hlsc = node.clientCore.makeClient((short)1, false, false);
        this.plugin = pi.getPlugin();
        this.pi = pi;
        this.stores = node.clientCore.getPluginStores();
    }

    public HighLevelSimpleClient getHLSimpleClient() {
        return this.hlsc;
    }

    public Node getNode() {
        return this.node;
    }

    public FilterCallback makeFilterCallback(String path) {
        try {
            return this.node.clientCore.createFilterCallback(URIPreEncoder.encodeURI(path), null);
        }
        catch (URISyntaxException e) {
            throw new Error(e);
        }
    }

    public PageMaker getPageMaker() {
        ToadletContainer container = this.getToadletContainer();
        if (container == null) {
            return null;
        }
        return container.getPageMaker();
    }

    public HTMLNode addFormChild(HTMLNode parentNode, String target, String name) {
        HTMLNode formNode = parentNode.addChild("form", new String[]{"action", "method", "enctype", "id", "name", "accept-charset"}, new String[]{target, "post", "multipart/form-data", name, name, "utf-8"});
        formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "formPassword", this.node.clientCore.formPassword});
        return formNode;
    }

    @Deprecated
    public PluginTalker getPluginTalker(FredPluginTalker fpt, String pluginname, String identifier) throws PluginNotFoundException {
        return new PluginTalker(fpt, this.node, pluginname, identifier);
    }

    public FCPPluginConnection connectToOtherPlugin(String pluginName, FredPluginFCPMessageHandler.ClientSideFCPMessageHandler messageHandler) throws PluginNotFoundException {
        if (messageHandler == null) {
            throw new NullPointerException("messageHandler must not be null");
        }
        return this.node.clientCore.getFCPServer().createFCPPluginConnectionForIntraNodeFCP(pluginName, messageHandler);
    }

    public FCPPluginConnection getPluginConnectionByID(UUID connectionID) throws IOException {
        return this.node.clientCore.getFCPServer().getPluginConnectionByID(connectionID);
    }

    public ToadletContainer getToadletContainer() {
        return this.node.clientCore.getToadletContainer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginStore getStore() throws PersistenceDisabledException {
        PluginRespirator pluginRespirator = this;
        synchronized (pluginRespirator) {
            if (this.store != null) {
                return this.store;
            }
            this.store = this.stores.loadPluginStore(this.plugin.getClass().getCanonicalName());
            if (this.store == null) {
                this.store = new PluginStore();
            }
            return this.store;
        }
    }

    public void putStore(PluginStore store) throws PersistenceDisabledException {
        String name = this.plugin.getClass().getCanonicalName();
        try {
            this.stores.writePluginStore(name, store);
        }
        catch (IOException e) {
            System.err.println("Unable to write plugin data for " + name + " : " + e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public SessionManager getSessionManager(URI cookiePath) {
        ArrayList<SessionManager> arrayList = sessionManagers;
        synchronized (arrayList) {
            for (SessionManager m : sessionManagers) {
                if (!m.getCookiePath().equals(cookiePath)) continue;
                return m;
            }
            SessionManager m = new SessionManager(cookiePath);
            sessionManagers.add(m);
            return m;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionManager getSessionManager(String cookieNamespace) {
        ArrayList<SessionManager> arrayList = sessionManagers;
        synchronized (arrayList) {
            for (SessionManager m : sessionManagers) {
                if (!m.getCookieNamespace().equals(cookieNamespace)) continue;
                return m;
            }
            SessionManager m = new SessionManager(cookieNamespace);
            sessionManagers.add(m);
            return m;
        }
    }

    public SubConfig getSubConfig() {
        return this.pi.getSubConfig();
    }

    public void storeConfig() {
        this.pi.getConfig().store();
    }
}

