/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.updater;

import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.async.BinaryBlobWriter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetCallback;
import freenet.client.async.ClientGetter;
import freenet.keys.FreenetURI;
import freenet.node.NodeClientCore;
import freenet.node.RequestClient;
import freenet.node.RequestClientBuilder;
import freenet.support.Logger;
import freenet.support.io.FileBucket;
import freenet.support.io.FileUtil;
import java.io.File;
import java.io.IOException;

class LegacyJarFetcher
implements ClientGetCallback {
    final FreenetURI uri;
    final File tempFile;
    final File saveTo;
    final FileBucket blobBucket;
    final FetchContext ctx;
    final ClientGetter cg;
    final ClientContext context;
    private boolean fetched;
    private boolean failed;
    final LegacyFetchCallback cb;
    static final RequestClient client = new RequestClientBuilder().build();

    public LegacyJarFetcher(FreenetURI uri, File saveTo, NodeClientCore core, LegacyFetchCallback cb) {
        this.uri = uri;
        this.saveTo = saveTo;
        this.context = core.clientContext;
        this.cb = cb;
        this.ctx = core.makeClient((short)1, true, false).getFetchContext();
        this.ctx.allowSplitfiles = true;
        this.ctx.dontEnterImplicitArchives = false;
        this.ctx.maxNonSplitfileRetries = -1;
        this.ctx.maxSplitfileBlockRetries = -1;
        this.blobBucket = new FileBucket(saveTo, false, false, false, false);
        if (this.blobBucket.size() > 0L) {
            this.fetched = true;
            this.cg = null;
            this.tempFile = null;
        } else {
            File tmp;
            try {
                tmp = File.createTempFile(saveTo.getName(), ".updater.fblob.tmp", saveTo.getParentFile());
                tmp.deleteOnExit();
            }
            catch (IOException e) {
                Logger.error(this, "Cannot create temp file so cannot fetch legacy jar " + uri + " : UOM from old versions will not work!");
                this.cg = null;
                this.fetched = false;
                this.tempFile = null;
                return;
            }
            this.tempFile = tmp;
            this.cg = new ClientGetter(this, uri, this.ctx, 2, null, new BinaryBlobWriter(new FileBucket(this.tempFile, false, false, false, false)));
            this.fetched = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        boolean f;
        LegacyJarFetcher legacyJarFetcher = this;
        synchronized (legacyJarFetcher) {
            f = this.fetched;
        }
        if (f) {
            this.cb.onSuccess(this);
        } else {
            try {
                this.cg.start(this.context);
            }
            catch (FetchException e) {
                LegacyJarFetcher legacyJarFetcher2 = this;
                synchronized (legacyJarFetcher2) {
                    this.failed = true;
                }
                this.cb.onFailure(e, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LegacyJarFetcher legacyJarFetcher = this;
        synchronized (legacyJarFetcher) {
            if (this.fetched) {
                return;
            }
        }
        this.cg.cancel(this.context);
    }

    public long getBlobSize() {
        if (this.failed || !this.fetched) {
            Logger.error(this, "Asking for blob size but failed=" + this.failed + " fetched=" + this.fetched);
            return -1L;
        }
        return this.blobBucket.size();
    }

    public File getBlobFile() {
        if (this.failed || !this.fetched) {
            Logger.error(this, "Asking for blob but failed=" + this.failed + " fetched=" + this.fetched);
            return null;
        }
        return this.saveTo;
    }

    public synchronized boolean fetched() {
        return this.fetched;
    }

    public synchronized boolean failed() {
        return this.failed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess(FetchResult result, ClientGetter state) {
        result.asBucket().free();
        if (!FileUtil.renameTo(this.tempFile, this.saveTo)) {
            Logger.error(this, "Fetched file but unable to rename temp file " + this.tempFile + " to " + this.saveTo + " : UOM FROM OLD NODES WILL NOT WORK!");
        } else {
            LegacyJarFetcher legacyJarFetcher = this;
            synchronized (legacyJarFetcher) {
                this.fetched = true;
            }
            this.cb.onSuccess(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(FetchException e, ClientGetter state) {
        LegacyJarFetcher legacyJarFetcher = this;
        synchronized (legacyJarFetcher) {
            this.failed = true;
        }
        this.tempFile.delete();
        this.cb.onFailure(e, this);
    }

    @Override
    public void onResume(ClientContext context) {
    }

    @Override
    public RequestClient getRequestClient() {
        return client;
    }

    static interface LegacyFetchCallback {
        public void onSuccess(LegacyJarFetcher var1);

        public void onFailure(FetchException var1, LegacyJarFetcher var2);
    }
}

