/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.ClientRequester;
import freenet.client.async.PersistentJob;
import freenet.client.async.SimpleSingleFileFetcher;
import freenet.client.async.WantsCooldownCallback;
import freenet.keys.ClientKey;
import freenet.keys.Key;
import freenet.node.BaseSendableGet;
import freenet.node.LowLevelGetException;
import freenet.node.RequestScheduler;
import freenet.node.SendableGetRequestSender;
import freenet.node.SendableRequestItem;
import freenet.node.SendableRequestSender;
import freenet.support.Logger;
import freenet.support.io.NativeThread;

public abstract class SendableGet
extends BaseSendableGet {
    private static final long serialVersionUID = 1L;
    public final ClientRequester parent;
    static final SendableGetRequestSender sender = new SendableGetRequestSender();

    public abstract ClientKey getKey(SendableRequestItem var1);

    @Override
    public Key getNodeKey(SendableRequestItem token) {
        ClientKey key = this.getKey(token);
        if (key == null) {
            return null;
        }
        return key.getNodeKey(true);
    }

    public abstract Key[] listKeys();

    public abstract FetchContext getContext();

    public abstract void onFailure(LowLevelGetException var1, SendableRequestItem var2, ClientContext var3);

    public SendableGet(ClientRequester parent, boolean realTimeFlag) {
        super(parent.persistent(), realTimeFlag);
        this.parent = parent;
    }

    @Override
    public SendableRequestSender getSender(ClientContext context) {
        return sender;
    }

    @Override
    public ClientRequestScheduler getScheduler(ClientContext context) {
        if (this.isSSK()) {
            return context.getSskFetchScheduler(this.realTimeFlag);
        }
        return context.getChkFetchScheduler(this.realTimeFlag);
    }

    public abstract long getCooldownWakeup(SendableRequestItem var1, ClientContext var2);

    @Override
    public void internalError(Throwable t, RequestScheduler sched, ClientContext context, boolean persistent) {
        Logger.error(this, "Internal error on " + this + " : " + t, t);
        sched.callFailure(this, new LowLevelGetException(3, t.getMessage(), t), NativeThread.MAX_PRIORITY, persistent);
    }

    @Override
    public final boolean isInsert() {
        return false;
    }

    @Override
    public void unregister(ClientContext context, short oldPrio) {
        super.unregister(context, oldPrio);
        ClientRequestScheduler scheduler = this.getScheduler(context);
        context.checker.removeRequest(this, this.persistent, context, oldPrio == -1 ? this.getPriorityClass() : oldPrio);
    }

    public static FetchException translateException(LowLevelGetException e) {
        switch (e.code) {
            case 2: 
            case 4: {
                return new FetchException(FetchException.FetchExceptionMode.DATA_NOT_FOUND);
            }
            case 10: {
                return new FetchException(FetchException.FetchExceptionMode.RECENTLY_FAILED);
            }
            case 1: {
                return new FetchException(FetchException.FetchExceptionMode.BLOCK_DECODE_ERROR);
            }
            case 3: {
                return new FetchException(FetchException.FetchExceptionMode.INTERNAL_ERROR);
            }
            case 6: {
                return new FetchException(FetchException.FetchExceptionMode.REJECTED_OVERLOAD);
            }
            case 5: {
                return new FetchException(FetchException.FetchExceptionMode.ROUTE_NOT_FOUND);
            }
            case 7: {
                return new FetchException(FetchException.FetchExceptionMode.TRANSFER_FAILED);
            }
            case 8: {
                return new FetchException(FetchException.FetchExceptionMode.BLOCK_DECODE_ERROR);
            }
            case 9: {
                return new FetchException(FetchException.FetchExceptionMode.CANCELLED);
            }
        }
        Logger.error(SimpleSingleFileFetcher.class, "Unknown LowLevelGetException code: " + e.code);
        return new FetchException(FetchException.FetchExceptionMode.INTERNAL_ERROR, "Unknown error code: " + e.code);
    }

    @Override
    public boolean reduceWakeupTime(final long wakeupTime, ClientContext context) {
        boolean ret = super.reduceWakeupTime(wakeupTime, context);
        if (this.parent instanceof WantsCooldownCallback) {
            context.getJobRunner(this.persistent).queueNormalOrDrop(new PersistentJob(){

                @Override
                public boolean run(ClientContext context) {
                    ((WantsCooldownCallback)((Object)SendableGet.this.parent)).enterCooldown(SendableGet.this.getClientGetState(), wakeupTime, context);
                    return false;
                }
            });
        }
        return ret;
    }

    @Override
    public void clearWakeupTime(ClientContext context) {
        super.clearWakeupTime(context);
        if (this.parent instanceof WantsCooldownCallback) {
            context.getJobRunner(this.persistent).queueNormalOrDrop(new PersistentJob(){

                @Override
                public boolean run(ClientContext context) {
                    ((WantsCooldownCallback)((Object)SendableGet.this.parent)).clearCooldown(SendableGet.this.getClientGetState());
                    return false;
                }
            });
        }
    }

    protected abstract ClientGetState getClientGetState();
}

