/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.Message;
import freenet.io.comm.NotConnectedException;
import freenet.io.xfer.BlockTransmitter;
import freenet.io.xfer.PartiallyReceivedBlock;
import freenet.keys.CHKBlock;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.NodeCHK;
import freenet.keys.NodeSSK;
import freenet.keys.SSKBlock;
import freenet.node.FailureTableEntry;
import freenet.node.Node;
import freenet.node.OfferReplyTag;
import freenet.node.PeerNode;
import freenet.node.PrioRunnable;
import freenet.node.SyncSendWaitedTooLongException;
import freenet.node.TimedOutNodesList;
import freenet.support.LRUMap;
import freenet.support.ListUtils;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SerialExecutor;
import freenet.support.io.NativeThread;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class FailureTable {
    private static volatile boolean logMINOR;
    private final LRUMap<Key, FailureTableEntry> entriesByKey;
    private final LRUMap<Key, BlockOfferList> blockOfferListByKey;
    private final Node node;
    static final int MAX_ENTRIES = 20000;
    static final int MAX_OFFERS = 10000;
    static final long REJECT_TIME;
    static final long RECENTLY_FAILED_TIME;
    static final long MAX_LIFETIME;
    static final long OFFER_EXPIRY_TIME;
    final byte[] offerAuthenticatorKey;
    static final long CLEANUP_PERIOD;
    private final SerialExecutor offerExecutor;
    public final OfferedKeysByteCounter senderCounter = new OfferedKeysByteCounter();

    FailureTable(Node node) {
        this.entriesByKey = LRUMap.createSafeMap();
        this.blockOfferListByKey = LRUMap.createSafeMap();
        this.node = node;
        this.offerAuthenticatorKey = new byte[32];
        node.random.nextBytes(this.offerAuthenticatorKey);
        this.offerExecutor = new SerialExecutor(NativeThread.HIGH_PRIORITY);
        node.ticker.queueTimedJob(new FailureTableCleaner(), CLEANUP_PERIOD);
    }

    public void start() {
        this.offerExecutor.start(this.node.executor, "FailureTable offers executor for " + this.node.getDarknetPortNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailed(Key key, PeerNode routedTo, short htl, long rfTimeout, long ftTimeout) {
        if (ftTimeout < 0L || ftTimeout > REJECT_TIME) {
            Logger.error(this, "Bogus timeout " + ftTimeout, (Throwable)new Exception("error"));
            ftTimeout = Math.max(Math.min(REJECT_TIME, ftTimeout), 0L);
        }
        if (rfTimeout < 0L || rfTimeout > RECENTLY_FAILED_TIME) {
            if (rfTimeout > 0L) {
                Logger.error(this, "Bogus timeout " + rfTimeout, (Throwable)new Exception("error"));
            }
            rfTimeout = Math.max(Math.min(RECENTLY_FAILED_TIME, rfTimeout), 0L);
        }
        if (!this.node.enableULPRDataPropagation && !this.node.enablePerNodeFailureTables) {
            return;
        }
        long now = System.currentTimeMillis();
        FailureTable failureTable = this;
        synchronized (failureTable) {
            FailureTableEntry entry = this.entriesByKey.get(key);
            if (entry == null) {
                entry = new FailureTableEntry(key);
            }
            this.entriesByKey.push(key, entry);
            entry.failedTo(routedTo, rfTimeout, ftTimeout, now, htl);
            this.trimEntries(now);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFinalFailure(Key key, PeerNode routedTo, short htl, short origHTL, long rfTimeout, long ftTimeout, PeerNode requestor) {
        if (ftTimeout < -1L || ftTimeout > REJECT_TIME) {
            Logger.error(this, "Bogus timeout " + ftTimeout, (Throwable)new Exception("error"));
            ftTimeout = Math.max(Math.min(REJECT_TIME, ftTimeout), 0L);
        }
        if (rfTimeout < 0L || rfTimeout > RECENTLY_FAILED_TIME) {
            if (rfTimeout > 0L) {
                Logger.error(this, "Bogus timeout " + rfTimeout, (Throwable)new Exception("error"));
            }
            rfTimeout = Math.max(Math.min(RECENTLY_FAILED_TIME, rfTimeout), 0L);
        }
        if (!this.node.enableULPRDataPropagation && !this.node.enablePerNodeFailureTables) {
            return;
        }
        long now = System.currentTimeMillis();
        FailureTable failureTable = this;
        synchronized (failureTable) {
            FailureTableEntry entry = this.entriesByKey.get(key);
            if (entry == null) {
                entry = new FailureTableEntry(key);
            }
            this.entriesByKey.push(key, entry);
            if (routedTo != null) {
                entry.failedTo(routedTo, rfTimeout, ftTimeout, now, htl);
            }
            if (requestor != null) {
                entry.addRequestor(requestor, now, origHTL);
            }
            this.trimEntries(now);
        }
    }

    private synchronized void trimEntries(long now) {
        while (this.entriesByKey.size() > 20000) {
            this.entriesByKey.popKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFound(KeyBlock block) {
        FailureTableEntry entry;
        if (logMINOR) {
            Logger.minor(this, "Found " + block.getKey());
        }
        if (!this.node.enableULPRDataPropagation && !this.node.enablePerNodeFailureTables) {
            if (logMINOR) {
                Logger.minor(this, "Ignoring onFound because enable ULPR = " + this.node.enableULPRDataPropagation + " and enable failure tables = " + this.node.enablePerNodeFailureTables);
            }
            return;
        }
        Key key = block.getKey();
        if (key == null) {
            throw new NullPointerException();
        }
        Object object = this.blockOfferListByKey;
        synchronized (object) {
            this.blockOfferListByKey.removeKey(key);
        }
        object = this;
        synchronized (object) {
            entry = this.entriesByKey.get(key);
            if (entry == null) {
                if (logMINOR) {
                    Logger.minor(this, "Key not found in entriesByKey");
                }
                return;
            }
            this.entriesByKey.removeKey(key);
        }
        if (logMINOR) {
            Logger.minor(this, "Offering key");
        }
        if (!this.node.enableULPRDataPropagation) {
            return;
        }
        entry.offer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onOffer(final Key key, final PeerNode peer, final byte[] authenticator) {
        if (!this.node.enableULPRDataPropagation) {
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Offered key " + key + " by peer " + peer);
        }
        FailureTable failureTable = this;
        synchronized (failureTable) {
            FailureTableEntry entry = this.entriesByKey.get(key);
            if (entry == null) {
                if (logMINOR) {
                    Logger.minor(this, "We didn't ask for the key");
                }
                return;
            }
        }
        this.offerExecutor.execute(new Runnable(){

            @Override
            public void run() {
                FailureTable.this.innerOnOffer(key, peer, authenticator);
            }
        }, "onOffer()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void innerOnOffer(Key key, PeerNode peer, byte[] authenticator) {
        Object object;
        FailureTableEntry entry;
        if (logMINOR) {
            Logger.minor(this, "Inner on offer for " + key + " from " + peer + " on " + this.node.getDarknetPortNumber());
        }
        if (key.getRoutingKey() == null) {
            throw new NullPointerException();
        }
        if (this.node.hasKey(key, false, true)) {
            Logger.minor(this, "Already have key");
            return;
        }
        long now = System.currentTimeMillis();
        FailureTable failureTable = this;
        synchronized (failureTable) {
            entry = this.entriesByKey.get(key);
            if (entry == null) {
                if (logMINOR) {
                    Logger.minor(this, "We didn't ask for the key");
                }
                return;
            }
        }
        boolean weAsked = entry.askedFromPeer(peer, now);
        boolean heAsked = entry.askedByPeer(peer, now);
        if (!weAsked && !heAsked) {
            if (logMINOR) {
                Logger.minor(this, "Not propagating key: weAsked=" + weAsked + " heAsked=" + heAsked);
            }
            if (entry.isEmpty(now)) {
                FailureTable failureTable2 = this;
                synchronized (failureTable2) {
                    this.entriesByKey.removeKey(key);
                }
            }
            return;
        }
        if (entry.isEmpty(now)) {
            object = this;
            synchronized (object) {
                this.entriesByKey.removeKey(key);
            }
        }
        object = this.blockOfferListByKey;
        synchronized (object) {
            if (logMINOR) {
                Logger.minor(this, "Valid offer");
            }
            BlockOfferList bl = this.blockOfferListByKey.get(key);
            BlockOffer offer = new BlockOffer(peer, now, authenticator, peer.getBootID());
            if (bl == null) {
                bl = new BlockOfferList(entry, offer);
            } else {
                bl.addOffer(offer);
            }
            this.blockOfferListByKey.push(key, bl);
            this.trimOffersList(now);
        }
        this.node.clientCore.queueOfferedKey(key, false);
    }

    private void trimOffersList(long now) {
        LRUMap<Key, BlockOfferList> lRUMap = this.blockOfferListByKey;
        synchronized (lRUMap) {
            while (true) {
                if (this.blockOfferListByKey.isEmpty()) {
                    return;
                }
                BlockOfferList bl = this.blockOfferListByKey.peekValue();
                if (!bl.isEmpty(now) && bl.expires() >= now && this.blockOfferListByKey.size() <= 10000) break;
                if (logMINOR) {
                    Logger.minor(this, "Removing block offer list " + bl + " list size now " + this.blockOfferListByKey.size());
                }
                this.blockOfferListByKey.popKey();
            }
            return;
        }
    }

    public void sendOfferedKey(final Key key, final boolean isSSK, final boolean needPubKey, final long uid, final PeerNode source, final OfferReplyTag tag, final boolean realTimeFlag) throws NotConnectedException {
        this.offerExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    FailureTable.this.innerSendOfferedKey(key, isSSK, needPubKey, uid, source, tag, realTimeFlag);
                }
                catch (NotConnectedException e) {
                    tag.unlockHandler();
                }
                catch (Throwable t) {
                    tag.unlockHandler();
                    Logger.error(this, "Caught " + t + " sending offered key", t);
                }
            }
        }, "sendOfferedKey");
    }

    protected void innerSendOfferedKey(Key key, boolean isSSK, boolean needPubKey, long uid, final PeerNode source, final OfferReplyTag tag, final boolean realTimeFlag) throws NotConnectedException {
        if (isSSK) {
            SSKBlock block = this.node.fetch((NodeSSK)key, false, false, false, false, true, null);
            if (block == null) {
                source.sendAsync(DMT.createFNPGetOfferedKeyInvalid(uid, (short)2), null, this.senderCounter);
                tag.unlockHandler();
                return;
            }
            final Message data = DMT.createFNPSSKDataFoundData(uid, block.getRawData(), realTimeFlag);
            Message headers = DMT.createFNPSSKDataFoundHeaders(uid, block.getRawHeaders(), realTimeFlag);
            final int dataLength = block.getRawData().length;
            source.sendAsync(headers, null, this.senderCounter);
            this.node.executor.execute(new PrioRunnable(){

                @Override
                public int getPriority() {
                    return NativeThread.HIGH_PRIORITY;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        source.sendSync(data, FailureTable.this.senderCounter, realTimeFlag);
                        FailureTable.this.senderCounter.sentPayload(dataLength);
                    }
                    catch (NotConnectedException notConnectedException) {
                    }
                    catch (SyncSendWaitedTooLongException syncSendWaitedTooLongException) {
                    }
                    finally {
                        tag.unlockHandler();
                    }
                }
            }, "Send offered SSK");
            if (needPubKey) {
                Message pk = DMT.createFNPSSKPubKey(uid, block.getPubKey(), realTimeFlag);
                source.sendAsync(pk, null, this.senderCounter);
            }
        } else {
            CHKBlock block = this.node.fetch((NodeCHK)key, false, false, false, false, true, null);
            if (block == null) {
                source.sendAsync(DMT.createFNPGetOfferedKeyInvalid(uid, (short)2), null, this.senderCounter);
                tag.unlockHandler();
                return;
            }
            Message df = DMT.createFNPCHKDataFound(uid, block.getRawHeaders());
            source.sendAsync(df, null, this.senderCounter);
            PartiallyReceivedBlock prb = new PartiallyReceivedBlock(32, 1024, block.getRawData());
            final BlockTransmitter bt = new BlockTransmitter(this.node.usm, this.node.getTicker(), source, uid, prb, this.senderCounter, BlockTransmitter.NEVER_CASCADE, new BlockTransmitter.BlockTransmitterCompletion(){

                @Override
                public void blockTransferFinished(boolean success) {
                    tag.unlockHandler();
                }
            }, realTimeFlag, this.node.nodeStats);
            this.node.executor.execute(new PrioRunnable(){

                @Override
                public int getPriority() {
                    return NativeThread.HIGH_PRIORITY;
                }

                @Override
                public void run() {
                    bt.sendAsync();
                }
            }, "CHK offer sender");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hadAnyOffers(Key key) {
        LRUMap<Key, BlockOfferList> lRUMap = this.blockOfferListByKey;
        synchronized (lRUMap) {
            return this.blockOfferListByKey.get(key) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OfferList getOffers(Key key) {
        BlockOfferList bl;
        if (!this.node.enableULPRDataPropagation) {
            return null;
        }
        LRUMap<Key, BlockOfferList> lRUMap = this.blockOfferListByKey;
        synchronized (lRUMap) {
            bl = this.blockOfferListByKey.get(key);
            if (bl == null) {
                return null;
            }
        }
        return new OfferList(bl);
    }

    public void onDisconnect(PeerNode pn) {
        if (!this.node.enableULPRDataPropagation && !this.node.enablePerNodeFailureTables) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimedOutNodesList getTimedOutNodesList(Key key) {
        if (!this.node.enablePerNodeFailureTables) {
            return null;
        }
        FailureTable failureTable = this;
        synchronized (failureTable) {
            return this.entriesByKey.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean peersWantKey(Key key, PeerNode apartFrom) {
        FailureTableEntry entry;
        FailureTable failureTable = this;
        synchronized (failureTable) {
            entry = this.entriesByKey.get(key);
            if (entry == null) {
                return false;
            }
        }
        return entry.othersWant(apartFrom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short minOfferedHTL(Key key, short htl) {
        FailureTableEntry entry;
        FailureTable failureTable = this;
        synchronized (failureTable) {
            entry = this.entriesByKey.get(key);
            if (entry == null) {
                return htl;
            }
        }
        return entry.minRequestorHTL(htl);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        REJECT_TIME = TimeUnit.MINUTES.toMillis(10L);
        RECENTLY_FAILED_TIME = TimeUnit.MINUTES.toMillis(30L);
        MAX_LIFETIME = TimeUnit.MINUTES.toMillis(60L);
        OFFER_EXPIRY_TIME = TimeUnit.MINUTES.toMillis(10L);
        CLEANUP_PERIOD = TimeUnit.MINUTES.toMillis(10L);
    }

    public class FailureTableCleaner
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.realRun();
            }
            catch (Throwable t) {
                Logger.error(this, "FailureTableCleaner caught " + t, t);
            }
            finally {
                ((FailureTable)FailureTable.this).node.ticker.queueTimedJob(this, CLEANUP_PERIOD);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void realRun() {
            FailureTableEntry[] entries;
            if (logMINOR) {
                Logger.minor(this, "Starting FailureTable cleanup");
            }
            long startTime = System.currentTimeMillis();
            FailureTable failureTable = FailureTable.this;
            synchronized (failureTable) {
                entries = new FailureTableEntry[FailureTable.this.entriesByKey.size()];
                FailureTable.this.entriesByKey.valuesToArray(entries);
            }
            for (FailureTableEntry entry : entries) {
                if (!entry.cleanup()) continue;
                FailureTable failureTable2 = FailureTable.this;
                synchronized (failureTable2) {
                    FailureTableEntry failureTableEntry = entry;
                    synchronized (failureTableEntry) {
                        if (entry.isEmpty()) {
                            if (logMINOR) {
                                Logger.minor(this, "Removing entry for " + entry.key);
                            }
                            FailureTable.this.entriesByKey.removeKey(entry.key);
                        }
                    }
                }
            }
            long endTime = System.currentTimeMillis();
            if (logMINOR) {
                Logger.minor(this, "Finished FailureTable cleanup took " + (endTime - startTime) + "ms");
            }
        }
    }

    class OfferList {
        private final BlockOfferList offerList;
        private final List<BlockOffer> recentOffers;
        private final List<BlockOffer> expiredOffers;
        private BlockOffer lastOffer;

        OfferList(BlockOfferList offerList) {
            this.offerList = offerList;
            this.recentOffers = new ArrayList<BlockOffer>();
            this.expiredOffers = new ArrayList<BlockOffer>();
            long now = System.currentTimeMillis();
            for (BlockOffer offer : offerList.offers) {
                if (!offer.isExpired(now)) {
                    this.recentOffers.add(offer);
                    continue;
                }
                this.expiredOffers.add(offer);
            }
            if (logMINOR) {
                Logger.minor(this, "Offers: " + this.recentOffers.size() + " recent " + this.expiredOffers.size() + " expired");
            }
        }

        public BlockOffer getFirstOffer() {
            if (this.lastOffer != null) {
                throw new IllegalStateException("Last offer not dealt with");
            }
            if (!this.recentOffers.isEmpty()) {
                this.lastOffer = ListUtils.removeRandomBySwapLastSimple(((FailureTable)FailureTable.this).node.random, this.recentOffers);
                return this.lastOffer;
            }
            if (!this.expiredOffers.isEmpty()) {
                this.lastOffer = ListUtils.removeRandomBySwapLastSimple(((FailureTable)FailureTable.this).node.random, this.expiredOffers);
                return this.lastOffer;
            }
            return null;
        }

        public void deleteLastOffer() {
            this.offerList.deleteOffer(this.lastOffer);
            this.lastOffer = null;
        }

        public void keepLastOffer() {
            this.lastOffer = null;
        }
    }

    class OfferedKeysByteCounter
    implements ByteCounter {
        OfferedKeysByteCounter() {
        }

        @Override
        public void receivedBytes(int x) {
            ((FailureTable)FailureTable.this).node.nodeStats.offeredKeysSenderReceivedBytes(x);
        }

        @Override
        public void sentBytes(int x) {
            ((FailureTable)FailureTable.this).node.nodeStats.offeredKeysSenderSentBytes(x);
        }

        @Override
        public void sentPayload(int x) {
            FailureTable.this.node.sentPayload(x);
            ((FailureTable)FailureTable.this).node.nodeStats.offeredKeysSenderSentBytes(-x);
        }
    }

    static final class BlockOffer {
        final long offeredTime;
        final WeakReference<PeerNode> nodeRef;
        final byte[] authenticator;
        final long bootID;

        BlockOffer(PeerNode pn, long now, byte[] authenticator, long bootID) {
            this.nodeRef = pn.myRef;
            this.offeredTime = now;
            this.authenticator = authenticator;
            this.bootID = bootID;
        }

        public PeerNode getPeerNode() {
            return (PeerNode)this.nodeRef.get();
        }

        public boolean isExpired(long now) {
            return this.nodeRef.get() == null || now > this.offeredTime + OFFER_EXPIRY_TIME;
        }

        public boolean isExpired() {
            return this.isExpired(System.currentTimeMillis());
        }
    }

    private final class BlockOfferList {
        private BlockOffer[] offers;
        final FailureTableEntry entry;

        BlockOfferList(FailureTableEntry entry, BlockOffer offer) {
            this.entry = entry;
            this.offers = new BlockOffer[]{offer};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long expires() {
            LRUMap lRUMap = FailureTable.this.blockOfferListByKey;
            synchronized (lRUMap) {
                long last = 0L;
                for (BlockOffer offer : this.offers) {
                    if (offer.offeredTime <= last) continue;
                    last = offer.offeredTime;
                }
                return last + OFFER_EXPIRY_TIME;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty(long now) {
            LRUMap lRUMap = FailureTable.this.blockOfferListByKey;
            synchronized (lRUMap) {
                for (BlockOffer offer : this.offers) {
                    if (offer.isExpired(now)) continue;
                    return false;
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteOffer(BlockOffer offer) {
            if (logMINOR) {
                Logger.minor(this, "Deleting " + offer + " from " + this);
            }
            LRUMap lRUMap = FailureTable.this.blockOfferListByKey;
            synchronized (lRUMap) {
                int idx = -1;
                int offerLength = this.offers.length;
                for (int i = 0; i < offerLength; ++i) {
                    if (this.offers[i] != offer) continue;
                    idx = i;
                }
                if (idx < 0) {
                    return;
                }
                BlockOffer[] newOffers = new BlockOffer[offerLength - 1];
                if (idx > 0) {
                    System.arraycopy(this.offers, 0, newOffers, 0, idx);
                }
                if (idx < newOffers.length) {
                    System.arraycopy(this.offers, idx + 1, newOffers, idx, this.offers.length - idx - 1);
                }
                this.offers = newOffers;
                if (this.offers.length > 1) {
                    return;
                }
                FailureTable.this.blockOfferListByKey.removeKey(this.entry.key);
            }
            ((FailureTable)FailureTable.this).node.clientCore.dequeueOfferedKey(this.entry.key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addOffer(BlockOffer offer) {
            LRUMap lRUMap = FailureTable.this.blockOfferListByKey;
            synchronized (lRUMap) {
                this.offers = Arrays.copyOf(this.offers, this.offers.length + 1);
                this.offers[this.offers.length - 1] = offer;
            }
        }

        public String toString() {
            return super.toString() + "(" + this.offers.length + ")";
        }
    }
}

