/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.crypt.AEADCryptBucket;
import freenet.crypt.HMAC;
import freenet.crypt.RandomSource;
import freenet.support.api.Bucket;
import java.io.UnsupportedEncodingException;
import java.util.Random;
import org.bouncycastle.util.Arrays;

public class DatabaseKey {
    private final byte[] databaseKey;
    private final Random random;
    private static final byte[] PLUGIN;
    private static final byte[] CLIENT_LAYER;

    DatabaseKey(byte[] key, Random random) {
        this.databaseKey = Arrays.copyOf((byte[])key, (int)key.length);
        this.random = random;
    }

    public Bucket createEncryptedBucketForClientLayer(Bucket underlying) {
        return new AEADCryptBucket(underlying, this.getKeyForClientLayer());
    }

    public static DatabaseKey createRandom(RandomSource random) {
        byte[] databaseKey = new byte[32];
        random.nextBytes(databaseKey);
        return new DatabaseKey(databaseKey, random);
    }

    public byte[] getPluginStoreKey(String storeIdentifier) {
        try {
            byte[] id = storeIdentifier.getBytes("UTF-8");
            byte[] full = new byte[this.databaseKey.length + PLUGIN.length + id.length];
            int x = 0;
            System.arraycopy(this.databaseKey, 0, full, 0, this.databaseKey.length);
            System.arraycopy(PLUGIN, 0, full, x += this.databaseKey.length, PLUGIN.length);
            System.arraycopy(id, 0, full, x += PLUGIN.length, id.length);
            return HMAC.macWithSHA256(this.databaseKey, full);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public byte[] getKeyForClientLayer() {
        byte[] full = new byte[this.databaseKey.length + CLIENT_LAYER.length];
        int x = 0;
        System.arraycopy(this.databaseKey, 0, full, 0, this.databaseKey.length);
        System.arraycopy(CLIENT_LAYER, 0, full, x += this.databaseKey.length, CLIENT_LAYER.length);
        return HMAC.macWithSHA256(this.databaseKey, full);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + java.util.Arrays.hashCode(this.databaseKey);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DatabaseKey other = (DatabaseKey)obj;
        return java.util.Arrays.equals(this.databaseKey, other.databaseKey);
    }

    static {
        try {
            PLUGIN = "PLUGIN".getBytes("UTF-8");
            CLIENT_LAYER = "CLIENT".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }
}

