/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.Message;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.NotConnectedException;
import freenet.keys.Key;
import freenet.keys.NodeCHK;
import freenet.keys.NodeSSK;
import freenet.node.Node;
import freenet.node.NodeStats;
import freenet.node.PeerNode;
import freenet.node.SyncSendWaitedTooLongException;
import freenet.node.UIDTag;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.TimeUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;

public abstract class BaseSender
implements ByteCounter {
    private static volatile boolean logMINOR;
    final boolean realTimeFlag;
    final Key key;
    final PeerNode source;
    final double target;
    final boolean isSSK;
    protected final short origHTL;
    final Node node;
    protected final long startTime;
    long uid;
    static final long SEARCH_TIMEOUT_BULK;
    static final long SEARCH_TIMEOUT_REALTIME;
    final int incomingSearchTimeout;
    static final double EXTRA_HOPS_AT_BOTTOM = 4.0;
    protected PeerNode lastNode;
    protected HashSet<PeerNode> nodesRoutedTo = new HashSet();
    private long timeSentRequest;
    protected boolean hasForwarded;
    protected int gotMessages;
    protected String lastMessage;
    protected short htl;
    protected int rejectOverloads;
    protected int routeAttempts = 0;
    private HashMap<PeerNode, Integer> softRejectCount;
    protected boolean dontDecrementHTLThisTime;
    final boolean newLoadManagement;
    private static final int MAX_REJECTED_LOOPS = 3;
    private boolean addedExtraNode = false;
    private int rejectedLoops;

    BaseSender(Key key, boolean realTimeFlag, PeerNode source, Node node, short htl, long uid) {
        if (key.getRoutingKey() == null) {
            throw new NullPointerException();
        }
        this.startTime = System.currentTimeMillis();
        this.uid = uid;
        this.key = key;
        this.realTimeFlag = realTimeFlag;
        this.node = node;
        this.source = source;
        this.target = key.toNormalizedDouble();
        this.isSSK = key instanceof NodeSSK;
        assert (this.isSSK || key instanceof NodeCHK);
        this.htl = htl;
        this.origHTL = htl;
        this.newLoadManagement = node.enableNewLoadManagement(realTimeFlag);
        this.incomingSearchTimeout = BaseSender.calculateTimeout(realTimeFlag, htl, node);
    }

    public static int calculateTimeout(boolean realTimeFlag, short htl, Node node) {
        double timeout = realTimeFlag ? (double)SEARCH_TIMEOUT_REALTIME : (double)SEARCH_TIMEOUT_BULK;
        timeout = timeout * ((double)htl + 4.0) / (4.0 + (double)node.maxHTL());
        return (int)timeout;
    }

    protected int calculateTimeout(short htl) {
        return BaseSender.calculateTimeout(this.realTimeFlag, htl, this.node);
    }

    private short hopsForTime(long time) {
        double timeout = this.realTimeFlag ? (double)SEARCH_TIMEOUT_REALTIME : (double)SEARCH_TIMEOUT_BULK;
        double timePerHop = timeout / (4.0 + (double)this.node.maxHTL());
        return (short)Math.min((double)this.node.maxHTL(), (double)time / timePerHop);
    }

    protected abstract Message createDataRequest();

    public synchronized PeerNode routedLast() {
        return this.lastNode;
    }

    protected synchronized int timeSinceSent() {
        return (int)(System.currentTimeMillis() - this.timeSentRequest);
    }

    protected abstract void routeRequests();

    protected void innerRouteRequests(PeerNode next, UIDTag origTag) {
        if (this.newLoadManagement) {
            this.innerRouteRequestsNew(next, origTag);
        } else {
            this.innerRouteRequestsOld(next, origTag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void innerRouteRequestsOld(PeerNode next, UIDTag origTag) {
        DO action;
        BaseSender baseSender = this;
        synchronized (baseSender) {
            this.lastNode = next;
        }
        if (logMINOR) {
            Logger.minor(this, "Routing request to " + next);
        }
        this.nodesRoutedTo.add(next);
        Message req = this.createDataRequest();
        BaseSender baseSender2 = this;
        synchronized (baseSender2) {
            this.timeSentRequest = System.currentTimeMillis();
        }
        origTag.addRoutedTo(next, false);
        try {
            next.sendSync(req, this, this.realTimeFlag);
            next.reportRoutedTo(this.key.toNormalizedDouble(), this.source == null, this.realTimeFlag, this.source, this.nodesRoutedTo, this.htl);
            this.node.peers.incrementSelectionSamples(System.currentTimeMillis(), next);
        }
        catch (NotConnectedException e) {
            Logger.minor(this, "Not connected");
            next.noLongerRoutingTo(origTag, false);
            this.routeRequests();
            return;
        }
        catch (SyncSendWaitedTooLongException e) {
            Logger.error(this, "Failed to send " + req + " to " + next + " in a reasonable time.");
            next.noLongerRoutingTo(origTag, false);
            this.routeRequests();
            return;
        }
        BaseSender e = this;
        synchronized (e) {
            this.hasForwarded = true;
        }
        while ((action = this.waitForAccepted(null, next, origTag)) == DO.WAIT) {
        }
        if (action == DO.NEXT_PEER) {
            this.routeRequests();
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Got Accepted");
        }
        this.gotMessages = 0;
        this.lastMessage = null;
        this.onAccepted(next);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void innerRouteRequestsNew(PeerNode next, UIDTag origTag) {
        DO action;
        NodeStats.RequestType type = this.isSSK ? NodeStats.RequestType.SSK_REQUEST : NodeStats.RequestType.CHK_REQUEST;
        int tryCount = 0;
        long startedTryingPeer = System.currentTimeMillis();
        boolean waitedForLoadManagement = false;
        boolean retriedForLoadManagement = false;
        PeerNode.SlotWaiter waiter = null;
        PeerNode lastNext = null;
        PeerNode.RequestLikelyAcceptedState lastExpectedAcceptState = null;
        PeerNode.RequestLikelyAcceptedState expectedAcceptState = null;
        while (true) {
            boolean canRerouteWhileWaiting = true;
            BaseSender baseSender = this;
            synchronized (baseSender) {
                if (this.rejectedLoops > 3) {
                    canRerouteWhileWaiting = false;
                }
            }
            if (logMINOR) {
                Logger.minor(this, "Going around loop");
            }
            long now = System.currentTimeMillis();
            if (next == null) {
                this.dontDecrementHTLThisTime = true;
                this.routeRequests();
                return;
            }
            expectedAcceptState = next.outputLoadTracker(this.realTimeFlag).tryRouteTo(origTag, PeerNode.RequestLikelyAcceptedState.LIKELY, false);
            if (expectedAcceptState == PeerNode.RequestLikelyAcceptedState.UNKNOWN) {
                if (logMINOR) {
                    Logger.minor(this, "No load stats for " + next);
                }
            } else {
                PeerNode matched;
                PeerNode alsoWaitFor;
                HashSet<PeerNode> exclude;
                if (expectedAcceptState != null) {
                    if (logMINOR) {
                        Logger.minor(this, "Predicted accept state for " + this + " : " + (Object)((Object)expectedAcceptState) + " realtime=" + this.realTimeFlag);
                    }
                    if (lastNext == next && lastExpectedAcceptState == PeerNode.RequestLikelyAcceptedState.GUARANTEED && expectedAcceptState == PeerNode.RequestLikelyAcceptedState.GUARANTEED) {
                        Logger.warning(this, "Rejected overload (last time) yet expected state was " + lastExpectedAcceptState + " is now " + (Object)((Object)expectedAcceptState) + " from " + next.shortToString() + " (" + next.getVersionNumber() + ")");
                        next.rejectedGuaranteed(this.realTimeFlag);
                        next.noLongerRoutingTo(origTag, false);
                        expectedAcceptState = null;
                        this.dontDecrementHTLThisTime = true;
                        this.routeRequests();
                        return;
                    }
                }
                int canWaitFor = 1;
                if (expectedAcceptState == null) {
                    if (logMINOR) {
                        Logger.minor(this, "Cannot send to " + next + " realtime=" + this.realTimeFlag);
                    }
                    waitedForLoadManagement = true;
                    if (waiter == null) {
                        waiter = PeerNode.createSlotWaiter(origTag, type, false, this.realTimeFlag, this.source);
                    }
                    if (next != null && !waiter.addWaitingFor(next)) {
                        this.dontDecrementHTLThisTime = true;
                        this.routeRequests();
                        return;
                    }
                    if (next.isLowCapacity(this.realTimeFlag) && waiter.waitingForCount() == 1 && canRerouteWhileWaiting) {
                        ++canWaitFor;
                        exclude = waiter.waitingForList();
                        exclude.addAll(this.nodesRoutedTo);
                        alsoWaitFor = this.closerPeer(exclude, now, true);
                        if (alsoWaitFor != null) {
                            waiter.addWaitingFor(alsoWaitFor);
                            if (logMINOR) {
                                Logger.minor(this, "Waiting for " + next + " and " + alsoWaitFor + " on " + waiter + " because realtime");
                            }
                            try {
                                matched = waiter.waitForAny(0L, false);
                            }
                            catch (PeerNode.SlotWaiterFailedException e) {
                                if (!logMINOR) continue;
                                Logger.minor(this, "Rerouting as slot waiter failed...");
                                continue;
                            }
                            if (matched != null) {
                                expectedAcceptState = waiter.getAcceptedState();
                                next = matched;
                                if (logMINOR) {
                                    Logger.minor(this, "Matched " + matched + " with " + (Object)((Object)expectedAcceptState));
                                }
                            }
                        }
                    }
                }
                if (this.realTimeFlag) {
                    ++canWaitFor;
                }
                if (expectedAcceptState == null && waiter.waitingForCount() <= canWaitFor && canRerouteWhileWaiting) {
                    exclude = waiter.waitingForList();
                    exclude.addAll(this.nodesRoutedTo);
                    alsoWaitFor = this.closerPeer(exclude, now, true);
                    if (alsoWaitFor != null) {
                        waiter.addWaitingFor(alsoWaitFor);
                        if (logMINOR) {
                            Logger.minor(this, "Waiting for " + next + " and " + alsoWaitFor + " on " + waiter + " because realtime");
                        }
                        try {
                            matched = waiter.waitForAny(0L, false);
                        }
                        catch (PeerNode.SlotWaiterFailedException e) {
                            if (!logMINOR) continue;
                            Logger.minor(this, "Rerouting as slot waiter failed...");
                            continue;
                        }
                        if (matched != null) {
                            expectedAcceptState = waiter.getAcceptedState();
                            next = matched;
                            if (logMINOR) {
                                Logger.minor(this, "Matched " + matched + " with " + (Object)((Object)expectedAcceptState));
                            }
                        }
                    }
                }
                if (this.addedExtraNode) {
                    ++canWaitFor;
                }
                if (expectedAcceptState == null && waiter.waitingForCount() <= canWaitFor && canRerouteWhileWaiting) {
                    exclude = waiter.waitingForList();
                    exclude.addAll(this.nodesRoutedTo);
                    alsoWaitFor = this.closerPeer(exclude, now, true);
                    if (alsoWaitFor != null) {
                        waiter.addWaitingFor(alsoWaitFor);
                        if (logMINOR) {
                            Logger.minor(this, "Waiting for " + next + " and " + alsoWaitFor + " on " + waiter + " because realtime");
                        }
                        try {
                            matched = waiter.waitForAny(0L, false);
                        }
                        catch (PeerNode.SlotWaiterFailedException e) {
                            continue;
                        }
                        if (matched != null) {
                            expectedAcceptState = waiter.getAcceptedState();
                            next = matched;
                        }
                    }
                }
                if (expectedAcceptState == null) {
                    PeerNode waited;
                    long maxWait = this.getLongSlotWaiterTimeout();
                    if (!this.addedExtraNode) {
                        maxWait = this.getShortSlotWaiterTimeout();
                    }
                    HashSet<PeerNode> waitedFor = waiter.waitingForList();
                    try {
                        waited = waiter.waitForAny(maxWait, this.addedExtraNode);
                    }
                    catch (PeerNode.SlotWaiterFailedException e) {
                        continue;
                    }
                    if (waited == null) {
                        if (logMINOR) {
                            Logger.minor(this, "Timed out waiting for a peer to accept " + this + " on " + waiter);
                        }
                        if (this.addedExtraNode) {
                            this.timedOutWhileWaiting(this.getLoad(waitedFor));
                            return;
                        }
                        this.addedExtraNode = true;
                        continue;
                    }
                    next = waited;
                    expectedAcceptState = waiter.getAcceptedState();
                    long endTime = System.currentTimeMillis();
                    if (logMINOR) {
                        Logger.minor(this, "Sending to " + next + " after waited for " + TimeUtil.formatTime(endTime - this.startTime) + " realtime=" + this.realTimeFlag);
                    }
                    expectedAcceptState = waiter.getAcceptedState();
                }
                assert (expectedAcceptState != null);
                lastExpectedAcceptState = expectedAcceptState;
                lastNext = next;
                if (logMINOR) {
                    Logger.minor(this, "Leaving new load management big block: Predicted accept state for " + this + " : " + (Object)((Object)expectedAcceptState) + " realtime=" + this.realTimeFlag + " for " + next);
                }
            }
            if (logMINOR) {
                Logger.minor(this, "Routing to " + next);
            }
            if (origTag.hasSourceReallyRestarted()) {
                origTag.removeRoutingTo(next);
                this.routeRequests();
                return;
            }
            BaseSender canWaitFor = this;
            synchronized (canWaitFor) {
                this.lastNode = next;
            }
            if (logMINOR) {
                Logger.minor(this, "Routing request to " + next + " realtime=" + this.realTimeFlag);
            }
            this.nodesRoutedTo.add(next);
            Message req = this.createDataRequest();
            BaseSender maxWait = this;
            synchronized (maxWait) {
                this.timeSentRequest = System.currentTimeMillis();
            }
            origTag.addRoutedTo(next, false);
            ++tryCount;
            try {
                if (logMINOR) {
                    Logger.minor(this, "Sending " + req + " to " + next);
                }
                next.reportRoutedTo(this.key.toNormalizedDouble(), this.source == null, this.realTimeFlag, this.source, this.nodesRoutedTo, this.htl);
                next.sendSync(req, this, this.realTimeFlag);
            }
            catch (NotConnectedException e) {
                Logger.minor(this, "Not connected");
                next.noLongerRoutingTo(origTag, false);
                this.routeRequests();
                return;
            }
            catch (SyncSendWaitedTooLongException e) {
                Logger.error(this, "Failed to send " + req + " to " + next + " in a reasonable time.");
                next.noLongerRoutingTo(origTag, false);
                continue;
            }
            BaseSender e = this;
            synchronized (e) {
                this.hasForwarded = true;
            }
            if (logMINOR) {
                Logger.minor(this, "Waiting for accepted");
            }
            if ((action = this.waitForAccepted(expectedAcceptState, next, origTag)) != DO.WAIT) break;
            retriedForLoadManagement = true;
            if (!logMINOR) continue;
            Logger.minor(this, "Retrying");
        }
        if (action == DO.NEXT_PEER) {
            if (logMINOR) {
                Logger.minor(this, "Trying next peer");
            }
            this.routeRequests();
            return;
        }
        this.addedExtraNode = false;
        if (logMINOR) {
            Logger.minor(this, "Accepted!");
        }
        long now = System.currentTimeMillis();
        long delta = now - startedTryingPeer;
        this.logDelta(delta, tryCount, waitedForLoadManagement, retriedForLoadManagement);
        if (logMINOR) {
            Logger.minor(this, "Got Accepted");
        }
        this.gotMessages = 0;
        this.lastMessage = null;
        next.acceptedAny(this.realTimeFlag);
        this.onAccepted(next);
    }

    private PeerNode closerPeer(HashSet<PeerNode> exclude, long now, boolean newLoadManagement) {
        return this.node.peers.closerPeer(this.sourceForRouting(), exclude, this.target, true, this.node.isAdvancedModeEnabled(), -1, null, 2.0, this.isInsert() ? null : this.key, this.htl, this.ignoreLowBackoff(), this.source == null, this.realTimeFlag, null, false, now, newLoadManagement);
    }

    protected PeerNode sourceForRouting() {
        return this.source;
    }

    private double getLoad(HashSet<PeerNode> waitedFor) {
        double total = 0.0;
        for (PeerNode pn : waitedFor) {
            total += pn.outputLoadTracker(this.realTimeFlag).proportionTimingOutFatallyInWait();
        }
        return total / (double)waitedFor.size();
    }

    protected long getLongSlotWaiterTimeout() {
        return (this.realTimeFlag ? SEARCH_TIMEOUT_REALTIME : SEARCH_TIMEOUT_BULK) / 5L;
    }

    protected long getShortSlotWaiterTimeout() {
        return (this.realTimeFlag ? SEARCH_TIMEOUT_REALTIME : SEARCH_TIMEOUT_BULK) / 20L;
    }

    protected short hopsForFatalTimeoutWaitingForPeer() {
        return this.hopsForTime(this.getLongSlotWaiterTimeout());
    }

    private void logDelta(long delta, int tryCount, boolean waitedForLoadManagement, boolean retriedForLoadManagement) {
        long longTimeout = this.getLongSlotWaiterTimeout();
        if (delta > longTimeout || tryCount > 3) {
            Logger.error(this, "Took " + tryCount + " tries in " + TimeUtil.formatTime(delta, 2, true) + " waited=" + waitedForLoadManagement + " retried=" + retriedForLoadManagement + (this.realTimeFlag ? " (realtime)" : " (bulk)") + (this.source == null ? " (local)" : " (remote)"));
        } else if (delta > longTimeout / 5L || tryCount > 1) {
            Logger.warning(this, "Took " + tryCount + " tries in " + TimeUtil.formatTime(delta, 2, true) + " waited=" + waitedForLoadManagement + " retried=" + retriedForLoadManagement + (this.realTimeFlag ? " (realtime)" : " (bulk)") + (this.source == null ? " (local)" : " (remote)"));
        } else if (logMINOR && (waitedForLoadManagement || retriedForLoadManagement)) {
            Logger.minor(this, "Took " + tryCount + " tries in " + TimeUtil.formatTime(delta, 2, true) + " waited=" + waitedForLoadManagement + " retried=" + retriedForLoadManagement + (this.realTimeFlag ? " (realtime)" : " (bulk)") + (this.source == null ? " (local)" : " (remote)"));
        }
        this.node.nodeStats.reportNLMDelay(delta, this.realTimeFlag, this.source == null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DO waitForAccepted(PeerNode.RequestLikelyAcceptedState expectedAcceptState, PeerNode next, UIDTag origTag) {
        Message msg;
        while (true) {
            MessageFilter mf = this.makeAcceptedRejectedFilter(next, this.getAcceptedTimeout(), origTag);
            try {
                msg = this.node.usm.waitFor(mf, this);
                if (logMINOR) {
                    Logger.minor(this, "first part got " + msg);
                }
            }
            catch (DisconnectedException e) {
                Logger.normal(this, "Disconnected from " + next + " while waiting for Accepted on " + this.uid);
                next.noLongerRoutingTo(origTag, false);
                return DO.NEXT_PEER;
            }
            if (msg == null) {
                if (logMINOR) {
                    Logger.minor(this, "Timeout waiting for Accepted for " + this);
                }
                next.localRejectedOverload("AcceptedTimeout", this.realTimeFlag);
                this.forwardRejectedOverload();
                int t = this.timeSinceSent();
                this.node.failureTable.onFailed(this.key, next, this.htl, t, t);
                BaseSender baseSender = this;
                synchronized (baseSender) {
                    ++this.rejectedLoops;
                }
                this.handleAcceptedRejectedTimeout(next, origTag);
                return DO.NEXT_PEER;
            }
            if (msg.getSpec() == DMT.FNPRejectedLoop) {
                if (logMINOR) {
                    Logger.minor(this, "Rejected loop");
                }
                next.successNotOverload(this.realTimeFlag);
                int t = this.timeSinceSent();
                this.node.failureTable.onFailed(this.key, next, this.htl, t, t);
                next.noLongerRoutingTo(origTag, false);
                return DO.NEXT_PEER;
            }
            if (msg.getSpec() != DMT.FNPRejectedOverload) break;
            if (logMINOR) {
                Logger.minor(this, "Rejected: overload");
            }
            if (msg.getBoolean("isLocal")) {
                if (logMINOR) {
                    Logger.minor(this, "Is local");
                }
                if (msg.getSubMessage(DMT.FNPRejectIsSoft) != null && expectedAcceptState != null) {
                    Integer i;
                    if (logMINOR) {
                        Logger.minor(this, "Soft rejection, waiting to resend");
                    }
                    if (expectedAcceptState == PeerNode.RequestLikelyAcceptedState.GUARANTEED) {
                        Logger.normal(this, "Rejected overload yet expected state was " + (Object)((Object)expectedAcceptState));
                    }
                    this.nodesRoutedTo.remove(next);
                    next.noLongerRoutingTo(origTag, false);
                    if (this.softRejectCount == null) {
                        this.softRejectCount = new HashMap();
                    }
                    if ((i = this.softRejectCount.get(next)) == null) {
                        this.softRejectCount.put(next, 1);
                    } else {
                        this.softRejectCount.put(next, i + 1);
                        if (i > 3) {
                            Logger.error(this, "Rejected repeatedly (" + i + ") by " + next + " : " + this);
                            next.outputLoadTracker(this.realTimeFlag).setDontSendUnlessGuaranteed();
                        }
                    }
                    return DO.WAIT;
                }
                this.forwardRejectedOverload();
                next.localRejectedOverload("ForwardRejectedOverload", this.realTimeFlag);
                int t = this.timeSinceSent();
                this.node.failureTable.onFailed(this.key, next, this.htl, t, t);
                if (logMINOR) {
                    Logger.minor(this, "Local RejectedOverload, moving on to next peer");
                }
                next.noLongerRoutingTo(origTag, false);
                return DO.NEXT_PEER;
            }
            this.forwardRejectedOverload();
        }
        if (!this.isAccepted(msg)) {
            Logger.error(this, "Unrecognized message: " + msg);
            return DO.NEXT_PEER;
        }
        next.resetMandatoryBackoff(this.realTimeFlag);
        next.outputLoadTracker(this.realTimeFlag).clearDontSendUnlessGuaranteed();
        return DO.FINISHED;
    }

    protected abstract void handleAcceptedRejectedTimeout(PeerNode var1, UIDTag var2);

    protected boolean isAccepted(Message msg) {
        return msg.getSpec() == DMT.FNPAccepted;
    }

    protected abstract long getAcceptedTimeout();

    protected abstract void timedOutWhileWaiting(double var1);

    protected abstract void onAccepted(PeerNode var1);

    protected abstract MessageFilter makeAcceptedRejectedFilter(PeerNode var1, long var2, UIDTag var4);

    protected abstract void forwardRejectedOverload();

    protected abstract boolean isInsert();

    protected long ignoreLowBackoff() {
        return 0L;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        SEARCH_TIMEOUT_BULK = TimeUnit.MINUTES.toMillis(10L);
        SEARCH_TIMEOUT_REALTIME = TimeUnit.MINUTES.toMillis(1L);
    }

    protected static enum DO {
        FINISHED,
        WAIT,
        NEXT_PEER;

    }
}

