/*
 * Decompiled with CFR 0.152.
 */
package freenet.io.comm;

public enum TrafficClass {
    BEST_EFFORT(0),
    DSCP_CRITICAL(184),
    DSCP_AF11(40),
    DSCP_AF12(48),
    DSCP_AF13(56),
    DSCP_AF21(72),
    DSCP_AF22(80),
    DSCP_AF23(82),
    DSCP_AF31(88),
    DSCP_AF32(112),
    DSCP_AF33(120),
    DSCP_AF41(136),
    DSCP_AF42(144),
    DSCP_AF43(152),
    DSCP_CS0(0),
    DSCP_CS1(32),
    DSCP_CS2(64),
    DSCP_CS3(96),
    DSCP_CS4(128),
    DSCP_CS5(160),
    DSCP_CS6(192),
    DSCP_CS7(224),
    RFC1349_IPTOS_LOWCOST(2),
    RFC1349_IPTOS_RELIABILITY(4),
    RFC1349_IPTOS_THROUGHPUT(8),
    RFC1349_IPTOS_LOWDELAY(16);

    public final int value;

    private TrafficClass(int tc) {
        this.value = tc;
    }

    public static TrafficClass getDefault() {
        return DSCP_CS1;
    }

    public static TrafficClass fromNameOrValue(String tcName) {
        int tcParsed = -1;
        try {
            tcParsed = Integer.parseInt(tcName);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        for (TrafficClass t : TrafficClass.values()) {
            if (!t.toString().equalsIgnoreCase(tcName) && t.value != tcParsed) continue;
            return t;
        }
        throw new IllegalArgumentException();
    }
}

