/*
 * Decompiled with CFR 0.152.
 */
package freenet.io;

import freenet.io.AddressTrackerItem;
import freenet.io.comm.Peer;
import freenet.io.comm.PeerParseException;
import freenet.node.FSParseException;
import freenet.support.SimpleFieldSet;
import java.net.UnknownHostException;

public class PeerAddressTrackerItem
extends AddressTrackerItem {
    public final Peer peer;

    public PeerAddressTrackerItem(long timeDefinitelyNoPacketsReceived, long timeDefinitelyNoPacketsSent, Peer peer) {
        super(timeDefinitelyNoPacketsReceived, timeDefinitelyNoPacketsSent);
        this.peer = peer;
    }

    public PeerAddressTrackerItem(SimpleFieldSet fs) throws FSParseException {
        super(fs);
        try {
            this.peer = new Peer(fs.getString("Address"), false);
        }
        catch (UnknownHostException e) {
            throw (FSParseException)new FSParseException("Unknown domain name in Address: " + e).initCause(e);
        }
        catch (PeerParseException e) {
            throw new FSParseException(e);
        }
    }

    @Override
    public SimpleFieldSet toFieldSet() {
        SimpleFieldSet fs = super.toFieldSet();
        fs.putOverwrite("Address", this.peer.toStringPrefNumeric());
        return fs;
    }
}

