/*
 * Decompiled with CFR 0.152.
 */
package freenet.io;

import freenet.io.AddressIdentifier;
import freenet.io.AllowedHosts;
import freenet.support.Executor;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.io.Closeable;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.StringTokenizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.tanukisoftware.wrapper.WrapperManager;

public class NetworkInterface
implements Closeable {
    private static volatile boolean logMINOR;
    public static final String DEFAULT_BIND_TO = "127.0.0.1,0:0:0:0:0:0:0:1";
    private final Lock lock = new ReentrantLock();
    private final Condition boundCondition = this.lock.newCondition();
    private final Condition socketCondition = this.lock.newCondition();
    private final Condition acceptorClosedCondition = this.lock.newCondition();
    private final List<Acceptor> acceptors = new ArrayList<Acceptor>();
    private final Queue<Socket> acceptedSockets = new ArrayDeque<Socket>();
    protected final AllowedHosts allowedHosts;
    private int timeout = 0;
    private final int port;
    private int runningAcceptors = 0;
    private volatile boolean shutdown = false;
    private final Executor executor;
    static final int maxQueueLength = 100;

    public static NetworkInterface create(int port, String bindTo, String allowedHosts, Executor executor, boolean ignoreUnbindableIP6) throws IOException {
        NetworkInterface iface = new NetworkInterface(port, allowedHosts, executor);
        Object[] failedBind = iface.setBindTo(bindTo, ignoreUnbindableIP6);
        if (failedBind != null) {
            System.err.println("Could not bind to some of the interfaces specified for port " + port + " : " + Arrays.toString(failedBind));
        }
        return iface;
    }

    protected NetworkInterface(int port, String allowedHosts, Executor executor) throws IOException {
        this.port = port;
        this.allowedHosts = new AllowedHosts(allowedHosts);
        this.executor = executor;
    }

    protected ServerSocket createServerSocket() throws IOException {
        return new ServerSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] setBindTo(String bindTo, boolean ignoreUnbindableIP6) {
        if (bindTo == null || bindTo.equals("")) {
            bindTo = DEFAULT_BIND_TO;
        }
        StringTokenizer bindToTokens = new StringTokenizer(bindTo, ",");
        ArrayList<String> bindToTokenList = new ArrayList<String>();
        ArrayList<String> brokenList = null;
        while (bindToTokens.hasMoreTokens()) {
            bindToTokenList.add(bindToTokens.nextToken().trim());
        }
        for (Acceptor acceptor : this.grabAcceptors()) {
            try {
                acceptor.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.lock.lock();
        try {
            while (this.runningAcceptors > 0) {
                this.acceptorClosedCondition.awaitUninterruptibly();
                if (!this.shutdown && !WrapperManager.hasShutdownHookBeenTriggered()) continue;
                Acceptor[] arr$ = null;
                return arr$;
            }
        }
        finally {
            this.lock.unlock();
        }
        for (int serverSocketIndex = 0; serverSocketIndex < bindToTokenList.size(); ++serverSocketIndex) {
            InetSocketAddress addr = null;
            String address = (String)bindToTokenList.get(serverSocketIndex);
            try {
                ServerSocket serverSocket = this.createServerSocket();
                addr = new InetSocketAddress(address, this.port);
                serverSocket.setReuseAddress(true);
                serverSocket.bind(addr);
                Acceptor acceptor = new Acceptor(serverSocket);
                try {
                    acceptor.setSoTimeout(this.timeout);
                }
                catch (SocketException e) {
                    Logger.error(this, "Unable to setSoTimeout in setBindTo() on " + addr);
                }
                this.lock.lock();
                try {
                    this.acceptors.add(acceptor);
                    ++this.runningAcceptors;
                    this.executor.execute(acceptor, "Network Interface Acceptor for " + acceptor.serverSocket);
                    continue;
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (IOException e) {
                if (e instanceof SocketException && ignoreUnbindableIP6 && addr != null && addr.getAddress() instanceof Inet6Address) continue;
                System.err.println("Unable to bind to address " + address + " for port " + this.port);
                Logger.error(this, "Unable to bind to address " + address + " for port " + this.port);
                if (brokenList == null) {
                    brokenList = new ArrayList<String>();
                }
                brokenList.add(address);
            }
        }
        this.lock.lock();
        try {
            this.boundCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        return brokenList == null ? null : brokenList.toArray(new String[brokenList.size()]);
    }

    public void setAllowedHosts(String allowedHosts) {
        this.allowedHosts.setAllowedHosts(allowedHosts);
    }

    public void setSoTimeout(int timeout) throws SocketException {
        for (Acceptor acceptor : this.getAcceptors()) {
            acceptor.setSoTimeout(timeout);
        }
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket accept() {
        this.lock.lock();
        try {
            Socket socket;
            while ((socket = this.acceptedSockets.poll()) == null) {
                if (this.shutdown) {
                    Socket socket2 = null;
                    return socket2;
                }
                if (WrapperManager.hasShutdownHookBeenTriggered()) {
                    Socket socket3 = null;
                    return socket3;
                }
                if (this.acceptors.size() == 0) {
                    Socket socket4 = null;
                    return socket4;
                }
                this.socketCondition.awaitUninterruptibly();
                if (this.timeout <= 0) continue;
                socket = this.acceptedSockets.poll();
                break;
            }
            Socket socket5 = socket;
            return socket5;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        IOException exception = null;
        this.shutdown = true;
        for (Acceptor acceptor : this.grabAcceptors()) {
            try {
                acceptor.close();
            }
            catch (IOException ioe1) {
                exception = ioe1;
            }
        }
        this.lock.lock();
        try {
            this.boundCondition.signalAll();
            this.acceptorClosedCondition.signalAll();
            this.socketCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Acceptor[] grabAcceptors() {
        this.lock.lock();
        try {
            Acceptor[] oldAcceptors = this.acceptors.toArray(new Acceptor[this.acceptors.size()]);
            this.acceptors.clear();
            Acceptor[] acceptorArray = oldAcceptors;
            return acceptorArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Acceptor[] getAcceptors() {
        this.lock.lock();
        try {
            Acceptor[] acceptorArray = this.acceptors.toArray(new Acceptor[this.acceptors.size()]);
            return acceptorArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptorStopped() {
        this.lock.lock();
        try {
            --this.runningAcceptors;
            this.acceptorClosedCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getAllowedHosts() {
        return this.allowedHosts.getAllowedHosts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBound() {
        this.lock.lock();
        try {
            boolean bl = this.acceptors.size() != 0;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitBound() {
        this.lock.lock();
        try {
            if (this.acceptors.size() > 0) {
                return;
            }
            do {
                Logger.error(this, "Network interface isn't bound, waiting");
                this.boundCondition.awaitUninterruptibly();
                if (this.acceptors.size() > 0) {
                    Logger.error(this, "Finished waiting, network interface is now bound");
                    return;
                }
                if (!this.shutdown) continue;
                return;
            } while (!WrapperManager.hasShutdownHookBeenTriggered());
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    private class Acceptor
    implements Runnable {
        private final ServerSocket serverSocket;
        private boolean closed = false;

        public Acceptor(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
        }

        public void setSoTimeout(int timeout) throws SocketException {
            this.serverSocket.setSoTimeout(timeout);
        }

        public void close() throws IOException {
            this.closed = true;
            this.serverSocket.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Logger.OSThread.logPID(this);
            while (!this.closed) {
                try {
                    AddressIdentifier.AddressType clientAddressType;
                    Socket clientSocket = this.serverSocket.accept();
                    InetAddress clientAddress = clientSocket.getInetAddress();
                    if (logMINOR) {
                        Logger.minor(Acceptor.class, "Connection from " + clientAddress);
                    }
                    if (NetworkInterface.this.allowedHosts.allowed(clientAddressType = AddressIdentifier.getAddressType(clientAddress.getHostAddress()), clientAddress) && NetworkInterface.this.acceptedSockets.size() <= 100) {
                        NetworkInterface.this.lock.lock();
                        try {
                            NetworkInterface.this.acceptedSockets.add(clientSocket);
                            NetworkInterface.this.socketCondition.signalAll();
                            continue;
                        }
                        finally {
                            NetworkInterface.this.lock.unlock();
                            continue;
                        }
                    }
                    try {
                        clientSocket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    Logger.normal(Acceptor.class, "Denied connection to " + clientAddress);
                }
                catch (SocketTimeoutException ste1) {
                    if (!logMINOR) continue;
                    Logger.minor(this, "Timeout");
                }
                catch (IOException ioe1) {
                    if (!logMINOR) continue;
                    Logger.minor(this, "Caught " + ioe1);
                }
            }
            NetworkInterface.this.acceptorStopped();
        }
    }
}

