/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.CryptByteBufferType;
import freenet.crypt.KeyType;
import freenet.crypt.MACType;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.crypto.SkippingStreamCipher;
import org.bouncycastle.crypto.engines.ChaChaEngine;

public enum EncryptedRandomAccessBufferType {
    ChaCha128(1, 12, CryptByteBufferType.ChaCha128, MACType.HMACSHA256, 32),
    ChaCha256(2, 12, CryptByteBufferType.ChaCha256, MACType.HMACSHA256, 32);

    public final int bitmask;
    public final int headerLen;
    public final CryptByteBufferType encryptType;
    public final KeyType encryptKey;
    public final MACType macType;
    public final KeyType macKey;
    public final int macLen;
    private static final Map<Integer, EncryptedRandomAccessBufferType> byBitmask;

    private EncryptedRandomAccessBufferType(int bitmask, int magAndVerLen, CryptByteBufferType type, MACType macType, int macLen) {
        this.bitmask = bitmask;
        this.encryptType = type;
        this.encryptKey = type.keyType;
        this.macType = macType;
        this.macKey = macType.keyType;
        this.macLen = macLen;
        this.headerLen = magAndVerLen + (this.encryptKey.keySize >> 3) + (this.encryptKey.ivSize >> 3) + macLen;
    }

    public final SkippingStreamCipher get() {
        return new ChaChaEngine();
    }

    public static EncryptedRandomAccessBufferType getByBitmask(int val) {
        return byBitmask.get(val);
    }

    static {
        byBitmask = new HashMap<Integer, EncryptedRandomAccessBufferType>();
        for (EncryptedRandomAccessBufferType type : EncryptedRandomAccessBufferType.values()) {
            byBitmask.put(type.bitmask, type);
        }
    }
}

