/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.support.Fields;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Checksum;

public class ChecksumOutputStream
extends FilterOutputStream {
    final Checksum crc;
    private boolean closed;
    private final boolean writeChecksum;
    private final int skipPrefix;
    private int bytesInsidePrefix;

    public ChecksumOutputStream(OutputStream out, Checksum crc, boolean writeChecksum, int skipPrefix) {
        super(out);
        this.crc = crc;
        this.writeChecksum = writeChecksum;
        this.skipPrefix = skipPrefix;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.bytesInsidePrefix >= this.skipPrefix) {
            this.crc.update(b);
        } else {
            ++this.bytesInsidePrefix;
        }
        this.out.write(b);
    }

    @Override
    public void write(byte[] buf, int offset, int length) throws IOException {
        int chop = Math.min(this.skipPrefix - this.bytesInsidePrefix, length);
        if (chop <= 0) {
            this.crc.update(buf, offset, length);
            this.out.write(buf, offset, length);
        } else {
            if (length - chop > 0) {
                this.crc.update(buf, offset + chop, length - chop);
                this.bytesInsidePrefix = this.skipPrefix;
            } else {
                this.bytesInsidePrefix += length;
            }
            this.out.write(buf, offset, length);
        }
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.writeChecksum) {
            ChecksumOutputStream checksumOutputStream = this;
            synchronized (checksumOutputStream) {
                if (this.closed) {
                    throw new IOException("Already closed");
                }
                this.closed = true;
            }
            this.out.write(Fields.intToBytes((int)this.crc.getValue()));
        }
    }

    public long getValue() {
        return this.crc.getValue();
    }
}

