/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.bookmark;

import freenet.client.async.ClientContext;
import freenet.client.async.USKCallback;
import freenet.clients.http.FProxyToadlet;
import freenet.clients.http.bookmark.Bookmark;
import freenet.clients.http.bookmark.BookmarkCategory;
import freenet.clients.http.bookmark.BookmarkItem;
import freenet.keys.FreenetURI;
import freenet.keys.USK;
import freenet.l10n.NodeL10n;
import freenet.node.FSParseException;
import freenet.node.NodeClientCore;
import freenet.node.RequestClient;
import freenet.node.SemiOrderedShutdownHook;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.io.Closer;
import freenet.support.io.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class BookmarkManager
implements RequestClient {
    public static final SimpleFieldSet DEFAULT_BOOKMARKS;
    private final NodeClientCore node;
    private final USKUpdatedCallback uskCB = new USKUpdatedCallback();
    public static final BookmarkCategory MAIN_CATEGORY;
    public static final BookmarkCategory DEFAULT_CATEGORY;
    private final HashMap<String, Bookmark> bookmarks = new HashMap();
    private final File bookmarksFile;
    private final File backupBookmarksFile;
    private boolean isSavingBookmarks = false;
    private boolean isSavingBookmarksLazy = false;
    private static volatile boolean logMINOR;
    static final short PRIORITY = 4;
    static final short PRIORITY_PROGRESS = 3;

    public BookmarkManager(NodeClientCore n, boolean publicGateway) {
        this.putPaths("/", MAIN_CATEGORY);
        this.node = n;
        this.bookmarksFile = n.node.userDir().file("bookmarks.dat");
        this.backupBookmarksFile = n.node.userDir().file("bookmarks.dat.bak");
        try {
            if (!this.bookmarksFile.exists() || this.bookmarksFile.length() == 0L) {
                throw new IOException();
            }
            Logger.normal(this, "Attempting to read the bookmark file from " + this.bookmarksFile.toString());
            SimpleFieldSet sfs = SimpleFieldSet.readFrom(this.bookmarksFile, false, true);
            this.readBookmarks(MAIN_CATEGORY, sfs);
        }
        catch (MalformedURLException sfs) {
        }
        catch (IOException ioe) {
            Logger.error(this, "Error reading the bookmark file (" + this.bookmarksFile.toString() + "):" + ioe.getMessage(), (Throwable)ioe);
            try {
                if (this.backupBookmarksFile.exists() && this.backupBookmarksFile.canRead() && this.backupBookmarksFile.length() > 0L) {
                    Logger.normal(this, "Attempting to read the backup bookmark file from " + this.backupBookmarksFile.toString());
                    SimpleFieldSet sfs = SimpleFieldSet.readFrom(this.backupBookmarksFile, false, true);
                    this.readBookmarks(MAIN_CATEGORY, sfs);
                } else {
                    Logger.normal(this, "We couldn't find the backup either! - " + FileUtil.getCanonicalFile(this.backupBookmarksFile));
                    this.readBookmarks(MAIN_CATEGORY, DEFAULT_BOOKMARKS);
                }
            }
            catch (IOException e) {
                Logger.error(this, "Error reading the backup bookmark file !" + e.getMessage(), (Throwable)e);
            }
        }
        if (publicGateway) {
            this.putPaths("\\", DEFAULT_CATEGORY);
            this.readBookmarks(DEFAULT_CATEGORY, DEFAULT_BOOKMARKS);
        }
        SemiOrderedShutdownHook.get().addEarlyJob(new Thread(){
            BookmarkManager bm;
            {
                this.bm = BookmarkManager.this;
            }

            @Override
            public void run() {
                this.bm.storeBookmarks();
                this.bm = null;
            }
        });
    }

    public void reAddDefaultBookmarks() {
        BookmarkCategory bc = new BookmarkCategory(this.l10n("defaultBookmarks") + " - " + new Date());
        this.addBookmark("/", bc);
        this._innerReadBookmarks("/", bc, DEFAULT_BOOKMARKS);
    }

    public String l10n(String key) {
        return NodeL10n.getBase().getString("BookmarkManager." + key);
    }

    public String parentPath(String path) {
        if (path.equals("/")) {
            return "/";
        }
        return path.substring(0, path.substring(0, path.length() - 1).lastIndexOf(47)) + "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bookmark getBookmarkByPath(String path) {
        HashMap<String, Bookmark> hashMap = this.bookmarks;
        synchronized (hashMap) {
            return this.bookmarks.get(path);
        }
    }

    public BookmarkCategory getCategoryByPath(String path) {
        Bookmark cat = this.getBookmarkByPath(path);
        if (cat instanceof BookmarkCategory) {
            return (BookmarkCategory)cat;
        }
        return null;
    }

    public BookmarkItem getItemByPath(String path) {
        if (this.getBookmarkByPath(path) instanceof BookmarkItem) {
            return (BookmarkItem)this.getBookmarkByPath(path);
        }
        return null;
    }

    public void addBookmark(String parentPath, Bookmark bookmark) {
        if (logMINOR) {
            Logger.minor(this, "Adding bookmark " + bookmark + " to " + parentPath);
        }
        BookmarkCategory parent = this.getCategoryByPath(parentPath);
        parent.addBookmark(bookmark);
        this.putPaths(parentPath + bookmark.getName() + (bookmark instanceof BookmarkCategory ? "/" : ""), bookmark);
        if (bookmark instanceof BookmarkItem) {
            this.subscribeToUSK((BookmarkItem)bookmark);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameBookmark(String path, String newName) {
        Bookmark bookmark = this.getBookmarkByPath(path);
        String oldName = bookmark.getName();
        String oldPath = '/' + oldName;
        String newPath = path.substring(0, path.indexOf(oldPath)) + '/' + newName + (bookmark instanceof BookmarkCategory ? "/" : "");
        bookmark.setName(newName);
        HashMap<String, Bookmark> hashMap = this.bookmarks;
        synchronized (hashMap) {
            Iterator<String> it = this.bookmarks.keySet().iterator();
            while (it.hasNext()) {
                String s = it.next();
                if (!s.startsWith(path)) continue;
                it.remove();
            }
            this.putPaths(newPath, bookmark);
        }
        this.storeBookmarks();
    }

    public void moveBookmark(String bookmarkPath, String newParentPath) {
        Bookmark b = this.getBookmarkByPath(bookmarkPath);
        this.addBookmark(newParentPath, b);
        this.getCategoryByPath(this.parentPath(bookmarkPath)).removeBookmark(b);
        this.removePaths(bookmarkPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeBookmark(String path) {
        Bookmark bookmark = this.getBookmarkByPath(path);
        if (bookmark == null) {
            return;
        }
        if (!(bookmark instanceof BookmarkCategory)) {
            if (((BookmarkItem)bookmark).getKeyType().equals("USK")) {
                try {
                    USK u = ((BookmarkItem)bookmark).getUSK();
                    if (!this.wantUSK(u, (BookmarkItem)bookmark)) {
                        this.node.uskManager.unsubscribe(u, this.uskCB);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        } else {
            BookmarkCategory cat = (BookmarkCategory)bookmark;
            for (int i = 0; i < cat.size(); ++i) {
                this.removeBookmark(path + cat.get(i).getName() + (cat.get(i) instanceof BookmarkCategory ? "/" : ""));
            }
        }
        this.getCategoryByPath(this.parentPath(path)).removeBookmark(bookmark);
        HashMap<String, Bookmark> hashMap = this.bookmarks;
        synchronized (hashMap) {
            this.bookmarks.remove(path);
            return;
        }
    }

    private boolean wantUSK(USK u, BookmarkItem ignore) {
        List<BookmarkItem> items = MAIN_CATEGORY.getAllItems();
        for (BookmarkItem item : items) {
            if (item == ignore || !"USK".equals(item.getKeyType())) continue;
            try {
                FreenetURI furi = new FreenetURI(item.getKey());
                USK usk = USK.create(furi);
                if (!usk.equals(u, false)) continue;
                return true;
            }
            catch (MalformedURLException malformedURLException) {
            }
        }
        return false;
    }

    public void moveBookmarkUp(String path, boolean store) {
        BookmarkCategory parent = this.getCategoryByPath(this.parentPath(path));
        parent.moveBookmarkUp(this.getBookmarkByPath(path));
        if (store) {
            this.storeBookmarks();
        }
    }

    public void moveBookmarkDown(String path, boolean store) {
        BookmarkCategory parent = this.getCategoryByPath(this.parentPath(path));
        parent.moveBookmarkDown(this.getBookmarkByPath(path));
        if (store) {
            this.storeBookmarks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putPaths(String path, Bookmark b) {
        HashMap<String, Bookmark> hashMap = this.bookmarks;
        synchronized (hashMap) {
            this.bookmarks.put(path, b);
        }
        if (b instanceof BookmarkCategory) {
            for (int i = 0; i < ((BookmarkCategory)b).size(); ++i) {
                Bookmark child = ((BookmarkCategory)b).get(i);
                this.putPaths(path + child.getName() + (child instanceof BookmarkItem ? "" : "/"), child);
            }
        }
    }

    private void removePaths(String path) {
        if (this.getBookmarkByPath(path) instanceof BookmarkCategory) {
            BookmarkCategory cat = this.getCategoryByPath(path);
            for (int i = 0; i < cat.size(); ++i) {
                this.removePaths(path + cat.get(i).getName() + (cat.get(i) instanceof BookmarkCategory ? "/" : ""));
            }
        }
        this.bookmarks.remove(path);
    }

    public FreenetURI[] getBookmarkURIs() {
        List<BookmarkItem> items = MAIN_CATEGORY.getAllItems();
        FreenetURI[] uris = new FreenetURI[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            uris[i] = items.get(i).getURI();
        }
        return uris;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeBookmarksLazy() {
        HashMap<String, Bookmark> hashMap = this.bookmarks;
        synchronized (hashMap) {
            if (this.isSavingBookmarksLazy) {
                return;
            }
            this.isSavingBookmarksLazy = true;
            this.node.node.ticker.queueTimedJob(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        BookmarkManager.this.storeBookmarks();
                    }
                    finally {
                        BookmarkManager.this.isSavingBookmarksLazy = false;
                    }
                }
            }, TimeUnit.MINUTES.toMillis(5L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeBookmarks() {
        FileOutputStream fos;
        block17: {
            Logger.normal(this, "Attempting to save bookmarks to " + this.bookmarksFile.toString());
            SimpleFieldSet sfs = null;
            HashMap<String, Bookmark> hashMap = this.bookmarks;
            synchronized (hashMap) {
                if (this.isSavingBookmarks) {
                    return;
                }
                this.isSavingBookmarks = true;
                sfs = this.toSimpleFieldSet();
            }
            fos = null;
            try {
                fos = new FileOutputStream(this.backupBookmarksFile);
                sfs.writeToBigBuffer(fos);
                fos.close();
                fos = null;
                if (FileUtil.renameTo(this.backupBookmarksFile, this.bookmarksFile)) break block17;
                Logger.error(this, "Unable to rename " + this.backupBookmarksFile.toString() + " to " + this.bookmarksFile.toString());
            }
            catch (IOException ioe) {
                try {
                    Logger.error(this, "An error has occured saving the bookmark file :" + ioe.getMessage(), (Throwable)ioe);
                }
                catch (Throwable throwable) {
                    Closer.close(fos);
                    HashMap<String, Bookmark> hashMap2 = this.bookmarks;
                    synchronized (hashMap2) {
                        this.isSavingBookmarks = false;
                    }
                    throw throwable;
                }
                Closer.close(fos);
                HashMap<String, Bookmark> hashMap3 = this.bookmarks;
                synchronized (hashMap3) {
                    this.isSavingBookmarks = false;
                }
            }
        }
        Closer.close(fos);
        HashMap<String, Bookmark> hashMap = this.bookmarks;
        synchronized (hashMap) {
            this.isSavingBookmarks = false;
        }
    }

    private void readBookmarks(BookmarkCategory category, SimpleFieldSet sfs) {
        this._innerReadBookmarks("", category, sfs);
    }

    private void subscribeToUSK(BookmarkItem item) {
        if ("USK".equals(item.getKeyType())) {
            try {
                USK u = item.getUSK();
                this.node.uskManager.subscribe(u, this.uskCB, true, this);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void _innerReadBookmarks(String prefix, BookmarkCategory category, SimpleFieldSet sfs) {
        boolean hasBeenParsedWithoutAnyProblem = true;
        boolean isRoot = "".equals(prefix) && MAIN_CATEGORY.equals(category);
        HashMap<String, Bookmark> hashMap = this.bookmarks;
        synchronized (hashMap) {
            if (!isRoot) {
                this.putPaths(prefix + category.name + '/', category);
            }
            try {
                String name;
                SimpleFieldSet subset;
                int i;
                int nbBookmarks = sfs.getInt("Bookmark");
                int nbCategories = sfs.getInt("BookmarkCategory");
                for (i = 0; i < nbBookmarks; ++i) {
                    subset = sfs.getSubset("Bookmark" + i);
                    try {
                        BookmarkItem item = new BookmarkItem(subset, this, this.node.alerts);
                        name = (isRoot ? "" : prefix + category.name) + '/' + item.name;
                        this.putPaths(name, item);
                        category.addBookmark(item);
                        item.registerUserAlert();
                        this.subscribeToUSK(item);
                        continue;
                    }
                    catch (MalformedURLException e) {
                        throw new FSParseException(e);
                    }
                }
                for (i = 0; i < nbCategories; ++i) {
                    subset = sfs.getSubset("BookmarkCategory" + i);
                    BookmarkCategory currentCategory = new BookmarkCategory(subset);
                    category.addBookmark(currentCategory);
                    name = isRoot ? "/" : prefix + category.name + '/';
                    this._innerReadBookmarks(name, currentCategory, subset.getSubset("Content"));
                }
            }
            catch (FSParseException e) {
                Logger.error(this, "Error parsing the bookmarks file!", (Throwable)e);
                hasBeenParsedWithoutAnyProblem = false;
            }
        }
        if (hasBeenParsedWithoutAnyProblem) {
            this.storeBookmarks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleFieldSet toSimpleFieldSet() {
        SimpleFieldSet sfs = new SimpleFieldSet(true);
        sfs.put("Version", 1);
        HashMap<String, Bookmark> hashMap = this.bookmarks;
        synchronized (hashMap) {
            sfs.putAllOverwrite(BookmarkManager.toSimpleFieldSet(MAIN_CATEGORY));
        }
        return sfs;
    }

    public static SimpleFieldSet toSimpleFieldSet(BookmarkCategory cat) {
        SimpleFieldSet sfs = new SimpleFieldSet(true);
        List<BookmarkCategory> bc = cat.getSubCategories();
        for (int i = 0; i < bc.size(); ++i) {
            BookmarkCategory currentCat = bc.get(i);
            sfs.put("BookmarkCategory" + i, currentCat.getSimpleFieldSet());
        }
        sfs.put("BookmarkCategory", bc.size());
        List<BookmarkItem> bi = cat.getItems();
        for (int i = 0; i < bi.size(); ++i) {
            sfs.put("Bookmark" + i, bi.get(i).getSimpleFieldSet());
        }
        sfs.put("Bookmark", bi.size());
        return sfs;
    }

    @Override
    public boolean persistent() {
        return false;
    }

    @Override
    public boolean realTimeFlag() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream in;
        SimpleFieldSet defaultBookmarks;
        block4: {
            MAIN_CATEGORY = new BookmarkCategory("/");
            DEFAULT_CATEGORY = new BookmarkCategory("\\");
            String name = "freenet/clients/http/staticfiles/defaultbookmarks.dat";
            defaultBookmarks = null;
            in = null;
            try {
                ClassLoader loader = BookmarkManager.class.getClassLoader();
                in = loader.getResourceAsStream(name);
                if (in == null) break block4;
                defaultBookmarks = SimpleFieldSet.readFrom(in, false, false);
            }
            catch (Exception e) {
                try {
                    Logger.error(BookmarkManager.class, "Error while loading the default bookmark file from " + name + " :" + e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    Closer.close(in);
                    DEFAULT_BOOKMARKS = defaultBookmarks;
                    throw throwable;
                }
                Closer.close(in);
                DEFAULT_BOOKMARKS = defaultBookmarks;
            }
        }
        Closer.close(in);
        DEFAULT_BOOKMARKS = defaultBookmarks;
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    private class USKUpdatedCallback
    implements USKCallback {
        private USKUpdatedCallback() {
        }

        @Override
        public void onFoundEdition(long edition, USK key, ClientContext context, boolean wasMetadata, short codec, byte[] data, boolean newKnownGood, boolean newSlotToo) {
            if (!newKnownGood) {
                FreenetURI uri = key.copy(edition).getURI();
                BookmarkManager.this.node.makeClient((short)3, false, false).prefetch(uri, TimeUnit.MINUTES.toMillis(60L), FProxyToadlet.MAX_LENGTH_WITH_PROGRESS, null, (short)3);
                return;
            }
            List<BookmarkItem> items = MAIN_CATEGORY.getAllItems();
            boolean matched = false;
            boolean updated = false;
            for (int i = 0; i < items.size(); ++i) {
                if (!"USK".equals(items.get(i).getKeyType())) continue;
                try {
                    FreenetURI furi = new FreenetURI(items.get(i).getKey());
                    USK usk = USK.create(furi);
                    if (!usk.equals(key, false)) continue;
                    if (logMINOR) {
                        Logger.minor(this, "Updating bookmark for " + furi + " to edition " + edition);
                    }
                    matched = true;
                    BookmarkItem item = items.get(i);
                    updated |= item.setEdition(edition, BookmarkManager.this.node);
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (updated) {
                BookmarkManager.this.storeBookmarksLazy();
            } else if (!matched) {
                Logger.error(this, "No match for bookmark " + key + " edition " + edition);
            }
        }

        @Override
        public short getPollingPriorityNormal() {
            return 4;
        }

        @Override
        public short getPollingPriorityProgress() {
            return 3;
        }
    }
}

