/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.RedirectException;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.config.InvalidConfigValueException;
import freenet.config.SubConfig;
import freenet.l10n.NodeL10n;
import freenet.node.Node;
import freenet.support.Logger;
import freenet.support.api.HTTPRequest;
import freenet.support.api.StringArrCallback;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

public class SymlinkerToadlet
extends Toadlet {
    private final HashMap<String, String> linkMap = new HashMap();
    private final Node node;
    SubConfig tslconfig;

    public SymlinkerToadlet(HighLevelSimpleClient client, Node node) {
        super(client);
        this.node = node;
        this.tslconfig = node.config.createSubConfig("toadletsymlinker");
        this.tslconfig.register("symlinks", null, 9, true, false, "SymlinkerToadlet.symlinks", "SymlinkerToadlet.symlinksLong", new StringArrCallback(){

            @Override
            public String[] get() {
                return SymlinkerToadlet.this.getConfigLoadString();
            }

            @Override
            public void set(String[] val) throws InvalidConfigValueException {
                throw new InvalidConfigValueException("Cannot set the plugins that's loaded.");
            }

            @Override
            public boolean isReadOnly() {
                return true;
            }
        });
        String[] fns = this.tslconfig.getStringArr("symlinks");
        if (fns != null) {
            for (String fn : fns) {
                String[] tuple = fn.split("#");
                if (tuple.length != 2) continue;
                this.addLink(tuple[0], tuple[1], false);
            }
        }
        this.tslconfig.finishedInitialization();
        this.addLink("/sl/search/", "/plugins/plugins.Librarian/", false);
        this.addLink("/sl/gallery/", "/plugins/plugins.TestGallery/", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addLink(String alias, String target, boolean store) {
        boolean ret;
        HashMap<String, String> hashMap = this.linkMap;
        synchronized (hashMap) {
            ret = alias.equals(this.linkMap.put(alias, target));
            Logger.normal(this, "Adding link: " + alias + " => " + target);
        }
        if (store) {
            this.node.clientCore.storeConfig();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLink(String alias, boolean store) {
        boolean ret;
        HashMap<String, String> hashMap = this.linkMap;
        synchronized (hashMap) {
            String o = this.linkMap.remove(alias);
            ret = o != null;
            Logger.normal(this, "Removing link: " + alias + " => " + o);
        }
        if (store) {
            this.node.clientCore.storeConfig();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getConfigLoadString() {
        String[] retarr = new String[this.linkMap.size()];
        HashMap<String, String> hashMap = this.linkMap;
        synchronized (hashMap) {
            int i = 0;
            for (Map.Entry<String, String> entry : this.linkMap.entrySet()) {
                retarr[i++] = entry.getKey() + '#' + entry.getValue();
            }
        }
        return retarr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMethodGET(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        String path = uri.getPath();
        String foundkey = null;
        String foundtarget = null;
        HashMap<String, String> hashMap = this.linkMap;
        synchronized (hashMap) {
            for (Map.Entry<String, String> entry : this.linkMap.entrySet()) {
                String key = entry.getKey();
                if (!path.startsWith(key)) continue;
                foundkey = key;
                foundtarget = entry.getValue();
            }
        }
        if (foundtarget == null || foundkey == null) {
            this.writeTextReply(ctx, 404, "Not found", NodeL10n.getBase().getString("StaticToadlet.pathNotFound"));
            return;
        }
        path = foundtarget + path.substring(foundkey.length());
        URI outuri = null;
        try {
            outuri = new URI(null, null, path, uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            this.writeHTMLReply(ctx, 200, "OK", e.getMessage());
            return;
        }
        uri.getRawQuery();
        throw new RedirectException(outuri);
    }

    @Override
    public String path() {
        return "/sl/";
    }
}

