/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.clients.http.updateableelements.BaseUpdateableElement;
import freenet.clients.http.updateableelements.PushDataManager;
import freenet.support.Ticker;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class IntervalPusherManager {
    private static final int REFRESH_PERIOD = 10000;
    private final PushDataManager pushDataManager;
    private final Ticker ticker;
    private Runnable refresherJob = new Runnable(){

        @Override
        public void run() {
            for (BaseUpdateableElement element : IntervalPusherManager.this.elements) {
                IntervalPusherManager.this.pushDataManager.updateElement(element.getUpdaterId(null));
            }
            if (IntervalPusherManager.this.elements.size() > 0) {
                IntervalPusherManager.this.ticker.queueTimedJob(this, "Stats refresher", 10000L, false, true);
            }
        }
    };
    private List<BaseUpdateableElement> elements = new CopyOnWriteArrayList<BaseUpdateableElement>();

    public IntervalPusherManager(Ticker ticker, PushDataManager pushDataManager) {
        this.ticker = ticker;
        this.pushDataManager = pushDataManager;
    }

    public void registerUpdateableElement(BaseUpdateableElement element) {
        boolean needsStart = false;
        if (this.elements.size() == 0) {
            needsStart = true;
        }
        this.elements.add(element);
        if (needsStart) {
            this.ticker.queueTimedJob(this.refresherJob, "Stats refresher", 10000L, false, true);
        }
    }

    public void deregisterUpdateableElement(BaseUpdateableElement element) {
        this.elements.remove(element);
    }
}

