/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.client.events.SplitfileProgressEvent;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.node.Node;
import freenet.support.SimpleFieldSet;
import java.util.Date;

public class SimpleProgressMessage
extends FCPMessage {
    private final String ident;
    private final boolean global;
    private final SplitfileProgressEvent event;

    public SimpleProgressMessage(String identifier, boolean global, SplitfileProgressEvent event) {
        this.ident = identifier;
        this.event = event;
        this.global = global;
    }

    protected SimpleProgressMessage() {
        this.ident = null;
        this.global = false;
        this.event = null;
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.put("Total", this.event.totalBlocks);
        fs.put("Required", this.event.minSuccessfulBlocks);
        fs.put("Failed", this.event.failedBlocks);
        fs.put("FatallyFailed", this.event.fatallyFailedBlocks);
        fs.put("Succeeded", this.event.succeedBlocks);
        fs.put("LastProgress", this.event.latestSuccess != null ? this.event.latestSuccess.getTime() : 0L);
        fs.put("FinalizedTotal", this.event.finalizedTotal);
        if (this.event.minSuccessFetchBlocks != 0) {
            fs.put("MinSuccessFetchBlocks", this.event.minSuccessFetchBlocks);
        }
        fs.putSingle("Identifier", this.ident);
        fs.put("Global", this.global);
        return fs;
    }

    @Override
    public String getName() {
        return "SimpleProgress";
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "SimpleProgress goes from server to client not the other way around", this.ident, this.global);
    }

    public double getFraction() {
        return (double)this.event.succeedBlocks / (double)this.event.totalBlocks;
    }

    public double getMinBlocks() {
        return this.event.minSuccessfulBlocks;
    }

    public double getTotalBlocks() {
        return this.event.totalBlocks;
    }

    public double getFetchedBlocks() {
        return this.event.succeedBlocks;
    }

    public Date getLatestSuccess() {
        return this.event.latestSuccess != null ? (Date)this.event.latestSuccess.clone() : null;
    }

    public double getFailedBlocks() {
        return this.event.failedBlocks;
    }

    public double getFatalyFailedBlocks() {
        return this.event.fatallyFailedBlocks;
    }

    public Date getLatestFailure() {
        return this.event.latestFailure != null ? (Date)this.event.latestFailure.clone() : null;
    }

    public boolean isTotalFinalized() {
        return this.event.finalizedTotal;
    }

    SplitfileProgressEvent getEvent() {
        return this.event;
    }
}

