/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.clients.fcp.PeerNote;
import freenet.clients.fcp.UnknownNodeIdentifierMessage;
import freenet.clients.fcp.UnknownPeerNoteTypeMessage;
import freenet.node.DarknetPeerNode;
import freenet.node.FSParseException;
import freenet.node.Node;
import freenet.node.PeerNode;
import freenet.support.Base64;
import freenet.support.IllegalBase64Exception;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;

public class ModifyPeerNote
extends FCPMessage {
    static final String NAME = "ModifyPeerNote";
    final SimpleFieldSet fs;
    final String identifier;

    public ModifyPeerNote(SimpleFieldSet fs) {
        this.fs = fs;
        this.identifier = fs.get("Identifier");
        fs.removeValue("Identifier");
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        return new SimpleFieldSet(true);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        String noteText;
        int peerNoteType;
        if (!handler.hasFullAccess()) {
            throw new MessageInvalidException(24, "ModifyPeerNote requires full access", this.identifier, false);
        }
        String nodeIdentifier = this.fs.get("NodeIdentifier");
        if (nodeIdentifier == null) {
            throw new MessageInvalidException(5, "Error: NodeIdentifier field missing", this.identifier, false);
        }
        PeerNode pn = node.getPeerNode(nodeIdentifier);
        if (pn == null) {
            UnknownNodeIdentifierMessage msg = new UnknownNodeIdentifierMessage(nodeIdentifier, this.identifier);
            handler.outputHandler.queue(msg);
            return;
        }
        if (!(pn instanceof DarknetPeerNode)) {
            throw new MessageInvalidException(31, "ModifyPeerNote only available for darknet peers", this.identifier, false);
        }
        DarknetPeerNode dpn = (DarknetPeerNode)pn;
        try {
            peerNoteType = this.fs.getInt("PeerNoteType");
        }
        catch (FSParseException e) {
            throw new MessageInvalidException(8, "Error parsing PeerNoteType field: " + e.getMessage(), this.identifier, false);
        }
        String encodedNoteText = this.fs.get("NoteText");
        if (encodedNoteText == null) {
            throw new MessageInvalidException(5, "Error: NoteText field missing", this.identifier, false);
        }
        try {
            noteText = Base64.decodeUTF8(encodedNoteText);
        }
        catch (IllegalBase64Exception e) {
            Logger.error(this, "Bad Base64 encoding when decoding a FCP-received private darknet comment SimpleFieldSet", (Throwable)e);
            return;
        }
        if (peerNoteType != 1) {
            UnknownPeerNoteTypeMessage msg = new UnknownPeerNoteTypeMessage(peerNoteType, this.identifier);
            handler.outputHandler.queue(msg);
            return;
        }
        dpn.setPrivateDarknetCommentNote(noteText);
        handler.outputHandler.queue(new PeerNote(nodeIdentifier, noteText, peerNoteType, this.identifier));
    }
}

