/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.FCPPluginConnectionImpl;
import freenet.support.Logger;
import freenet.support.io.NativeThread;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

final class FCPPluginConnectionTracker
extends NativeThread {
    private final TreeMap<UUID, ConnectionWeakReference> connectionsByID = new TreeMap();
    private final ReadWriteLock connectionsByIDLock = new ReentrantReadWriteLock();
    private final ReferenceQueue<FCPPluginConnectionImpl> closedConnectionsQueue = new ReferenceQueue();
    private static volatile transient boolean logMINOR = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerConnection(FCPPluginConnectionImpl connection) {
        this.connectionsByIDLock.writeLock().lock();
        try {
            this.connectionsByID.put(connection.getID(), new ConnectionWeakReference(connection, this.closedConnectionsQueue));
        }
        finally {
            this.connectionsByIDLock.writeLock().unlock();
        }
    }

    public FCPPluginConnectionImpl getConnection(UUID connectionID) throws IOException {
        ConnectionWeakReference ref = this.getConnectionWeakReference(connectionID);
        FCPPluginConnectionImpl connection = (FCPPluginConnectionImpl)ref.get();
        if (connection == null) {
            throw new IOException("Client has closed the connection. Connection ID = " + connectionID);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionWeakReference getConnectionWeakReference(UUID connectionID) throws IOException {
        this.connectionsByIDLock.readLock().lock();
        try {
            ConnectionWeakReference ref = this.connectionsByID.get(connectionID);
            if (ref != null) {
                ConnectionWeakReference connectionWeakReference = ref;
                return connectionWeakReference;
            }
        }
        finally {
            this.connectionsByIDLock.readLock().unlock();
        }
        throw new IOException("FCPPluginConnection not found, maybe client has disconnected. Connection ID: " + connectionID);
    }

    public FCPPluginConnectionTracker() {
        super("FCPPluginConnectionTracker Garbage-collector", NativeThread.PriorityLevel.MIN_PRIORITY.value, true);
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void realRun() {
        while (true) {
            try {
                while (true) lbl-1000:
                // 4 sources

                {
                    closedConnection = (ConnectionWeakReference)this.closedConnectionsQueue.remove();
                    this.connectionsByIDLock.writeLock().lock();
                    try {
                        removedFromTree = this.connectionsByID.remove(closedConnection.connectionID);
                        if (!FCPPluginConnectionTracker.$assertionsDisabled && closedConnection != removedFromTree) {
                            throw new AssertionError();
                        }
                        if (!FCPPluginConnectionTracker.logMINOR) ** GOTO lbl-1000
                        Logger.minor(this, "Garbage-collecting closed connection: remaining connections = " + this.connectionsByID.size() + "; connection ID = " + closedConnection.connectionID);
                    }
                    finally {
                        this.connectionsByIDLock.writeLock().unlock();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                Logger.error(this, "Thread interruption requested even though this is a daemon thread!", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (Throwable t) {
                Logger.error(this, "Error in thread " + this.getName(), t);
                continue;
            }
            ** GOTO lbl-1000
            break;
        }
    }

    static {
        Logger.registerClass(FCPPluginConnectionTracker.class);
    }

    static final class ConnectionWeakReference
    extends WeakReference<FCPPluginConnectionImpl> {
        public final UUID connectionID;

        public ConnectionWeakReference(FCPPluginConnectionImpl referent, ReferenceQueue<FCPPluginConnectionImpl> referenceQueue) {
            super(referent, referenceQueue);
            this.connectionID = referent.getID();
        }
    }
}

