/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.client.async.PersistenceDisabledException;
import freenet.clients.fcp.BaseDataCarryingMessage;
import freenet.clients.fcp.FCPServer;
import freenet.clients.fcp.MessageInvalidException;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.BucketTools;
import freenet.support.io.FileUtil;
import freenet.support.io.NullBucket;
import freenet.support.io.NullOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class DataCarryingMessage
extends BaseDataCarryingMessage {
    protected Bucket bucket;
    protected boolean freeOnSent;

    RandomAccessBucket createBucket(BucketFactory bf, long length, FCPServer server) throws IOException, PersistenceDisabledException {
        return bf.makeBucket(length);
    }

    abstract String getIdentifier();

    abstract boolean isGlobal();

    void setFreeOnSent() {
        this.freeOnSent = true;
    }

    @Override
    public void readFrom(InputStream is, BucketFactory bf, FCPServer server) throws IOException, MessageInvalidException {
        RandomAccessBucket tempBucket;
        long len = this.dataLength();
        if (len < 0L) {
            return;
        }
        if (len == 0L) {
            this.bucket = new NullBucket();
            return;
        }
        try {
            tempBucket = this.createBucket(bf, len, server);
        }
        catch (IOException e) {
            Logger.error(this, "Bucket error: " + e, (Throwable)e);
            FileUtil.copy(is, new NullOutputStream(), len);
            throw new MessageInvalidException(17, e.toString(), this.getIdentifier(), this.isGlobal());
        }
        catch (PersistenceDisabledException e) {
            Logger.error(this, "Bucket error: " + e, (Throwable)e);
            FileUtil.copy(is, new NullOutputStream(), len);
            throw new MessageInvalidException(33, null, this.getIdentifier(), this.isGlobal());
        }
        BucketTools.copyFrom(tempBucket, is, len);
        this.bucket = tempBucket;
    }

    @Override
    protected void writeData(OutputStream os) throws IOException {
        long len = this.dataLength();
        if (len > 0L) {
            BucketTools.copyTo(this.bucket, os, len);
        }
        if (this.freeOnSent) {
            this.bucket.free();
        }
    }

    @Override
    String getEndString() {
        return "Data";
    }

    public RandomAccessBucket getRandomAccessBucket() {
        return (RandomAccessBucket)this.bucket;
    }
}

