/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.async.ClientContext;
import freenet.keys.ClientKey;
import freenet.keys.Key;
import freenet.node.LowLevelGetException;
import freenet.node.LowLevelPutException;
import freenet.node.NodeClientCore;
import freenet.node.RequestScheduler;
import freenet.node.SendableRequestItem;
import freenet.node.SendableRequestSender;

public abstract class ChosenBlock {
    public final transient SendableRequestItem token;
    public final transient Key key;
    public final transient ClientKey ckey;
    public final transient boolean localRequestOnly;
    public final transient boolean ignoreStore;
    public final transient boolean canWriteClientCache;
    public final transient boolean forkOnCacheable;
    public final transient boolean realTimeFlag;
    private boolean sendIsBlocking;

    public ChosenBlock(SendableRequestItem token, Key key, ClientKey ckey, boolean localRequestOnly, boolean ignoreStore, boolean canWriteClientCache, boolean forkOnCacheable, boolean realTimeFlag, RequestScheduler sched) {
        this.token = token;
        if (token == null) {
            throw new NullPointerException();
        }
        this.key = key;
        this.ckey = ckey;
        this.localRequestOnly = localRequestOnly;
        this.ignoreStore = ignoreStore;
        this.canWriteClientCache = canWriteClientCache;
        this.forkOnCacheable = forkOnCacheable;
        this.realTimeFlag = realTimeFlag;
    }

    public abstract boolean isPersistent();

    public abstract boolean isCancelled();

    public abstract void onFailure(LowLevelPutException var1, ClientContext var2);

    public abstract void onInsertSuccess(ClientKey var1, ClientContext var2);

    public abstract void onFailure(LowLevelGetException var1, ClientContext var2);

    public abstract void onFetchSuccess(ClientContext var1);

    public abstract short getPriority();

    public boolean send(NodeClientCore core, RequestScheduler sched) {
        ClientContext context = sched.getContext();
        SendableRequestSender sender = this.getSender(context);
        this.sendIsBlocking = sender.sendIsBlocking();
        return sender.send(core, sched, context, this);
    }

    public abstract SendableRequestSender getSender(ClientContext var1);

    public void onDumped() {
        this.token.dump();
    }

    public boolean sendIsBlocking() {
        return this.sendIsBlocking;
    }
}

