/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.pfb;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class PfbParser {
    private static final int PFB_HEADER_LENGTH = 18;
    private static final int START_MARKER = 128;
    private static final int ASCII_MARKER = 1;
    private static final int BINARY_MARKER = 2;
    private static final int[] PFB_RECORDS = new int[]{1, 2, 1};
    private static final int BUFFER_SIZE = 65535;
    private byte[] pfbdata;
    private int[] lengths;

    public PfbParser(String string) throws IOException {
        this(new BufferedInputStream(new FileInputStream(string), 65535));
    }

    public PfbParser(InputStream inputStream) throws IOException {
        byte[] byArray = this.readPfbInput(inputStream);
        this.parsePfb(byArray);
    }

    public PfbParser(byte[] byArray) throws IOException {
        this.parsePfb(byArray);
    }

    private void parsePfb(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.pfbdata = new byte[byArray.length - 18];
        this.lengths = new int[PFB_RECORDS.length];
        int n = 0;
        for (int i = 0; i < PFB_RECORDS.length; ++i) {
            if (byteArrayInputStream.read() != 128) {
                throw new IOException("Start marker missing");
            }
            if (byteArrayInputStream.read() != PFB_RECORDS[i]) {
                throw new IOException("Incorrect record type");
            }
            int n2 = byteArrayInputStream.read();
            n2 += byteArrayInputStream.read() << 8;
            n2 += byteArrayInputStream.read() << 16;
            this.lengths[i] = n2 += byteArrayInputStream.read() << 24;
            if (n >= this.pfbdata.length) {
                throw new EOFException("attempted to read past EOF");
            }
            int n3 = byteArrayInputStream.read(this.pfbdata, n, n2);
            if (n3 < 0) {
                throw new EOFException();
            }
            n += n3;
        }
    }

    private byte[] readPfbInput(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[65535];
        int n = -1;
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public int[] getLengths() {
        return this.lengths;
    }

    public byte[] getPfbdata() {
        return this.pfbdata;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.pfbdata);
    }

    public int size() {
        return this.pfbdata.length;
    }

    public byte[] getSegment1() {
        return Arrays.copyOfRange(this.pfbdata, 0, this.lengths[0]);
    }

    public byte[] getSegment2() {
        return Arrays.copyOfRange(this.pfbdata, this.lengths[0], this.lengths[0] + this.lengths[1]);
    }
}

