/*
 * Decompiled with CFR 0.152.
 */
package blue.csnd6.render;

import blue.BlueData;
import blue.BlueSystem;
import blue.automation.Parameter;
import blue.csnd6.render.BlueCallbackWrapper;
import blue.event.PlayModeListener;
import blue.noteProcessor.TempoMapper;
import blue.score.ScoreGenerationException;
import blue.services.render.CSDRenderService;
import blue.services.render.CsdRenderResult;
import blue.services.render.DiskRenderJob;
import blue.services.render.DiskRenderService;
import blue.services.render.RenderTimeManager;
import blue.settings.PlaybackSettings;
import blue.utility.FileUtilities;
import csnd6.Csound;
import csnd6.CsoundArgVList;
import csnd6.csnd6;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.commons.lang3.text.StrBuilder;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.windows.IOColors;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class CS6DiskRendererService
implements DiskRenderService {
    Vector listeners = new Vector();
    RenderTimeManager renderTimeManager = null;
    private volatile boolean keepRunning = false;
    BlueCallbackWrapper blueCallbackWrapper;

    public CS6DiskRendererService() {
        csnd6.csoundInitialize(csnd6.CSOUNDINIT_NO_ATEXIT | csnd6.CSOUNDINIT_NO_SIGNAL_HANDLER);
    }

    public String toString() {
        return "Csound 6 API";
    }

    public boolean isRunning() {
        return this.keepRunning;
    }

    public void setRenderTimeManager(RenderTimeManager renderTimeManager) {
        this.renderTimeManager = renderTimeManager;
    }

    private void initialize() {
        this.keepRunning = true;
    }

    private void exec(String[] args, File currentWorkingDirectory, double startTime, TempoMapper mapper, ArrayList<Parameter> parameters) {
        Csound csound = new Csound();
        this.blueCallbackWrapper = new BlueCallbackWrapper(csound);
        this.blueCallbackWrapper.SetMessageCallback();
        InputOutput ioProvider = IOProvider.getDefault().getIO("Csound", false);
        try {
            ioProvider.getOut().reset();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        IOColors.setColor((InputOutput)ioProvider, (IOColors.OutputType)IOColors.OutputType.OUTPUT, (Color)Color.WHITE);
        this.blueCallbackWrapper.setInputOutput(ioProvider);
        this.notifyPlayModeListeners(1);
        CsoundArgVList argsList = new CsoundArgVList();
        ioProvider.getOut().append((CharSequence)"Render Command (");
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("\"") && args[i].endsWith("\"")) {
                args[i] = args[i].substring(1, args[i].length() - 1);
            }
            argsList.Append(args[i]);
            ioProvider.getOut().append((CharSequence)" ").append(args[i]);
        }
        if (currentWorkingDirectory != null) {
            String sfdir = "--env:SFDIR=" + currentWorkingDirectory.getAbsolutePath();
            argsList.Append(sfdir);
            ioProvider.getOut().append((CharSequence)" ").append(sfdir);
        }
        ioProvider.getOut().append((CharSequence)" )\n");
        int retVal = csound.Compile(argsList.argc(), argsList.argv());
        if (retVal != 0) {
            this.notifyPlayModeListeners(0);
            csound.Stop();
            csound.Cleanup();
            csound.SetMessageCallback(null);
            csound.Reset();
            return;
        }
        int updateRate = (int)(csound.GetKr() / (double)PlaybackSettings.getInstance().getPlaybackFPS());
        int counter = 0;
        RenderTimeManager manager = (RenderTimeManager)Lookup.getDefault().lookup(RenderTimeManager.class);
        manager.initiateRender(startTime);
        do {
            double scoreTime = csound.GetScoreTime();
            if (++counter > updateRate) {
                manager.updateTimePointer(scoreTime);
                counter = 0;
            }
            double currentTime = 0.0;
            if (startTime >= 0.0) {
                if (mapper != null) {
                    double renderStartSeconds = mapper.beatsToSeconds(startTime);
                    currentTime = mapper.secondsToBeats(scoreTime + renderStartSeconds);
                    currentTime -= startTime;
                } else {
                    currentTime = startTime + scoreTime;
                }
            }
            if (parameters == null) continue;
            for (int i = 0; i < parameters.size(); ++i) {
                Parameter param = parameters.get(i);
                String varName = param.getCompilationVarName();
                double value = param.getValue(currentTime);
                csound.SetChannel(varName, value);
            }
        } while (csound.PerformKsmps() == 0 && this.keepRunning);
        csound.Stop();
        csound.Cleanup();
        csound.SetMessageCallback(null);
        csound.Reset();
        manager.endRender();
        this.keepRunning = false;
        this.notifyPlayModeListeners(0);
    }

    public void execWait(String[] args, File currentWorkingDirectory, double startTime, TempoMapper mapper, ArrayList<Parameter> parameters) {
        this.initialize();
        this.exec(args, currentWorkingDirectory, startTime, mapper, parameters);
    }

    public String execWaitAndCollect(String[] args, File currentWorkingDirectory) {
        int retVal;
        this.initialize();
        Csound csound = new Csound();
        this.blueCallbackWrapper = new BlueCallbackWrapper(csound);
        this.blueCallbackWrapper.SetMessageCallback();
        StrBuilder buffer = new StrBuilder();
        this.blueCallbackWrapper.setStringBuffer(buffer);
        CsoundArgVList argsList = new CsoundArgVList();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("\"") && args[i].endsWith("\"")) {
                args[i] = args[i].substring(1, args[i].length() - 1);
            }
            argsList.Append(args[i]);
        }
        if (currentWorkingDirectory != null) {
            String sfdir = "--env:SFDIR=" + currentWorkingDirectory.getAbsolutePath();
            argsList.Append(sfdir);
        }
        if ((retVal = csound.Compile(argsList.argc(), argsList.argv())) != 0) {
            this.blueCallbackWrapper.setStringBuffer(null);
            csound.Stop();
            csound.Cleanup();
            csound.SetMessageCallback(null);
            csound.Reset();
            return buffer.toString();
        }
        while (csound.PerformKsmps() == 0 && this.keepRunning) {
        }
        csound.Stop();
        csound.Cleanup();
        csound.SetMessageCallback(null);
        csound.Reset();
        this.keepRunning = false;
        this.blueCallbackWrapper.setStringBuffer(null);
        return buffer.toString();
    }

    public void stop() {
        this.keepRunning = false;
    }

    public void addPlayModeListener(PlayModeListener listener) {
        this.listeners.add(listener);
    }

    public void removePlayModeListener(PlayModeListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyPlayModeListeners(int playMode) {
        for (PlayModeListener listener : this.listeners) {
            listener.playModeChanged(playMode);
        }
    }

    protected String generateCsd(BlueData data) {
        CsdRenderResult result;
        double startTime = data.getRenderStartTime();
        double endTime = data.getRenderEndTime();
        if (data.getProjectProperties().diskAlwaysRenderEntireProject) {
            startTime = 0.0;
            endTime = -1.0;
        }
        try {
            result = CSDRenderService.getDefault().generateCSD(data, startTime, endTime, false, true);
        }
        catch (ScoreGenerationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        String csd = result.getCsdText();
        File temp = FileUtilities.createTempTextFile((String)"tempCsd", (String)".csd", (File)BlueSystem.getCurrentProjectDirectory(), (String)csd);
        return temp.getAbsolutePath();
    }

    public void renderToDisk(DiskRenderJob job) {
        String csdPath = this.generateCsd(job.getData());
        if (csdPath == null) {
            return;
        }
        this.initialize();
        Csound csound = new Csound();
        this.blueCallbackWrapper = new BlueCallbackWrapper(csound);
        this.blueCallbackWrapper.SetMessageCallback();
        InputOutput ioProvider = IOProvider.getDefault().getIO("Csound (Disk)", false);
        try {
            ioProvider.getOut().reset();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        IOColors.setColor((InputOutput)ioProvider, (IOColors.OutputType)IOColors.OutputType.OUTPUT, (Color)Color.WHITE);
        this.blueCallbackWrapper.setInputOutput(ioProvider);
        this.notifyPlayModeListeners(1);
        CsoundArgVList argsList = new CsoundArgVList();
        ioProvider.getOut().append((CharSequence)"Render Command (");
        String[] args = job.getArgs();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("\"") && args[i].endsWith("\"")) {
                args[i] = args[i].substring(1, args[i].length() - 1);
            }
            argsList.Append(args[i]);
            ioProvider.getOut().append((CharSequence)" ").append(args[i]);
        }
        if (job.getCurrentWorkingDirectory() != null) {
            String sfdir = "--env:SFDIR=" + job.getCurrentWorkingDirectory().getAbsolutePath();
            argsList.Append(sfdir);
            ioProvider.getOut().append((CharSequence)" ").append(sfdir);
        }
        argsList.Append(csdPath);
        ioProvider.getOut().append((CharSequence)(" " + csdPath + " )\n"));
        int retVal = csound.Compile(argsList.argc(), argsList.argv());
        if (retVal != 0) {
            this.notifyPlayModeListeners(0);
            csound.Stop();
            csound.Cleanup();
            csound.SetMessageCallback(null);
            csound.Reset();
            return;
        }
        while (csound.PerformKsmps() == 0 && this.keepRunning) {
        }
        csound.Stop();
        csound.Cleanup();
        csound.SetMessageCallback(null);
        csound.Reset();
        this.keepRunning = false;
        this.notifyPlayModeListeners(0);
    }

    public int getCsoundVersion(String csoundCommand) {
        return 6;
    }
}

