/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.soundObject.renderer;

import blue.soundObject.SoundObject;
import blue.ui.core.score.layers.soundObject.SoundObjectView;
import blue.ui.core.soundObject.renderer.GenericRenderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;

public abstract class LetterRenderer
extends GenericRenderer {
    private static Font miniFont = new Font("Dialog", 1, 10);
    String letter;

    public LetterRenderer(String letter) {
        this.letter = letter;
        this.labelOffset = 13;
    }

    @Override
    public void render(Graphics graphics, SoundObjectView sObjView, int pixelSeconds) {
        Color fontColor;
        Color boxColor;
        super.render(graphics, sObjView, pixelSeconds);
        Graphics2D g = (Graphics2D)graphics;
        SoundObject sObj = sObjView.getSoundObject();
        if (sObjView.isSelected()) {
            boxColor = selectedBorder2;
            fontColor = selectedFontColor;
        } else {
            Color bgColor = sObj.getBackgroundColor();
            boxColor = bgColor.brighter().brighter();
            int total = bgColor.getRed() + bgColor.getGreen() + bgColor.getBlue();
            fontColor = total > 384 ? Color.black : Color.white;
        }
        g.setColor(boxColor);
        g.fillRect(2, 4, 9, 9);
        g.setColor(fontColor);
        g.setFont(miniFont);
        g.drawString(this.letter, 3, 12);
    }
}

