/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.object.actions;

import blue.BlueData;
import blue.SoundLayer;
import blue.SoundObjectLibrary;
import blue.projects.BlueProjectManager;
import blue.score.ScoreObject;
import blue.score.layers.Layer;
import blue.score.layers.ScoreObjectLayer;
import blue.soundObject.Instance;
import blue.soundObject.PolyObject;
import blue.soundObject.SoundObject;
import blue.ui.core.score.ScoreController;
import blue.ui.core.score.ScorePath;
import blue.ui.core.score.undo.ReplaceScoreObjectEdit;
import blue.undo.BlueUndoManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class ReplaceWithBufferSoundObjectAction
extends AbstractAction
implements ContextAwareAction {
    private Collection<? extends ScoreObject> scoreObjects;
    private Collection<? extends SoundObject> soundObjects;
    private Point p;
    private final ScorePath scorePath;

    public ReplaceWithBufferSoundObjectAction() {
        this(Utilities.actionsGlobalContext());
    }

    public ReplaceWithBufferSoundObjectAction(Lookup lookup) {
        super(NbBundle.getMessage(ReplaceWithBufferSoundObjectAction.class, (String)"CTL_ReplaceWithBufferSoundObjectAction"));
        this.scoreObjects = lookup.lookupAll(ScoreObject.class);
        this.soundObjects = lookup.lookupAll(SoundObject.class);
        this.p = (Point)lookup.lookup(Point.class);
        this.scorePath = (ScorePath)lookup.lookup(ScorePath.class);
    }

    @Override
    public boolean isEnabled() {
        return this.soundObjects.size() > 0 && this.scoreObjects.size() == this.soundObjects.size();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ScoreController.ScoreObjectBuffer buffer = ScoreController.getInstance().getScoreObjectBuffer();
        List<Layer> layers = this.scorePath.getAllLayers();
        BlueData data = BlueProjectManager.getInstance().getCurrentBlueData();
        SoundObjectLibrary sObjLib = data.getSoundObjectLibrary();
        ArrayList<Instance> instances = new ArrayList<Instance>();
        ReplaceScoreObjectEdit top = null;
        for (SoundObject soundObject : this.soundObjects) {
            SoundObject replacement = this.getReplacementObject(buffer, instances);
            replacement.setStartTime(soundObject.getStartTime());
            replacement.setSubjectiveDuration(soundObject.getSubjectiveDuration());
            ScoreObjectLayer layer = (ScoreObjectLayer)this.findLayerForSoundObject(layers, soundObject);
            layer.remove((ScoreObject)soundObject);
            layer.add((Object)replacement);
            ReplaceScoreObjectEdit edit = new ReplaceScoreObjectEdit(layer, (ScoreObject)soundObject, (ScoreObject)replacement);
            if (top == null) {
                top = edit;
                continue;
            }
            top.addEdit(edit);
        }
        sObjLib.checkAndAddInstanceSoundObjects(instances);
        BlueUndoManager.setUndoManager((String)"score");
        BlueUndoManager.addEdit(top);
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ReplaceWithBufferSoundObjectAction(actionContext);
    }

    protected SoundObject getReplacementObject(ScoreController.ScoreObjectBuffer buffer, List<Instance> instances) {
        int i;
        if (buffer.scoreObjects.size() == 1) {
            SoundObject sObj = (SoundObject)buffer.scoreObjects.get(0).deepCopy();
            if (sObj instanceof Instance) {
                instances.add((Instance)sObj);
            }
            return sObj;
        }
        PolyObject pObj = new PolyObject();
        int minLayer = Integer.MAX_VALUE;
        int maxLayer = Integer.MIN_VALUE;
        for (Integer layerIndex : buffer.layerIndexes) {
            if (layerIndex < minLayer) {
                minLayer = layerIndex;
            }
            if (layerIndex <= maxLayer) continue;
            maxLayer = layerIndex;
        }
        int numLayers = maxLayer - minLayer + 1;
        for (i = 0; i < numLayers; ++i) {
            pObj.newLayerAt(-1);
        }
        for (i = 0; i < buffer.scoreObjects.size(); ++i) {
            ScoreObject scoreObj = buffer.scoreObjects.get(i);
            int layerIndex = buffer.layerIndexes.get(i);
            SoundLayer layer = (SoundLayer)pObj.get(layerIndex - minLayer);
            SoundObject clone = (SoundObject)scoreObj.deepCopy();
            layer.add(clone);
            if (!(clone instanceof Instance)) continue;
            instances.add((Instance)clone);
        }
        return pObj;
    }

    private Layer findLayerForSoundObject(List<Layer> layers, SoundObject sObj) {
        for (Layer layer : layers) {
            if (!layer.contains((ScoreObject)sObj)) continue;
            return layer;
        }
        return null;
    }
}

