/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.project;

import blue.projects.BlueProject;
import blue.projects.BlueProjectManager;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.openide.awt.DynamicMenuContent;

public class CurrentProjectsAction
extends JMenuItem
implements DynamicMenuContent {
    private static ActionListener al = e -> {
        JMenuItem item = (JMenuItem)e.getSource();
        Object obj = item.getClientProperty("project");
        if (obj != null) {
            BlueProjectManager.getInstance().setCurrentProject((BlueProject)obj);
        }
    };

    public JComponent[] getMenuPresenters() {
        BlueProjectManager manager = BlueProjectManager.getInstance();
        if (manager.getNumProjects() == 0) {
            return new JComponent[0];
        }
        JComponent[] items = new JComponent[manager.getNumProjects()];
        for (int i = 0; i < manager.getNumProjects(); ++i) {
            BlueProject proj = manager.getProject(i);
            File f = proj.getDataFile();
            String name = f == null ? "[new blue project]" : f.getName();
            JMenuItem menuItem = new JMenuItem(i + " " + name);
            menuItem.putClientProperty("project", proj);
            menuItem.setMnemonic(Integer.toString(i).charAt(0));
            menuItem.setEnabled(proj != manager.getCurrentProject());
            menuItem.addActionListener(al);
            items[i] = menuItem;
        }
        return items;
    }

    public JComponent[] synchMenuPresenters(JComponent[] items) {
        return this.getMenuPresenters();
    }
}

