/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.orchestra.editor.blueX7;

import blue.orchestra.blueX7.Operator;
import blue.ui.core.orchestra.editor.blueX7.EnvelopeGeneratorPanel;
import blue.ui.core.orchestra.editor.blueX7.KeyboardLevelScalingPanel;
import blue.ui.core.orchestra.editor.blueX7.ModulationSensitivityPanel;
import blue.ui.core.orchestra.editor.blueX7.OperatorEditPanel;
import blue.ui.core.orchestra.editor.blueX7.OscilatorPanel;
import blue.utility.GUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class OperatorPanel
extends JComponent {
    public OscilatorPanel oscilator = new OscilatorPanel();
    KeyboardLevelScalingPanel keyboardLevel = new KeyboardLevelScalingPanel();
    OperatorEditPanel opEdit = new OperatorEditPanel();
    public ModulationSensitivityPanel modulation = new ModulationSensitivityPanel();
    EnvelopeGeneratorPanel eg = new EnvelopeGeneratorPanel("Envelope Generator", "R", "L");

    public OperatorPanel() {
        JPanel top = new JPanel(new GridLayout(1, 2));
        top.add(this.oscilator);
        JPanel right = new JPanel(new GridLayout(2, 1));
        right.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        right.add(this.opEdit);
        right.add(this.modulation);
        top.add(right);
        JPanel bottom = new JPanel(new GridLayout(1, 2));
        bottom.add(this.keyboardLevel);
        bottom.add(this.eg);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)top, "North");
        this.add((Component)bottom, "Center");
    }

    public void editOperator(Operator op) {
        this.oscilator.editOperator(op);
        this.keyboardLevel.editOperator(op);
        this.opEdit.editOperator(op);
        this.modulation.editOperator(op);
        this.eg.setPoints(op.envelopePoints);
    }

    public static void main(String[] args) {
        OperatorPanel operatorPanel1 = new OperatorPanel();
        GUI.showComponentAsStandalone((Component)operatorPanel1, (String)"OperatorPanel Test", (boolean)true);
    }
}

