/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.mixer;

import blue.mixer.Send;
import blue.ui.core.mixer.SendEditPanel;
import java.awt.Frame;
import java.util.HashMap;
import javax.swing.ComboBoxModel;
import javax.swing.JDialog;

public class SendEditorManager {
    private static SendEditorManager manager = null;
    private HashMap map = new HashMap();

    private SendEditorManager() {
    }

    public void clear() {
        for (JDialog dialog : this.map.values()) {
            dialog.setVisible(false);
            dialog.dispose();
        }
        this.map.clear();
    }

    public void removeSend(Send send) {
        if (this.map.containsKey(send)) {
            Object val = this.map.get(send);
            if (val != null) {
                ((JDialog)val).setVisible(false);
                ((JDialog)val).dispose();
            }
            this.map.remove(send);
        }
    }

    public void openSendEditor(Frame root, Send send, ComboBoxModel comboBoxModel) {
        Object val = this.map.get(send);
        if (val == null) {
            JDialog dialog = new JDialog(root);
            SendEditPanel panel = new SendEditPanel();
            panel.setComboBoxModel(comboBoxModel);
            panel.setSend(send);
            dialog.getContentPane().add(panel);
            dialog.setTitle("Send");
            dialog.pack();
            dialog.getRootPane().putClientProperty("SeparateWindow", Boolean.TRUE);
            dialog.setSize(dialog.getWidth() + 5, dialog.getHeight() + 5);
            dialog.setVisible(true);
            this.map.put(send, dialog);
        } else {
            ((JDialog)val).setVisible(true);
        }
    }

    public static SendEditorManager getInstance() {
        if (manager == null) {
            manager = new SendEditorManager();
        }
        return manager;
    }
}

