/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.mixer;

import blue.gui.DragManager;
import blue.mixer.Effect;
import blue.ui.core.mixer.EffectCategory;
import blue.ui.core.mixer.EffectsLibrary;
import blue.ui.core.mixer.TransferableEffect;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class EffectTreeDragSource
implements DragSourceListener,
DragGestureListener {
    DragSource source;
    DragGestureRecognizer recognizer;
    JTree sourceTree;
    TransferableEffect transferable;
    Object oldNode;

    public EffectTreeDragSource(JTree tree, int actions) {
        this.sourceTree = tree;
        this.source = new DragSource();
        this.recognizer = this.source.createDefaultDragGestureRecognizer(this.sourceTree, actions, this);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        TreePath path = this.sourceTree.getSelectionPath();
        if (path == null || path.getPathCount() <= 1) {
            return;
        }
        if (path.getLastPathComponent() instanceof Effect || path.getLastPathComponent() instanceof EffectCategory) {
            this.oldNode = path.getLastPathComponent();
            Object cloneNode = null;
            if (this.oldNode instanceof Effect) {
                cloneNode = new Effect((Effect)this.oldNode);
            } else if (this.oldNode instanceof EffectCategory) {
                cloneNode = new EffectCategory((EffectCategory)this.oldNode);
            }
            this.transferable = new TransferableEffect(cloneNode);
            this.source.startDrag(dge, null, this.transferable, this);
            DragManager.setDragSource(this.sourceTree);
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        if (dsde.getDropSuccess() && dsde.getDropAction() == 2) {
            if (this.oldNode instanceof Effect) {
                EffectsLibrary.getInstance().removeEffect((Effect)this.oldNode);
            } else if (this.oldNode instanceof EffectCategory) {
                EffectsLibrary.getInstance().removeEffectCategory((EffectCategory)this.oldNode);
            }
        }
        this.oldNode = null;
        DragManager.setDragSource(null);
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }
}

