/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.globals;

import blue.GlobalOrcSco;
import blue.projects.BlueProject;
import blue.projects.BlueProjectManager;
import blue.ui.nbutilities.MimeTypeEditorComponent;
import blue.ui.utilities.SimpleDocumentListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Properties;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.undo.UndoManager;
import org.openide.awt.UndoRedo;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="GlobalScoreTopComponent", persistenceType=0)
public final class GlobalScoreTopComponent
extends TopComponent {
    private static GlobalScoreTopComponent instance;
    private GlobalOrcSco globalOrcSco = null;
    MimeTypeEditorComponent scoreText = new MimeTypeEditorComponent("text/x-csound-sco");
    UndoManager undo = new UndoRedo.Manager();

    private GlobalScoreTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(GlobalScoreTopComponent.class, (String)"CTL_GlobalScoreTopComponent"));
        this.setToolTipText(NbBundle.getMessage(GlobalScoreTopComponent.class, (String)"HINT_GlobalScoreTopComponent"));
        BlueProjectManager.getInstance().addPropertyChangeListener(evt -> {
            if ("currentProject".equals(evt.getPropertyName())) {
                this.globalOrcSco = null;
                this.reinitialize();
            }
        });
        this.reinitialize();
        this.scoreText.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (GlobalScoreTopComponent.this.globalOrcSco != null) {
                    GlobalScoreTopComponent.this.globalOrcSco.setGlobalSco(GlobalScoreTopComponent.this.scoreText.getText());
                }
            }
        });
        this.scoreText.setUndoManager(this.undo);
        this.scoreText.getDocument().addUndoableEditListener(this.undo);
        this.add((Component)this.scoreText, "Center");
    }

    private void reinitialize() {
        BlueProject project = BlueProjectManager.getInstance().getCurrentProject();
        if (project == null) {
            this.scoreText.setText("");
            this.scoreText.getJEditorPane().setEditable(false);
        } else {
            GlobalOrcSco localGlobals = project.getData().getGlobalOrcSco();
            this.scoreText.setText(localGlobals.getGlobalSco());
            this.scoreText.getJEditorPane().setEditable(true);
            this.globalOrcSco = localGlobals;
        }
        this.undo.discardAllEdits();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

