/*
 * Decompiled with CFR 0.152.
 */
package blue.tools.scanned;

import blue.BlueSystem;
import blue.tools.scanned.MatrixGridEditor;
import blue.tools.scanned.ScannedAbout;
import blue.ui.utilities.FileChooserManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class ScannedMatrixEditor
extends JComponent {
    private static final String FILE_LOAD = "scannedMatrixEditor.load";
    private static final String FILE_SAVE = "scannedMatrixEditor.save";
    MatrixGridEditor matrixGridEditor = new MatrixGridEditor();
    JButton newButton = new JButton();
    JButton loadButton = new JButton();
    JButton saveButton = new JButton();
    JButton randomButton = new JButton();
    JLabel locationLabel = new JLabel();
    JButton plusButton = new JButton();
    JButton minusButton = new JButton();
    JScrollPane scroll = new JScrollPane();

    public ScannedMatrixEditor() {
        JTabbedPane tabs = new JTabbedPane();
        this.setLayout(new BorderLayout());
        this.matrixGridEditor.setLocationLabel(this.locationLabel);
        this.scroll.setViewportView(this.matrixGridEditor);
        this.scroll.setHorizontalScrollBarPolicy(32);
        this.scroll.setVerticalScrollBarPolicy(22);
        tabs.add(BlueSystem.getString((String)"scanned.matrix"), this.scroll);
        tabs.add(BlueSystem.getString((String)"menu.help.about.text"), new ScannedAbout());
        this.newButton.setText(BlueSystem.getString((String)"common.new"));
        this.newButton.addActionListener(e -> this.newMatrix());
        this.loadButton.setText(BlueSystem.getString((String)"common.load"));
        this.loadButton.addActionListener(e -> this.loadMatrix());
        this.saveButton.setText(BlueSystem.getString((String)"common.save"));
        this.saveButton.addActionListener(e -> this.saveMatrix());
        this.randomButton.setText(BlueSystem.getString((String)"common.random"));
        this.randomButton.addActionListener(e -> this.randomMatrix());
        this.plusButton.setText("+");
        this.plusButton.addActionListener(e -> {
            MatrixGridEditor.increaseGridSize();
            this.matrixGridEditor.redoSize();
            this.scroll.revalidate();
            this.scroll.repaint();
        });
        this.minusButton.setText("-");
        this.minusButton.addActionListener(e -> {
            MatrixGridEditor.decreaseGridSize();
            this.matrixGridEditor.redoSize();
            this.scroll.revalidate();
            this.scroll.repaint();
        });
        this.locationLabel.setText("pos (x,x)");
        this.locationLabel.setFont(new Font("Monospaced", 0, 12));
        this.locationLabel.setPreferredSize(new Dimension(150, 27));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1));
        buttonPanel.add(this.newButton);
        buttonPanel.add(this.loadButton);
        buttonPanel.add(this.saveButton);
        buttonPanel.add(this.randomButton);
        buttonPanel.add(this.plusButton);
        buttonPanel.add(this.minusButton);
        buttonPanel.add(this.locationLabel);
        this.add((Component)tabs, "Center");
        this.add((Component)buttonPanel, "South");
    }

    public void newMatrix() {
        String returnText = JOptionPane.showInputDialog(null, BlueSystem.getString((String)"scanned.newMatrix.numMasses.message"), BlueSystem.getString((String)"scanned.newMatrix.numMasses.title"), 3);
        if (returnText != null) {
            try {
                int numOfMasses = Integer.parseInt(returnText);
                boolean[] matrix = new boolean[numOfMasses * numOfMasses];
                for (int i = 0; i < matrix.length; ++i) {
                    matrix[i] = false;
                }
                this.matrixGridEditor.setMatrix(matrix);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(null, BlueSystem.getString((String)"message.integerError.message"), BlueSystem.getString((String)"message.integerError.title"), 0);
                return;
            }
        }
    }

    public void loadMatrix() {
        FileChooserManager fcm = FileChooserManager.getDefault();
        List rValue = fcm.showOpenDialog((Object)FILE_LOAD, null);
        if (!rValue.isEmpty()) {
            File temp = (File)rValue.get(0);
            this.matrixGridEditor.loadMatrix(temp);
        }
    }

    public void saveMatrix() {
        if (this.matrixGridEditor.matrix == null) {
            return;
        }
        FileChooserManager fcm = FileChooserManager.getDefault();
        File rValue = fcm.showSaveDialog((Object)FILE_SAVE, null);
        if (rValue != null) {
            try {
                File temp = rValue;
                try (PrintWriter out = new PrintWriter(new FileWriter(temp));){
                    int val = 0;
                    for (int i = 0; i < this.matrixGridEditor.matrix.length; ++i) {
                        val = this.matrixGridEditor.matrix[i] ? 1 : 0;
                        out.write(val + "\n");
                    }
                    out.flush();
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, BlueSystem.getString((String)"message.saveError.message"), BlueSystem.getString((String)"message.saveError.title"), 0);
                e.printStackTrace();
            }
        }
    }

    public void randomMatrix() {
        if (this.matrixGridEditor.matrix == null) {
            return;
        }
        for (int i = 0; i < this.matrixGridEditor.matrix.length; ++i) {
            this.matrixGridEditor.matrix[i] = Math.random() > 0.5;
        }
        this.matrixGridEditor.repaint();
    }

    public static void main(String[] args) {
        ScannedMatrixEditor scannedMatrixEditor1 = new ScannedMatrixEditor();
        JFrame mFrame = new JFrame();
        mFrame.setTitle("Scanned Synthesis Matrix Editor");
        mFrame.setSize(800, 600);
        mFrame.getContentPane().add(scannedMatrixEditor1);
        mFrame.show();
        mFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    static {
        FileChooserManager fcm = FileChooserManager.getDefault();
        fcm.setDialogTitle((Object)FILE_LOAD, BlueSystem.getString((String)"scanned.loadMatrix"));
        fcm.setDialogTitle((Object)FILE_SAVE, BlueSystem.getString((String)"scanned.saveMatrix"));
    }
}

