/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.tracker;

import blue.soundObject.TrackerObject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;

public class TracksHeader
extends JComponent
implements PropertyChangeListener {
    TrackerObject tracker = null;

    public TracksHeader() {
        this.setDoubleBuffered(true);
        this.setBackground(Color.BLACK);
    }

    public void setTracker(TrackerObject tracker) {
        if (this.tracker != null) {
            this.tracker.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.tracker = tracker;
        this.tracker.addPropertyChangeListener((PropertyChangeListener)this);
        this.updateHeight();
        this.repaint();
    }

    private void updateHeight() {
        if (this.tracker == null) {
            return;
        }
        int steps = this.tracker.getSteps();
        int h = 16 * steps;
        if (this.getHeight() != h) {
            Dimension d = new Dimension(this.getWidth(), h);
            this.setSize(d);
            this.setPreferredSize(d);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.tracker == null) {
            return;
        }
        int steps = this.tracker.getSteps();
        int h = 16 * steps;
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, this.getWidth(), h);
        g.setColor(Color.WHITE);
        if (this.tracker != null) {
            for (int i = 0; i < steps; ++i) {
                int y = (i + 1) * 16;
                if (i % 4 == 0) {
                    g.setColor(Color.DARK_GRAY);
                    g.fillRect(0, y - 16, this.getWidth(), 16);
                    g.setColor(Color.WHITE);
                }
                String label = i < 10 ? "0" + i : Integer.toString(i);
                g.drawString(label, 2, y -= 4);
            }
        }
        g.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, h);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.tracker && evt.getPropertyName().equals("steps")) {
            this.updateHeight();
        }
    }
}

