/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.tracker;

import blue.BlueSystem;
import blue.soundObject.pianoRoll.Scale;
import blue.soundObject.tracker.Column;
import blue.soundObject.tracker.Track;
import blue.ui.utilities.FileChooserManager;
import blue.ui.utilities.SimpleDocumentListener;
import blue.utility.GUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.List;
import javafx.stage.FileChooser;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class TrackEditor
extends JPanel {
    private static final String FILE_CHOOSER_ID = "scaleSelectionPanel";
    private TableModel EMPTY_MODEL = new DefaultTableModel();
    private SpinnerModel MIN_DOUBLE_MODEL;
    private SpinnerModel MAX_DOUBLE_MODEL;
    private SpinnerModel MIN_INT_MODEL;
    private SpinnerModel MAX_INT_MODEL;
    boolean changingNumberModels = false;
    Column selectedColumn = null;
    private JButton addColumnButton;
    private JLabel baseFreqLabel;
    private JTextField baseFreqText;
    private JRadioButton bluePchRadioButton;
    private JLabel colPropsLabel;
    private ButtonGroup columnTypeButtonGroup;
    private JScrollPane columnsScroll;
    private JTable columnsTable;
    private JTextField instrIdTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JRadioButton midiRadioButton;
    private JTextField noteTemplateTextField;
    private JLabel numMaxLabel;
    private JLabel numMinLabel;
    private JSpinner numberMaxSpinner;
    private JSpinner numberMinSpinner;
    private JRadioButton numberRadioButton;
    private JCheckBox outputFreqCheckBox;
    private JRadioButton pchRadioButton;
    private JButton pushDownButton;
    private JButton pushUpButton;
    private JButton removeColumnButton;
    private JCheckBox restrictToIntegerCheckBox;
    private JButton scaleChooserButton;
    private JLabel scaleLabel;
    private JTextField scaleNameTextField;
    private JRadioButton stringRadioButton;
    private JTextField trackNameTextField;
    private JCheckBox useRangeCheckBox;
    private Track track;

    public TrackEditor() {
        this.initComponents();
        this.initScaleFileSelector();
        Dimension miniScrollDim = new Dimension(9, 55);
        this.columnsScroll.getVerticalScrollBar().setPreferredSize(miniScrollDim);
        ActionListener al = e -> {
            if (this.selectedColumn == null) {
                return;
            }
            int colType = 0;
            if (e.getSource() == this.pchRadioButton) {
                colType = 0;
            } else if (e.getSource() == this.bluePchRadioButton) {
                colType = 1;
            } else if (e.getSource() == this.midiRadioButton) {
                colType = 2;
            } else if (e.getSource() == this.stringRadioButton) {
                colType = 3;
            } else if (e.getSource() == this.numberRadioButton) {
                colType = 4;
            }
            this.selectedColumn.setType(colType);
            this.setColumnUI(this.selectedColumn);
        };
        this.MIN_DOUBLE_MODEL = new SpinnerNumberModel(0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0){

            @Override
            public void setValue(Object value) {
                if (value == null || !(value instanceof Number)) {
                    throw new IllegalArgumentException("illegal value");
                }
                if (TrackEditor.this.selectedColumn != null && !TrackEditor.this.changingNumberModels) {
                    Number numberMin = (Number)value;
                    Number numberMax = (Number)TrackEditor.this.MAX_DOUBLE_MODEL.getValue();
                    if (numberMin.doubleValue() > numberMax.doubleValue()) {
                        throw new IllegalArgumentException("Value larger than max");
                    }
                }
                if (!value.equals(this.getValue())) {
                    super.setValue(value);
                }
            }
        };
        this.MAX_DOUBLE_MODEL = new SpinnerNumberModel(0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0){

            @Override
            public void setValue(Object value) {
                if (value == null || !(value instanceof Number)) {
                    throw new IllegalArgumentException("illegal value");
                }
                if (TrackEditor.this.selectedColumn != null && !TrackEditor.this.changingNumberModels) {
                    Number numberMin = (Number)TrackEditor.this.MIN_DOUBLE_MODEL.getValue();
                    Number numberMax = (Number)value;
                    if (numberMax.doubleValue() < numberMin.doubleValue()) {
                        throw new IllegalArgumentException("Value smaller than min");
                    }
                }
                if (!value.equals(this.getValue())) {
                    super.setValue(value);
                }
            }
        };
        this.MIN_INT_MODEL = new SpinnerNumberModel(0, Integer.MIN_VALUE, Integer.MAX_VALUE, 1){

            @Override
            public void setValue(Object value) {
                if (value == null || !(value instanceof Number)) {
                    throw new IllegalArgumentException("illegal value");
                }
                if (TrackEditor.this.selectedColumn != null && !TrackEditor.this.changingNumberModels) {
                    Number numberMin = (Number)value;
                    Number numberMax = (Number)TrackEditor.this.MAX_INT_MODEL.getValue();
                    if (numberMin.intValue() > numberMax.intValue()) {
                        throw new IllegalArgumentException("Value larger than max");
                    }
                }
                if (!value.equals(this.getValue())) {
                    super.setValue(value);
                }
            }
        };
        this.MAX_INT_MODEL = new SpinnerNumberModel(0, Integer.MIN_VALUE, Integer.MAX_VALUE, 1){

            @Override
            public void setValue(Object value) {
                if (value == null || !(value instanceof Number)) {
                    throw new IllegalArgumentException("illegal value");
                }
                if (TrackEditor.this.selectedColumn != null && !TrackEditor.this.changingNumberModels) {
                    Number numberMin = (Number)TrackEditor.this.MIN_INT_MODEL.getValue();
                    Number numberMax = (Number)value;
                    if (numberMax.intValue() < numberMin.intValue()) {
                        throw new IllegalArgumentException("Value smaller than min");
                    }
                }
                if (!value.equals(this.getValue())) {
                    super.setValue(value);
                }
            }
        };
        this.pchRadioButton.addActionListener(al);
        this.bluePchRadioButton.addActionListener(al);
        this.midiRadioButton.addActionListener(al);
        this.stringRadioButton.addActionListener(al);
        this.numberRadioButton.addActionListener(al);
        this.columnsTable.setSelectionMode(0);
        this.columnsTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                int index = this.columnsTable.getSelectedRow();
                if (index < 0) {
                    this.setColumn(null);
                } else {
                    this.setColumn(this.track.getColumn(index + 1));
                }
                this.removeColumnButton.setEnabled(this.selectedColumn != null && this.track.getRowCount() > 1);
                this.pushUpButton.setEnabled(index > 0);
                this.pushDownButton.setEnabled(index < this.columnsTable.getModel().getRowCount() - 1);
            }
        });
        this.trackNameTextField.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (TrackEditor.this.track != null) {
                    TrackEditor.this.track.setName(TrackEditor.this.trackNameTextField.getText());
                }
            }
        });
        this.noteTemplateTextField.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (TrackEditor.this.track != null) {
                    TrackEditor.this.track.setNoteTemplate(TrackEditor.this.noteTemplateTextField.getText());
                }
            }
        });
        this.instrIdTextField.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (TrackEditor.this.track != null) {
                    TrackEditor.this.track.setInstrumentId(TrackEditor.this.instrIdTextField.getText());
                }
            }
        });
        this.baseFreqText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                TrackEditor.this.updateBaseFrequency();
            }
        });
        this.baseFreqText.addActionListener(e -> this.updateBaseFrequency());
        this.setTrack(null);
    }

    protected void updateBaseFrequency() {
        double newValue;
        if (this.selectedColumn == null) {
            return;
        }
        try {
            newValue = Double.parseDouble(this.baseFreqText.getText());
        }
        catch (NumberFormatException nfe) {
            this.baseFreqText.setText(Double.toString(this.selectedColumn.getScale().getBaseFrequency()));
            return;
        }
        if (newValue < 0.0) {
            newValue = 0.0;
        }
        this.selectedColumn.getScale().setBaseFrequency(newValue);
    }

    public synchronized void setTrack(Track track) {
        this.track = null;
        if (track == null) {
            GUI.setAllEnabled((Component)this, (boolean)false, (boolean)true);
            this.trackNameTextField.setText("");
            this.noteTemplateTextField.setText("");
            this.instrIdTextField.setText("");
            this.pushUpButton.setEnabled(false);
            this.pushDownButton.setEnabled(false);
            this.removeColumnButton.setEnabled(false);
            this.columnsTable.setModel(this.EMPTY_MODEL);
            return;
        }
        GUI.setAllEnabled((Component)this, (boolean)true, (boolean)true);
        this.pushUpButton.setEnabled(false);
        this.pushDownButton.setEnabled(false);
        this.removeColumnButton.setEnabled(false);
        this.trackNameTextField.setText(track.getName());
        this.noteTemplateTextField.setText(track.getNoteTemplate());
        this.instrIdTextField.setText(track.getInstrumentId());
        this.columnsTable.setModel((TableModel)track);
        this.setColumn(null);
        this.track = track;
    }

    public void setColumn(Column col) {
        this.selectedColumn = null;
        if (col == null) {
            this.setColumnTypeEnabled(false);
            return;
        }
        this.setColumnTypeEnabled(true);
        this.setNumberModels(col);
        this.setColumnUI(col);
        this.selectedColumn = col;
    }

    private void setColumnTypeEnabled(boolean enabled) {
        this.colPropsLabel.setEnabled(enabled);
        this.pchRadioButton.setEnabled(enabled);
        this.bluePchRadioButton.setEnabled(enabled);
        this.scaleLabel.setEnabled(enabled);
        this.scaleNameTextField.setEnabled(enabled);
        this.scaleChooserButton.setEnabled(enabled);
        this.baseFreqLabel.setEnabled(enabled);
        this.baseFreqText.setEnabled(enabled);
        this.outputFreqCheckBox.setEnabled(enabled);
        this.midiRadioButton.setEnabled(enabled);
        this.stringRadioButton.setEnabled(enabled);
        this.numberRadioButton.setEnabled(enabled);
        this.restrictToIntegerCheckBox.setEnabled(enabled);
        this.useRangeCheckBox.setEnabled(enabled);
        this.numMinLabel.setEnabled(enabled);
        this.numberMinSpinner.setEnabled(enabled);
        this.numMaxLabel.setEnabled(enabled);
        this.numberMaxSpinner.setEnabled(enabled);
    }

    private void setColumnUI(Column column) {
        int colType = column.getType();
        switch (colType) {
            case 0: {
                this.pchRadioButton.setSelected(true);
                break;
            }
            case 1: {
                this.bluePchRadioButton.setSelected(true);
                break;
            }
            case 2: {
                this.midiRadioButton.setSelected(true);
                break;
            }
            case 3: {
                this.stringRadioButton.setSelected(true);
                break;
            }
            case 4: {
                this.numberRadioButton.setSelected(true);
            }
        }
        this.scaleLabel.setEnabled(colType == 1);
        this.scaleNameTextField.setEnabled(colType == 1);
        this.scaleChooserButton.setEnabled(colType == 1);
        this.baseFreqLabel.setEnabled(colType == 1);
        this.baseFreqText.setEnabled(colType == 1);
        this.outputFreqCheckBox.setEnabled(colType == 1);
        this.scaleNameTextField.setText(column.getScale().getScaleName());
        this.baseFreqText.setText(Double.toString(column.getScale().getBaseFrequency()));
        this.outputFreqCheckBox.setSelected(column.isOutputFrequency());
        boolean isNumType = colType == 4;
        this.restrictToIntegerCheckBox.setEnabled(isNumType);
        this.useRangeCheckBox.setEnabled(isNumType);
        boolean rangeEnabled = isNumType && column.isUsingRange();
        this.numberMaxSpinner.setEnabled(rangeEnabled);
        this.numberMinSpinner.setEnabled(rangeEnabled);
        this.numMinLabel.setEnabled(rangeEnabled);
        this.numMaxLabel.setEnabled(rangeEnabled);
        this.restrictToIntegerCheckBox.setSelected(column.isRestrictedToInteger());
        this.useRangeCheckBox.setSelected(column.isUsingRange());
    }

    private void setNumberModels(Column col) {
        this.changingNumberModels = true;
        if (col.isRestrictedToInteger()) {
            this.numberMinSpinner.setModel(this.MIN_INT_MODEL);
            this.numberMinSpinner.setValue(new Integer((int)col.getRangeMin()));
            this.numberMaxSpinner.setModel(this.MAX_INT_MODEL);
            this.numberMaxSpinner.setValue(new Integer((int)col.getRangeMax()));
        } else {
            this.numberMinSpinner.setModel(this.MIN_DOUBLE_MODEL);
            this.numberMinSpinner.setValue(new Double(col.getRangeMin()));
            this.numberMaxSpinner.setModel(this.MAX_DOUBLE_MODEL);
            this.numberMaxSpinner.setValue(new Double(col.getRangeMax()));
        }
        this.changingNumberModels = false;
    }

    private void initComponents() {
        this.columnTypeButtonGroup = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.trackNameTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.columnsScroll = new JScrollPane();
        this.columnsTable = new JTable();
        this.removeColumnButton = new JButton();
        this.addColumnButton = new JButton();
        this.colPropsLabel = new JLabel();
        this.pchRadioButton = new JRadioButton();
        this.bluePchRadioButton = new JRadioButton();
        this.midiRadioButton = new JRadioButton();
        this.numberRadioButton = new JRadioButton();
        this.numberMinSpinner = new JSpinner();
        this.numMinLabel = new JLabel();
        this.numMaxLabel = new JLabel();
        this.numberMaxSpinner = new JSpinner();
        this.restrictToIntegerCheckBox = new JCheckBox();
        this.jLabel8 = new JLabel();
        this.noteTemplateTextField = new JTextField();
        this.jLabel7 = new JLabel();
        this.instrIdTextField = new JTextField();
        this.pushDownButton = new JButton();
        this.pushUpButton = new JButton();
        this.scaleLabel = new JLabel();
        this.stringRadioButton = new JRadioButton();
        this.scaleNameTextField = new JTextField();
        this.scaleChooserButton = new JButton();
        this.useRangeCheckBox = new JCheckBox();
        this.baseFreqLabel = new JLabel();
        this.baseFreqText = new JTextField();
        this.outputFreqCheckBox = new JCheckBox();
        this.jLabel1.setText("Track Properties");
        this.jLabel2.setText("Name:");
        this.trackNameTextField.setMaximumSize(new Dimension(220, 28));
        this.jLabel3.setText("Columns");
        this.columnsTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.columnsScroll.setViewportView(this.columnsTable);
        this.removeColumnButton.setText("-");
        this.removeColumnButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrackEditor.this.removeColumnButtonActionPerformed(evt);
            }
        });
        this.addColumnButton.setText("+");
        this.addColumnButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrackEditor.this.addColumnButtonActionPerformed(evt);
            }
        });
        this.colPropsLabel.setText("Column Properties");
        this.columnTypeButtonGroup.add(this.pchRadioButton);
        this.pchRadioButton.setText("PCH");
        this.pchRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.pchRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.columnTypeButtonGroup.add(this.bluePchRadioButton);
        this.bluePchRadioButton.setText("Blue PCH");
        this.bluePchRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.bluePchRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.columnTypeButtonGroup.add(this.midiRadioButton);
        this.midiRadioButton.setText("MIDI");
        this.midiRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.midiRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.columnTypeButtonGroup.add(this.numberRadioButton);
        this.numberRadioButton.setText("Number");
        this.numberRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.numberRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.numberMinSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TrackEditor.this.numberMinSpinnerStateChanged(evt);
            }
        });
        this.numMinLabel.setText("Min");
        this.numMaxLabel.setText("Max");
        this.numberMaxSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TrackEditor.this.numberMaxSpinnerStateChanged(evt);
            }
        });
        this.restrictToIntegerCheckBox.setText("Restrict to Integer");
        this.restrictToIntegerCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.restrictToIntegerCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.restrictToIntegerCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrackEditor.this.restrictToIntegerCheckBoxActionPerformed(evt);
            }
        });
        this.jLabel8.setText("Note Template:");
        this.noteTemplateTextField.setMaximumSize(new Dimension(220, 28));
        this.jLabel7.setText("Instrument ID:");
        this.instrIdTextField.setMaximumSize(new Dimension(220, 28));
        this.pushDownButton.setText("V");
        this.pushDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrackEditor.this.pushDownButtonActionPerformed(evt);
            }
        });
        this.pushUpButton.setText("^");
        this.pushUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrackEditor.this.pushUpButtonActionPerformed(evt);
            }
        });
        this.scaleLabel.setText("Scale");
        this.columnTypeButtonGroup.add(this.stringRadioButton);
        this.stringRadioButton.setText("String");
        this.stringRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.stringRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.scaleNameTextField.setEditable(false);
        this.scaleChooserButton.setText("...");
        this.scaleChooserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrackEditor.this.scaleChooserButtonActionPerformed(evt);
            }
        });
        this.useRangeCheckBox.setText("Use Range");
        this.useRangeCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.useRangeCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.useRangeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrackEditor.this.useRangeCheckBoxActionPerformed(evt);
            }
        });
        this.baseFreqLabel.setText("Base Freq");
        this.outputFreqCheckBox.setText("Output Frequencies");
        this.outputFreqCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.outputFreqCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.outputFreqCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrackEditor.this.outputFreqCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.columnsScroll, -2, 0, Short.MAX_VALUE).addComponent(this.jLabel1).addComponent(this.jLabel3).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.pushUpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pushDownButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.addColumnButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeColumnButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addComponent(this.jLabel2).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.trackNameTextField, -2, 216, -2).addComponent(this.noteTemplateTextField, -2, 216, -2).addComponent(this.instrIdTextField, -2, 216, -2))).addComponent(this.colPropsLabel).addComponent(this.bluePchRadioButton).addComponent(this.pchRadioButton).addComponent(this.midiRadioButton).addComponent(this.numberRadioButton).addComponent(this.stringRadioButton).addGroup(layout.createSequentialGroup().addGap(17, 17, 17).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.restrictToIntegerCheckBox).addGroup(layout.createSequentialGroup().addGap(17, 17, 17).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.numMaxLabel).addComponent(this.numMinLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.numberMaxSpinner).addComponent(this.numberMinSpinner, GroupLayout.Alignment.LEADING))).addComponent(this.useRangeCheckBox).addComponent(this.outputFreqCheckBox, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.baseFreqLabel).addComponent(this.scaleLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.scaleNameTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scaleChooserButton)).addComponent(this.baseFreqText, GroupLayout.Alignment.LEADING)))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.trackNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.noteTemplateTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.instrIdTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.columnsScroll, -1, 73, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pushUpButton).addComponent(this.pushDownButton).addComponent(this.removeColumnButton).addComponent(this.addColumnButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.colPropsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pchRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bluePchRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scaleLabel).addComponent(this.scaleChooserButton).addComponent(this.scaleNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.baseFreqLabel).addComponent(this.baseFreqText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputFreqCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.midiRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stringRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.numberRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.restrictToIntegerCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useRangeCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numMinLabel).addComponent(this.numberMinSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numMaxLabel).addComponent(this.numberMaxSpinner, -2, -1, -2)).addContainerGap()));
    }

    private void pushDownButtonActionPerformed(ActionEvent evt) {
        if (this.track == null) {
            return;
        }
        int row = this.columnsTable.getSelectedRow();
        if (row < 0 || row > this.track.getRowCount() - 1) {
            return;
        }
        this.track.pushDownColumn(row);
        this.columnsTable.setRowSelectionInterval(row + 1, row + 1);
    }

    private void pushUpButtonActionPerformed(ActionEvent evt) {
        if (this.track == null) {
            return;
        }
        int row = this.columnsTable.getSelectedRow();
        if (row < 1 || row > this.track.getRowCount()) {
            return;
        }
        this.track.pushUpColumn(row);
        this.columnsTable.setRowSelectionInterval(row - 1, row - 1);
    }

    private void outputFreqCheckBoxActionPerformed(ActionEvent evt) {
        if (this.selectedColumn != null) {
            this.selectedColumn.setOutputFrequency(this.outputFreqCheckBox.isSelected());
        }
    }

    private void scaleChooserButtonActionPerformed(ActionEvent evt) {
        if (this.selectedColumn == null) {
            return;
        }
        List rValue = FileChooserManager.getDefault().showOpenDialog((Object)FILE_CHOOSER_ID, null);
        if (!rValue.isEmpty()) {
            File f = (File)rValue.get(0);
            if (!f.exists()) {
                return;
            }
            Scale scale = Scale.loadScale((File)f);
            this.selectedColumn.setScale(scale);
            this.scaleNameTextField.setText(scale.getScaleName());
        }
    }

    private void numberMaxSpinnerStateChanged(ChangeEvent evt) {
        if (this.selectedColumn != null && !this.changingNumberModels) {
            if (this.selectedColumn.isRestrictedToInteger()) {
                Integer val = (Integer)this.numberMaxSpinner.getValue();
                this.selectedColumn.setRangeMax(val.doubleValue());
            } else {
                Double val = (Double)this.numberMaxSpinner.getValue();
                this.selectedColumn.setRangeMax(val.doubleValue());
            }
        }
    }

    private void numberMinSpinnerStateChanged(ChangeEvent evt) {
        if (this.selectedColumn != null && !this.changingNumberModels) {
            if (this.selectedColumn.isRestrictedToInteger()) {
                Integer val = (Integer)this.numberMinSpinner.getValue();
                this.selectedColumn.setRangeMin(val.doubleValue());
            } else {
                Double val = (Double)this.numberMinSpinner.getValue();
                this.selectedColumn.setRangeMin(val.doubleValue());
            }
        }
    }

    private void useRangeCheckBoxActionPerformed(ActionEvent evt) {
        if (this.selectedColumn != null) {
            boolean rangeEnabled = this.useRangeCheckBox.isSelected();
            this.selectedColumn.setUsingRange(rangeEnabled);
            this.numberMaxSpinner.setEnabled(rangeEnabled);
            this.numberMinSpinner.setEnabled(rangeEnabled);
            this.numMinLabel.setEnabled(rangeEnabled);
            this.numMaxLabel.setEnabled(rangeEnabled);
        }
    }

    private void restrictToIntegerCheckBoxActionPerformed(ActionEvent evt) {
        if (this.selectedColumn != null) {
            this.selectedColumn.setRestrictedToInteger(this.restrictToIntegerCheckBox.isSelected());
            this.setNumberModels(this.selectedColumn);
        }
    }

    private void removeColumnButtonActionPerformed(ActionEvent evt) {
        if (this.selectedColumn == null || this.track == null) {
            return;
        }
        this.track.removeColumn(this.selectedColumn);
    }

    private void addColumnButtonActionPerformed(ActionEvent evt) {
        Column col = new Column();
        col.setName("col" + (this.track.getRowCount() + 1));
        this.track.addColumn(col);
    }

    private void initScaleFileSelector() {
        FileChooserManager fcm = FileChooserManager.getDefault();
        if (fcm.isDialogDefined((Object)FILE_CHOOSER_ID)) {
            return;
        }
        fcm.setDialogTitle((Object)FILE_CHOOSER_ID, BlueSystem.getString((String)"pianoRoll.selectScalaFile"));
        fcm.addFilter((Object)FILE_CHOOSER_ID, new FileChooser.ExtensionFilter("Scala File (*.scl)", new String[]{"*.scl"}));
        String fileName = BlueSystem.getUserConfigurationDirectory();
        fileName = fileName + File.separator + "scl";
        File defaultDir = new File(fileName);
        if (defaultDir.exists() && defaultDir.isDirectory()) {
            fcm.setSelectedFile((Object)FILE_CHOOSER_ID, defaultDir);
        }
    }
}

