/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.pattern;

import blue.soundObject.PatternObject;
import blue.soundObject.editor.pattern.PatternsConstants;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;

public class PatternTimeBar
extends JComponent
implements PropertyChangeListener {
    private static final Font LABEL_FONT = new Font("dialog", 0, 11);
    private PatternObject patternObj = null;

    public PatternTimeBar() {
        this.setPreferredSize(new Dimension(50, PatternsConstants.patternViewHeight));
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getSize().width;
        int h = PatternsConstants.patternViewHeight;
        g.setColor(this.getForeground());
        g.setFont(LABEL_FONT);
        g.drawLine(0, h - 1, w, h - 1);
        if (this.patternObj == null) {
            return;
        }
        int beats = this.patternObj.getBeats();
        int subDivisions = this.patternObj.getSubDivisions();
        int count = beats * subDivisions;
        for (int i = 0; i < beats; ++i) {
            g.drawLine(i * h * subDivisions, 0, i * h * subDivisions, h);
            g.drawString(Integer.toString(i + 1), i * h * subDivisions + 3, 14);
        }
        g.drawLine(count * h, 0, count * h, h);
    }

    public void setPatternObject(PatternObject p) {
        if (this.patternObj != null) {
            this.patternObj.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.patternObj = p;
        this.patternObj.addPropertyChangeListener((PropertyChangeListener)this);
        this.checkSize();
        this.repaint();
    }

    private void checkSize() {
        int height = PatternsConstants.patternViewHeight;
        int width = this.patternObj.getBeats() * this.patternObj.getSubDivisions() * height;
        this.setPreferredSize(new Dimension(width, height));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.patternObj && evt.getPropertyName().equals("time")) {
            this.checkSize();
            this.repaint();
        }
    }
}

