/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.jmask.probability;

import blue.soundObject.editor.jmask.DurationSettable;
import blue.soundObject.editor.jmask.TableEditor;
import blue.soundObject.jmask.probability.Weibull;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WeibullEditor
extends JPanel
implements DurationSettable {
    private Weibull weibull = null;
    private ButtonGroup aButtonGroup;
    private ButtonGroup bButtonGroup;
    private JSpinner sSpinner;
    private TableEditor sTableEditor;
    private JComboBox sTypeComboBox;
    private JSpinner tSpinner;
    private TableEditor tTableEditor;
    private JComboBox tTypeComboBox;

    public WeibullEditor(Weibull weibull) {
        this.initComponents();
        this.sTableEditor.setMinMaxEnabled(false);
        this.tTableEditor.setPositiveValues();
        this.sTableEditor.setTable(weibull.getSTable());
        this.tTableEditor.setTable(weibull.getTTable());
        this.sSpinner.setModel(new SpinnerNumberModel(weibull.getS(), 0.0, 1.0, 0.1));
        this.tSpinner.setModel(new SpinnerNumberModel(new Double(weibull.getT()), new Double(Double.MIN_VALUE), null, new Double(0.1)));
        this.sTypeComboBox.setSelectedIndex(weibull.isSTableEnabled() ? 1 : 0);
        this.tTypeComboBox.setSelectedIndex(weibull.isTTableEnabled() ? 1 : 0);
        this.weibull = weibull;
        this.updateDisplay();
    }

    private void updateDisplay() {
        this.sSpinner.setVisible(!this.weibull.isSTableEnabled());
        this.sTableEditor.setVisible(this.weibull.isSTableEnabled());
        this.tSpinner.setVisible(!this.weibull.isTTableEnabled());
        this.tTableEditor.setVisible(this.weibull.isTTableEnabled());
    }

    private void initComponents() {
        this.aButtonGroup = new ButtonGroup();
        this.bButtonGroup = new ButtonGroup();
        this.sSpinner = new JSpinner();
        this.sTableEditor = new TableEditor();
        this.tSpinner = new JSpinner();
        this.tTableEditor = new TableEditor();
        this.sTypeComboBox = new JComboBox();
        this.tTypeComboBox = new JComboBox();
        this.sSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                WeibullEditor.this.sSpinnerStateChanged(evt);
            }
        });
        this.tSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                WeibullEditor.this.tSpinnerStateChanged(evt);
            }
        });
        this.sTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"s (Constant)", "s (Table)"}));
        this.sTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WeibullEditor.this.sTypeComboBoxActionPerformed(evt);
            }
        });
        this.tTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"t (Constant)", "t (Table)"}));
        this.tTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WeibullEditor.this.tTypeComboBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.sTypeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sSpinner, -2, 84, -2)).addGroup(layout.createSequentialGroup().addComponent(this.tTypeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tSpinner, -2, 84, -2)).addComponent(this.sTableEditor, -2, 414, Short.MAX_VALUE).addComponent(this.tTableEditor, -2, 414, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.sTypeComboBox, this.tTypeComboBox);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sSpinner, -2, -1, -2).addComponent(this.sTypeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sTableEditor, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tTypeComboBox, -2, -1, -2).addComponent(this.tSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tTableEditor, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void sSpinnerStateChanged(ChangeEvent evt) {
        if (this.weibull != null) {
            this.weibull.setS(((Double)this.sSpinner.getValue()).doubleValue());
        }
    }

    private void tSpinnerStateChanged(ChangeEvent evt) {
        if (this.weibull != null) {
            this.weibull.setT(((Double)this.tSpinner.getValue()).doubleValue());
        }
    }

    private void sTypeComboBoxActionPerformed(ActionEvent evt) {
        if (this.weibull != null) {
            this.weibull.setSTableEnabled(this.sTypeComboBox.getSelectedIndex() == 1);
            this.updateDisplay();
        }
    }

    private void tTypeComboBoxActionPerformed(ActionEvent evt) {
        if (this.weibull != null) {
            this.weibull.setTTableEnabled(this.tTypeComboBox.getSelectedIndex() == 1);
            this.updateDisplay();
        }
    }

    @Override
    public void setDuration(double duration) {
        this.sTableEditor.setDuration(duration);
        this.tTableEditor.setDuration(duration);
    }
}

