/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.jmask;

import blue.soundObject.editor.jmask.DurationSettable;
import blue.soundObject.editor.jmask.TableEditor;
import blue.soundObject.jmask.Accumulator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AccumulatorEditor
extends JPanel
implements DurationSettable {
    private Accumulator accumulator = null;
    private ButtonGroup highButtonGroup;
    private JSpinner highSpinner;
    private TableEditor highTableEditor;
    private JComboBox highTypeComboBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private ButtonGroup lowButtonGroup;
    private JSpinner lowSpinner;
    private TableEditor lowTableEditor;
    private JComboBox lowTypeComboBox;
    private JComboBox modeComboBox;

    public AccumulatorEditor(Accumulator accumulator) {
        this.initComponents();
        this.modeComboBox.setSelectedIndex(accumulator.getMode());
        this.highTableEditor.setTable(accumulator.getHighTable());
        this.lowTableEditor.setTable(accumulator.getLowTable());
        this.highSpinner.setModel(new SpinnerNumberModel(accumulator.getHigh(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.1));
        this.lowSpinner.setModel(new SpinnerNumberModel(accumulator.getLow(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.1));
        this.highTypeComboBox.setSelectedIndex(accumulator.isHighTableEnabled() ? 1 : 0);
        this.lowTypeComboBox.setSelectedIndex(accumulator.isLowTableEnabled() ? 1 : 0);
        this.accumulator = accumulator;
        this.updateDisplay();
    }

    private void updateDisplay() {
        this.highSpinner.setVisible(!this.accumulator.isHighTableEnabled());
        this.highTableEditor.setVisible(this.accumulator.isHighTableEnabled());
        this.lowSpinner.setVisible(!this.accumulator.isLowTableEnabled());
        this.lowTableEditor.setVisible(this.accumulator.isLowTableEnabled());
    }

    @Override
    public void setDuration(double duration) {
        this.highTableEditor.setDuration(duration);
        this.lowTableEditor.setDuration(duration);
    }

    private void initComponents() {
        this.highButtonGroup = new ButtonGroup();
        this.lowButtonGroup = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.modeComboBox = new JComboBox();
        this.highSpinner = new JSpinner();
        this.highTableEditor = new TableEditor();
        this.lowSpinner = new JSpinner();
        this.lowTableEditor = new TableEditor();
        this.jLabel2 = new JLabel();
        this.highTypeComboBox = new JComboBox();
        this.lowTypeComboBox = new JComboBox();
        this.jLabel1.setText("Accumulator");
        this.modeComboBox.setModel(new DefaultComboBoxModel<String>(Accumulator.MODES));
        this.modeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AccumulatorEditor.this.modeComboBoxActionPerformed(evt);
            }
        });
        this.highSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                AccumulatorEditor.this.highSpinnerStateChanged(evt);
            }
        });
        this.lowSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                AccumulatorEditor.this.lowSpinnerStateChanged(evt);
            }
        });
        this.jLabel2.setText("Mode");
        this.highTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"High Value (Constant)", "High Value (Table)"}));
        this.highTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AccumulatorEditor.this.highTypeComboBoxActionPerformed(evt);
            }
        });
        this.lowTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Low Value (Constant)", "Low Value (Table)"}));
        this.lowTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AccumulatorEditor.this.lowTypeComboBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.highTableEditor, -2, 592, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.lowTypeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lowSpinner, -2, 84, -2)).addComponent(this.lowTableEditor, -2, 592, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.modeComboBox, 0, -1, Short.MAX_VALUE)).addComponent(this.highTypeComboBox, GroupLayout.Alignment.LEADING, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.highSpinner, -2, 84, -2))).addContainerGap()));
        layout.linkSize(0, this.highTypeComboBox, this.lowTypeComboBox);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2, -2, 13, -2).addComponent(this.modeComboBox, -2, -1, -2)).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.highTypeComboBox, -2, -1, -2).addComponent(this.highSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.highTableEditor, -2, -1, -2).addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lowTypeComboBox, -2, -1, -2).addComponent(this.lowSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lowTableEditor, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void highSpinnerStateChanged(ChangeEvent evt) {
        if (this.accumulator != null) {
            this.accumulator.setHigh(((Double)this.highSpinner.getValue()).doubleValue());
        }
    }

    private void lowSpinnerStateChanged(ChangeEvent evt) {
        if (this.accumulator != null) {
            this.accumulator.setLow(((Double)this.lowSpinner.getValue()).doubleValue());
        }
    }

    private void modeComboBoxActionPerformed(ActionEvent evt) {
        if (this.accumulator != null) {
            this.accumulator.setMode(this.modeComboBox.getSelectedIndex());
        }
    }

    private void highTypeComboBoxActionPerformed(ActionEvent evt) {
        if (this.accumulator != null) {
            this.accumulator.setHighTableEnabled(this.highTypeComboBox.getSelectedIndex() == 1);
            this.updateDisplay();
        }
    }

    private void lowTypeComboBoxActionPerformed(ActionEvent evt) {
        if (this.accumulator != null) {
            this.accumulator.setLowTableEnabled(this.lowTypeComboBox.getSelectedIndex() == 1);
            this.updateDisplay();
        }
    }
}

