/*
 * Decompiled with CFR 0.152.
 */
package blue.components;

import blue.settings.GeneralSettings;
import blue.ui.core.score.layers.SelectionMarquee;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class AlphaMarquee
extends JComponent
implements SelectionMarquee {
    private static final Color alphaWhite = new Color(255, 255, 255, 64);
    Point origin;
    public double startTime;
    public double endTime;

    public void setStart(Point p) {
        this.origin = p;
        this.setDragPoint(p);
    }

    public void setDragPoint(Point p) {
        int x = p.x < this.origin.x ? p.x : this.origin.x;
        int y = p.y < this.origin.y ? p.y : this.origin.y;
        int w = Math.abs(p.x - this.origin.x);
        int h = Math.abs(p.y - this.origin.y);
        this.setLocation(x, y);
        this.setSize(w, h);
        this.repaint();
    }

    @Override
    public boolean intersects(JComponent c) {
        int marqueeLeft = this.getX();
        int marqueeRight = marqueeLeft + this.getWidth();
        int marqueeTop = this.getY();
        int marqueeBottom = marqueeTop + this.getHeight();
        Rectangle r = SwingUtilities.convertRectangle(c.getParent(), c.getBounds(), this.getParent());
        int left = r.x;
        int right = left + r.width;
        int top = r.y;
        int bottom = top + r.height;
        return left < marqueeRight && right > marqueeLeft && top < marqueeBottom && bottom > marqueeTop;
    }

    @Override
    public void paint(Graphics g) {
        if (GeneralSettings.getInstance().isAlphaEnabled()) {
            g.setColor(alphaWhite);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        g.setColor(Color.white);
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    @Override
    public Rectangle getTranslatedRect(JComponent comp) {
        return SwingUtilities.convertRectangle(this.getParent(), this.getBounds(), comp);
    }
}

