/*
 * Decompiled with CFR 0.152.
 */
package blue.score.layers.audio.ui;

import blue.score.layers.audio.core.FadeType;

public class FadeRenderer {
    private static double[] SYMMETRIC_IN_POINTS;
    private static double[][] SYMMETRIC_IN_COEFS;
    private static double[] SYMMETRIC_OUT_POINTS;
    private static double[][] SYMMETRIC_OUT_COEFS;
    private static double PI_2;

    protected static double ampdb(double db) {
        return Math.pow(10.0, db * 0.05);
    }

    protected static double dbamp(double amp) {
        return 20.0 * Math.log10(amp);
    }

    protected static double[] getSymmetricCurvePoints() {
        double[] points = new double[20];
        points[0] = 0.0;
        points[1] = 1.0;
        points[2] = 0.5;
        points[3] = 0.6;
        for (int i = 2; i < 9; ++i) {
            double coef = 0.3 * Math.pow(0.5, i);
            double ix = 0.7 + 0.3 * ((double)i / 9.0);
            int indx = i * 2;
            points[indx] = ix;
            points[indx + 1] = coef;
        }
        points[18] = 1.0;
        points[19] = 1.0E-7;
        return points;
    }

    protected static double[] reverseCurve(double[] points) {
        int len = points.length;
        double[] retVal = new double[len];
        double dur = points[len - 2];
        for (int i = 0; i < len; i += 2) {
            int inIndx = len - i - 2;
            retVal[i] = dur - points[inIndx];
            retVal[i + 1] = points[inIndx + 1];
        }
        return retVal;
    }

    protected static double[][] calcCubicCoefficients(double[] points) {
        int len = points.length / 2;
        double[][] retVal = new double[len - 1][4];
        double ifplast = 0.0;
        for (int i = 0; i < len; ++i) {
            double islope_before;
            double islope_after;
            if (i == 0) {
                double ilp0 = (points[2] - points[0]) / (points[3] - points[1]);
                double ilp1 = (points[4] - points[2]) / (points[5] - points[3]);
                double ifpone = ilp0 * ilp1 < 0.0 ? 0.0 : 2.0 / (ilp1 + ilp0);
                ifplast = 3.0 * (points[3] - points[1]) / (2.0 * (points[2] - points[0])) - ifpone * 0.5;
                continue;
            }
            int indx2 = i * 2;
            double ixdelta = points[indx2] - points[indx2 - 2];
            double ixdelta2 = ixdelta * ixdelta;
            double iydelta = points[indx2 + 1] - points[indx2 - 1];
            double ifpi = i == len - 1 ? 3.0 * iydelta / (2.0 * ixdelta) - ifplast * 0.5 : ((islope_after = ixdelta / iydelta) * (islope_before = (points[indx2 + 2] - points[indx2]) / (points[indx2 + 3] - points[indx2 + 1])) < 0.0 ? 0.0 : 2.0 / (islope_after + islope_before));
            double ifppL = -2.0 * (ifpi + 2.0 * ifplast) / ixdelta + 6.0 * iydelta / ixdelta2;
            double ifppR = 2.0 * (2.0 * ifpi + ifplast) / ixdelta - 6.0 * iydelta / ixdelta2;
            double id = (ifppR - ifppL) / (6.0 * ixdelta);
            double ic = (points[indx2] * ifppL - points[indx2 - 2] * ifppR) / (2.0 * ixdelta);
            double ixim1 = points[indx2 - 2];
            double ixi = points[indx2];
            double iyim1 = points[indx2 - 1];
            double ixim12 = ixim1 * ixim1;
            double ixim13 = ixim12 * ixim1;
            double ixi2 = ixi * ixi;
            double ixi3 = ixi2 * ixi;
            double ib = (iydelta - ic * (ixi2 - ixim12) - id * (ixi3 - ixim13)) / ixdelta;
            int ioff = i - 1;
            retVal[ioff][0] = iyim1 - ib * ixim1 - ic * ixim12 - id * ixim13;
            retVal[ioff][1] = ib;
            retVal[ioff][2] = ic;
            retVal[ioff][3] = id;
            ifplast = ifpi;
        }
        return retVal;
    }

    protected static double calcSymmetric(double x, double[][] coefs, double[] points) {
        int numPoints = points.length / 2;
        double[] cubicCoefs = coefs[0];
        for (int i = 1; i < numPoints && x > points[i * 2]; ++i) {
            cubicCoefs = coefs[i];
        }
        double x2 = x * x;
        double x3 = x2 * x;
        double retVal = cubicCoefs[0] + x * cubicCoefs[1] + x2 * cubicCoefs[2] + x3 * cubicCoefs[3];
        return retVal;
    }

    public static double getValue(double x, FadeType fadeType, boolean fadeIn) {
        double retVal = 0.0;
        if (fadeIn) {
            switch (fadeType) {
                case LINEAR: {
                    retVal = x;
                    break;
                }
                case CONSTANT_POWER: {
                    retVal = Math.sin(x * PI_2);
                    break;
                }
                case SYMMETRIC: {
                    retVal = FadeRenderer.calcSymmetric(x, SYMMETRIC_IN_COEFS, SYMMETRIC_IN_POINTS);
                    break;
                }
                case FAST: {
                    retVal = 0.001 * Math.pow(FadeRenderer.ampdb(60.0), x);
                    break;
                }
                case SLOW: {
                    double coef = FadeRenderer.ampdb(-1.0) * Math.pow(FadeRenderer.ampdb(1.0), x);
                    double coef2 = FadeRenderer.ampdb(-80.0) * Math.pow(FadeRenderer.ampdb(80.0), x);
                    retVal = FadeRenderer.ampdb(FadeRenderer.dbamp(coef) * x + FadeRenderer.dbamp(coef2) * (1.0 - x));
                }
            }
        } else {
            switch (fadeType) {
                case LINEAR: {
                    retVal = 1.0 - x;
                    break;
                }
                case CONSTANT_POWER: {
                    retVal = Math.cos(x * PI_2);
                    break;
                }
                case SYMMETRIC: {
                    retVal = FadeRenderer.calcSymmetric(x, SYMMETRIC_OUT_COEFS, SYMMETRIC_OUT_POINTS);
                    break;
                }
                case FAST: {
                    retVal = Math.pow(FadeRenderer.ampdb(-60.0), x);
                    break;
                }
                case SLOW: {
                    double coef = Math.pow(FadeRenderer.ampdb(-1.0), x);
                    double coef2 = Math.pow(FadeRenderer.ampdb(-80.0), x);
                    retVal = FadeRenderer.ampdb(FadeRenderer.dbamp(coef) * (1.0 - x) + FadeRenderer.dbamp(coef2) * x);
                }
            }
        }
        return retVal;
    }

    protected static double inversePower(double x) {
        return Math.sqrt(1.0 - Math.pow(x, 2.0));
    }

    public static float getInverseValue(float x, FadeType fadeType, boolean fadeIn) {
        switch (fadeType) {
            case LINEAR: 
            case CONSTANT_POWER: 
            case SYMMETRIC: {
                double retVal = FadeRenderer.getValue(x, fadeType, !fadeIn);
                break;
            }
            case FAST: 
            case SLOW: {
                double d = FadeRenderer.inversePower(FadeRenderer.getValue(x, fadeType, fadeIn));
            }
        }
        return 0.0f;
    }

    static {
        PI_2 = 1.5707963267948966;
        SYMMETRIC_OUT_POINTS = FadeRenderer.getSymmetricCurvePoints();
        SYMMETRIC_IN_POINTS = FadeRenderer.reverseCurve(SYMMETRIC_OUT_POINTS);
        SYMMETRIC_IN_COEFS = FadeRenderer.calcCubicCoefficients(SYMMETRIC_IN_POINTS);
        SYMMETRIC_OUT_COEFS = FadeRenderer.calcCubicCoefficients(SYMMETRIC_OUT_POINTS);
    }
}

