/*
 * Decompiled with CFR 0.152.
 */
package blue.plaf;

import blue.plaf.BlueButtonBorder;
import blue.plaf.BlueLookAndFeel;
import blue.plaf.BlueTextFieldBorder;
import blue.plaf.BlueToggleButtonBorder;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.basic.BasicBorders;

public class BlueBorderUtilities {
    private static Border buttonBorder;
    private static Border textBorder;
    private static Border textFieldBorder;
    private static Border spinnerBorder;
    private static Border toggleButtonBorder;

    static void drawSimple3DBorder(Graphics g, Rectangle r) {
        BlueBorderUtilities.drawSimple3DBorder(g, r.x, r.y, r.width, r.height);
    }

    static void drawSimple3DBorder(Graphics g, int x, int y, int w, int h) {
        BlueBorderUtilities.drawSimple3DBorder(g, x, y, w, h, BlueLookAndFeel.getControlDarkShadow(), BlueLookAndFeel.getControlHighlight());
    }

    static void drawPressed3DBorder(Graphics g, Rectangle r) {
        BlueBorderUtilities.drawPressed3DBorder(g, r.x, r.y, r.width, r.height);
    }

    public static void drawDisabledBorder(Graphics g, int x, int y, int w, int h) {
        BlueBorderUtilities.drawSimple3DBorder(g, x, y, w, h, BlueLookAndFeel.getControlShadow(), BlueLookAndFeel.getControlHighlight());
    }

    static void drawPressed3DBorder(Graphics g, int x, int y, int w, int h) {
        BlueBorderUtilities.drawSimple3DBorder(g, x, y, w, h, BlueLookAndFeel.getControlHighlight(), BlueLookAndFeel.getControlDarkShadow());
    }

    public static final void drawSimple3DBorder(Graphics g, int x, int y, int w, int h, Color highlight, Color shadow) {
        g.translate(x, y);
        g.setColor(highlight);
        g.drawLine(0, 0, w - 2, 0);
        g.drawLine(0, 1, 0, h - 1);
        g.setColor(shadow);
        g.drawLine(w - 1, 0, w - 1, h - 2);
        g.drawLine(1, h - 1, w - 1, h - 1);
        g.translate(-x, -y);
    }

    public static final void drawBevel3DBorder(Graphics g, int x, int y, int w, int h, Color highlight, Color shadow, Color innerHighlight, Color innerShadow) {
        g.translate(x, y);
        g.setColor(highlight);
        g.drawLine(0, 0, w - 2, 0);
        g.drawLine(0, 1, 0, h - 1);
        g.setColor(shadow);
        g.drawLine(w - 1, 0, w - 1, h - 2);
        g.drawLine(1, h - 1, w - 1, h - 1);
        ++x;
        ++y;
        g.setColor(innerHighlight);
        g.drawLine(0, 0, --w - 2, 0);
        g.drawLine(0, 1, 0, --h - 1);
        g.setColor(innerShadow);
        g.drawLine(w - 1, 0, w - 1, h - 2);
        g.drawLine(1, h - 1, w - 1, h - 1);
        g.translate(-x, -y);
    }

    static void drawPressed3DFieldBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        g.setColor(BlueLookAndFeel.getControlHighlight());
        g.drawRect(1, 1, w - 2, h - 2);
        g.setColor(BlueLookAndFeel.getControlDarkShadow());
        g.drawRect(0, 0, w - 2, h - 2);
        g.translate(-x, -y);
    }

    static void drawDefaultButtonBorder(Graphics g, int x, int y, int w, int h) {
        BlueBorderUtilities.drawSimple3DBorder(g, x + 1, y + 1, w - 2, h - 2, BlueLookAndFeel.getControlDarkShadow(), BlueLookAndFeel.getControlHighlight());
        g.setColor(new Color(255, 255, 255, 128));
        g.drawLine(x + 2, y + 2, x + w - 3, y + 2);
    }

    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new BorderUIResource.CompoundBorderUIResource(new BlueButtonBorder(), new BasicBorders.MarginBorder());
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        if (toggleButtonBorder == null) {
            toggleButtonBorder = new BorderUIResource.CompoundBorderUIResource(new BlueToggleButtonBorder(), new BasicBorders.MarginBorder());
        }
        return toggleButtonBorder;
    }

    public static Border getTextBorder() {
        if (textBorder == null) {
            textBorder = new BorderUIResource.CompoundBorderUIResource(new BlueTextFieldBorder(), new BasicBorders.MarginBorder());
        }
        return textBorder;
    }

    public static Border getTextFieldBorder() {
        if (textFieldBorder == null) {
            textFieldBorder = new BorderUIResource.CompoundBorderUIResource(new BlueTextFieldBorder(), new BasicBorders.MarginBorder());
        }
        return textFieldBorder;
    }
}

