/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

class SplitCmd
implements Command {
    private static char[] defSplitChars = new char[]{' ', '\n', '\t', '\r'};

    SplitCmd() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        char[] splitChars = null;
        if (argv.length == 2) {
            splitChars = defSplitChars;
        } else if (argv.length == 3) {
            splitChars = argv[2].toString().toCharArray();
        } else {
            throw new TclNumArgsException(interp, 1, argv, "string ?splitChars?");
        }
        String string = argv[1].toString();
        int len = string.length();
        int num = splitChars.length;
        if (num == 0) {
            TclObject list = TclList.newInstance();
            list.preserve();
            try {
                for (int i = 0; i < len; ++i) {
                    TclList.append(interp, list, TclString.newInstance((char)string.charAt(i)));
                }
                interp.setResult(list);
            }
            finally {
                list.release();
            }
            return;
        }
        TclObject list = TclList.newInstance();
        int elemStart = 0;
        list.preserve();
        try {
            int i;
            block7: for (i = 0; i < len; ++i) {
                char c = string.charAt(i);
                for (int j = 0; j < num; ++j) {
                    if (c != splitChars[j]) continue;
                    TclList.append(interp, list, TclString.newInstance((String)string.substring(elemStart, i)));
                    elemStart = i + 1;
                    continue block7;
                }
            }
            if (i != 0) {
                TclList.append(interp, list, TclString.newInstance((String)string.substring(elemStart)));
            }
            interp.setResult(list);
        }
        finally {
            list.release();
        }
    }
}

