/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Enumeration;
import tcl.lang.Channel;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.InterpAliasCmd;
import tcl.lang.InterpSlaveCmd;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

class InterpCmd
implements Command {
    private static final String[] options = new String[]{"alias", "aliases", "create", "delete", "eval", "exists", "expose", "hide", "hidden", "issafe", "invokehidden", "marktrusted", "slaves", "share", "target", "transfer"};
    private static final int OPT_ALIAS = 0;
    private static final int OPT_ALIASES = 1;
    private static final int OPT_CREATE = 2;
    private static final int OPT_DELETE = 3;
    private static final int OPT_EVAL = 4;
    private static final int OPT_EXISTS = 5;
    private static final int OPT_EXPOSE = 6;
    private static final int OPT_HIDE = 7;
    private static final int OPT_HIDDEN = 8;
    private static final int OPT_ISSAFE = 9;
    private static final int OPT_INVOKEHIDDEN = 10;
    private static final int OPT_MARKTRUSTED = 11;
    private static final int OPT_SLAVES = 12;
    private static final int OPT_SHARE = 13;
    private static final int OPT_TARGET = 14;
    private static final int OPT_TRANSFER = 15;
    private static final String[] createOptions = new String[]{"-safe", "--"};
    private static final int OPT_CREATE_SAFE = 0;
    private static final int OPT_CREATE_LAST = 1;
    private static final String[] hiddenOptions = new String[]{"-global", "--"};
    private static final int OPT_HIDDEN_GLOBAL = 0;
    private static final int OPT_HIDDEN_LAST = 1;

    InterpCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length < 2) {
            throw new TclNumArgsException(interp, 1, objv, "cmd ?arg ...?");
        }
        int cmd = TclIndex.get((Interp)interp, (TclObject)objv[1], (String[])options, (String)"option", (int)0);
        switch (cmd) {
            case 0: {
                if (objv.length >= 4) {
                    Interp slaveInterp = InterpCmd.getInterp(interp, objv[2]);
                    if (objv.length == 4) {
                        InterpAliasCmd.describe(interp, slaveInterp, objv[3]);
                        return;
                    }
                    if (objv.length == 5 && "".equals(objv[4].toString())) {
                        InterpAliasCmd.delete(interp, slaveInterp, objv[3]);
                        return;
                    }
                    if (objv.length > 5) {
                        Interp masterInterp = InterpCmd.getInterp(interp, objv[4]);
                        if ("".equals(objv[5].toString())) {
                            if (objv.length == 6) {
                                InterpAliasCmd.delete(interp, slaveInterp, objv[3]);
                                return;
                            }
                        } else {
                            InterpAliasCmd.create(interp, slaveInterp, masterInterp, objv[3], objv[5], 6, objv);
                            return;
                        }
                    }
                }
                throw new TclNumArgsException(interp, 2, objv, "slavePath slaveCmd ?masterPath masterCmd? ?args ..?");
            }
            case 1: {
                Interp slaveInterp = InterpCmd.getInterp(interp, objv);
                InterpAliasCmd.list(interp, slaveInterp);
                break;
            }
            case 2: {
                int i;
                boolean safe = interp.isSafe;
                TclObject slaveNameObj = null;
                boolean last = false;
                for (i = 2; i < objv.length; ++i) {
                    if (!last && objv[i].toString().charAt(0) == '-') {
                        int index = TclIndex.get((Interp)interp, (TclObject)objv[i], (String[])createOptions, (String)"option", (int)0);
                        if (index == 0) {
                            safe = true;
                            continue;
                        }
                        ++i;
                        last = true;
                    }
                    if (slaveNameObj != null) {
                        throw new TclNumArgsException(interp, 2, objv, "?-safe? ?--? ?path?");
                    }
                    slaveNameObj = objv[i];
                }
                if (slaveNameObj == null) {
                    i = 0;
                    while (interp.getCommand("interp" + i) != null) {
                        ++i;
                    }
                    slaveNameObj = TclString.newInstance((String)("interp" + i));
                }
                InterpSlaveCmd.create(interp, slaveNameObj, safe);
                interp.setResult(slaveNameObj);
                break;
            }
            case 3: {
                for (int i = 2; i < objv.length; ++i) {
                    Interp slaveInterp = InterpCmd.getInterp(interp, objv[i]);
                    if (slaveInterp == interp) {
                        throw new TclException(interp, "cannot delete the current interpreter");
                    }
                    InterpSlaveCmd slave = slaveInterp.slave;
                    slave.masterInterp.deleteCommandFromToken(slave.interpCmd);
                }
                break;
            }
            case 4: {
                if (objv.length < 4) {
                    throw new TclNumArgsException(interp, 2, objv, "path arg ?arg ...?");
                }
                Interp slaveInterp = InterpCmd.getInterp(interp, objv[2]);
                InterpSlaveCmd.eval(interp, slaveInterp, 3, objv);
                break;
            }
            case 5: {
                boolean exists = true;
                try {
                    InterpCmd.getInterp(interp, objv);
                }
                catch (TclException e) {
                    if (objv.length > 3) {
                        throw e;
                    }
                    exists = false;
                }
                interp.setResult(exists);
                break;
            }
            case 6: {
                if (objv.length < 4 || objv.length > 5) {
                    throw new TclNumArgsException(interp, 2, objv, "path hiddenCmdName ?cmdName?");
                }
                Interp slaveInterp = InterpCmd.getInterp(interp, objv[2]);
                InterpSlaveCmd.expose(interp, slaveInterp, 3, objv);
                break;
            }
            case 7: {
                if (objv.length < 4 || objv.length > 5) {
                    throw new TclNumArgsException(interp, 2, objv, "path cmdName ?hiddenCmdName?");
                }
                Interp slaveInterp = InterpCmd.getInterp(interp, objv[2]);
                InterpSlaveCmd.hide(interp, slaveInterp, 3, objv);
                break;
            }
            case 8: {
                Interp slaveInterp = InterpCmd.getInterp(interp, objv);
                InterpSlaveCmd.hidden(interp, slaveInterp);
                break;
            }
            case 9: {
                Interp slaveInterp = InterpCmd.getInterp(interp, objv);
                interp.setResult(slaveInterp.isSafe);
                break;
            }
            case 10: {
                int i;
                boolean global = false;
                for (i = 3; i < objv.length && objv[i].toString().charAt(0) == '-'; ++i) {
                    int index = TclIndex.get((Interp)interp, (TclObject)objv[i], (String[])hiddenOptions, (String)"option", (int)0);
                    if (index != 0) {
                        ++i;
                        break;
                    }
                    global = true;
                }
                if (objv.length - i < 1) {
                    throw new TclNumArgsException(interp, 2, objv, "path ?-global? ?--? cmd ?arg ..?");
                }
                Interp slaveInterp = InterpCmd.getInterp(interp, objv[2]);
                InterpSlaveCmd.invokeHidden(interp, slaveInterp, global, i, objv);
                break;
            }
            case 11: {
                if (objv.length != 3) {
                    throw new TclNumArgsException(interp, 2, objv, "path");
                }
                Interp slaveInterp = InterpCmd.getInterp(interp, objv[2]);
                InterpSlaveCmd.markTrusted(interp, slaveInterp);
                break;
            }
            case 12: {
                Interp slaveInterp = InterpCmd.getInterp(interp, objv);
                TclObject result = TclList.newInstance();
                interp.setResult(result);
                Enumeration keys = slaveInterp.slaveTable.keys();
                while (keys.hasMoreElements()) {
                    String string = (String)keys.nextElement();
                    TclList.append(interp, result, TclString.newInstance((String)string));
                }
                break;
            }
            case 13: {
                if (objv.length != 5) {
                    throw new TclNumArgsException(interp, 2, objv, "srcPath channelId destPath");
                }
                Interp masterInterp = InterpCmd.getInterp(interp, objv[2]);
                Channel chan = TclIO.getChannel(masterInterp, objv[3].toString());
                if (chan == null) {
                    throw new TclException(interp, "can not find channel named \"" + objv[3].toString() + "\"");
                }
                Interp slaveInterp = InterpCmd.getInterp(interp, objv[4]);
                TclIO.registerChannel(slaveInterp, chan);
                break;
            }
            case 14: {
                String aliasName;
                if (objv.length != 4) {
                    throw new TclNumArgsException(interp, 2, objv, "path alias");
                }
                Interp slaveInterp = InterpCmd.getInterp(interp, objv[2]);
                Interp targetInterp = InterpAliasCmd.getTargetInterp(slaveInterp, aliasName = objv[3].toString());
                if (targetInterp == null) {
                    throw new TclException(interp, "alias \"" + aliasName + "\" in path \"" + objv[2].toString() + "\" not found");
                }
                if (InterpCmd.getInterpPath(interp, targetInterp)) break;
                throw new TclException(interp, "target interpreter for alias \"" + aliasName + "\" in path \"" + objv[2].toString() + "\" is not my descendant");
            }
            case 15: {
                if (objv.length != 5) {
                    throw new TclNumArgsException(interp, 2, objv, "srcPath channelId destPath");
                }
                Interp masterInterp = InterpCmd.getInterp(interp, objv[2]);
                Channel chan = TclIO.getChannel(masterInterp, objv[3].toString());
                if (chan == null) {
                    throw new TclException(interp, "can not find channel named \"" + objv[3].toString() + "\"");
                }
                Interp slaveInterp = InterpCmd.getInterp(interp, objv[4]);
                TclIO.registerChannel(slaveInterp, chan);
                TclIO.unregisterChannel(masterInterp, chan);
                break;
            }
        }
    }

    private static Interp getInterp(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length == 2) {
            return interp;
        }
        if (objv.length == 3) {
            return InterpCmd.getInterp(interp, objv[2]);
        }
        throw new TclNumArgsException(interp, 2, objv, "?path?");
    }

    private static boolean getInterpPath(Interp askingInterp, Interp targetInterp) throws TclException {
        if (targetInterp == askingInterp) {
            return true;
        }
        if (targetInterp == null || targetInterp.slave == null) {
            return false;
        }
        if (!InterpCmd.getInterpPath(askingInterp, targetInterp.slave.masterInterp)) {
            return false;
        }
        askingInterp.appendElement(targetInterp.slave.path);
        return true;
    }

    static Interp getInterp(Interp interp, TclObject path) throws TclException {
        TclObject[] objv = TclList.getElements(interp, path);
        Interp searchInterp = interp;
        for (int i = 0; i < objv.length; ++i) {
            String name = objv[i].toString();
            if (!searchInterp.slaveTable.containsKey(name)) {
                searchInterp = null;
                break;
            }
            InterpSlaveCmd slave = (InterpSlaveCmd)searchInterp.slaveTable.get(name);
            searchInterp = slave.slaveInterp;
            if (searchInterp == null) break;
        }
        if (searchInterp == null) {
            throw new TclException(interp, "could not find interpreter \"" + path.toString() + "\"");
        }
        return searchInterp;
    }
}

