/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Vector;
import tcl.lang.AssocData;
import tcl.lang.Command;
import tcl.lang.IdleHandler;
import tcl.lang.Interp;
import tcl.lang.Notifier;
import tcl.lang.StrtoulResult;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.TimerHandler;
import tcl.lang.Util;

class AfterCmd
implements Command {
    AfterAssocData assocData = null;
    private static final String[] validOpts = new String[]{"cancel", "idle", "info"};
    static final int OPT_CANCEL = 0;
    static final int OPT_IDLE = 1;
    static final int OPT_INFO = 2;

    AfterCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        int index;
        Notifier notifier = interp.getNotifier();
        if (this.assocData == null) {
            this.assocData = (AfterAssocData)interp.getAssocData("tclAfter");
            if (this.assocData == null) {
                this.assocData = new AfterAssocData();
                interp.setAssocData("tclAfter", this.assocData);
            }
        }
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        boolean isNumber = false;
        int ms = 0;
        if (argv[1].getInternalRep() instanceof TclInteger) {
            ms = TclInteger.get((Interp)interp, (TclObject)argv[1]);
            isNumber = true;
        } else {
            String s = argv[1].toString();
            if (s.length() > 0 && Character.isDigit(s.charAt(0))) {
                ms = TclInteger.get((Interp)interp, (TclObject)argv[1]);
                isNumber = true;
            }
        }
        if (isNumber) {
            if (ms < 0) {
                ms = 0;
            }
            if (argv.length == 2) {
                long endTime = System.currentTimeMillis() + (long)ms;
                while (true) {
                    try {
                        Thread.sleep(ms);
                        return;
                    }
                    catch (InterruptedException e) {
                        long sysTime = System.currentTimeMillis();
                        if (sysTime >= endTime) {
                            return;
                        }
                        ms = (int)(endTime - sysTime);
                        continue;
                    }
                    break;
                }
            }
            TclObject cmd = this.getCmdObject(argv);
            cmd.preserve();
            ++this.assocData.lastAfterId;
            TimerInfo timerInfo = new TimerInfo(notifier, ms);
            timerInfo.interp = interp;
            timerInfo.command = cmd;
            timerInfo.id = this.assocData.lastAfterId;
            this.assocData.handlers.addElement(timerInfo);
            interp.setResult("after#" + timerInfo.id);
            return;
        }
        try {
            index = TclIndex.get((Interp)interp, (TclObject)argv[1], (String[])validOpts, (String)"option", (int)0);
        }
        catch (TclException e) {
            throw new TclException(interp, "bad argument \"" + argv[1] + "\": must be cancel, idle, info, or a number");
        }
        switch (index) {
            case 0: {
                if (argv.length < 3) {
                    throw new TclNumArgsException(interp, 2, argv, "id|command");
                }
                TclObject arg = this.getCmdObject(argv);
                arg.preserve();
                Object info = null;
                for (int i = 0; i < this.assocData.handlers.size(); ++i) {
                    TclObject cmd;
                    Object obj = this.assocData.handlers.elementAt(i);
                    if (obj instanceof TimerInfo) {
                        cmd = ((TimerInfo)obj).command;
                        if (cmd != arg && !cmd.toString().equals(arg.toString())) continue;
                        info = obj;
                        break;
                    }
                    cmd = ((IdleInfo)obj).command;
                    if (cmd != arg && !cmd.toString().equals(arg.toString())) continue;
                    info = obj;
                    break;
                }
                if (info == null) {
                    info = this.getAfterEvent(arg.toString());
                }
                arg.release();
                if (info == null) break;
                if (info instanceof TimerInfo) {
                    ((TimerInfo)info).cancel();
                    ((TimerInfo)info).command.release();
                } else {
                    ((IdleInfo)info).cancel();
                    ((IdleInfo)info).command.release();
                }
                this.assocData.handlers.removeElement(info);
                break;
            }
            case 1: {
                if (argv.length < 3) {
                    throw new TclNumArgsException(interp, 2, argv, "script script ...");
                }
                TclObject cmd = this.getCmdObject(argv);
                cmd.preserve();
                ++this.assocData.lastAfterId;
                IdleInfo idleInfo = new IdleInfo(notifier);
                idleInfo.interp = interp;
                idleInfo.command = cmd;
                idleInfo.id = this.assocData.lastAfterId;
                this.assocData.handlers.addElement(idleInfo);
                interp.setResult("after#" + idleInfo.id);
                break;
            }
            case 2: {
                if (argv.length == 2) {
                    TclObject list = TclList.newInstance();
                    for (int i = 0; i < this.assocData.handlers.size(); ++i) {
                        Object obj = this.assocData.handlers.elementAt(i);
                        int id = obj instanceof TimerInfo ? ((TimerInfo)obj).id : ((IdleInfo)obj).id;
                        TclList.append(interp, list, TclString.newInstance((String)("after#" + id)));
                    }
                    interp.setResult(list);
                    return;
                }
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "?id?");
                }
                Object info = this.getAfterEvent(argv[2].toString());
                if (info == null) {
                    throw new TclException(interp, "event \"" + argv[2] + "\" doesn't exist");
                }
                TclObject list = TclList.newInstance();
                TclList.append(interp, list, info instanceof TimerInfo ? ((TimerInfo)info).command : ((IdleInfo)info).command);
                TclList.append(interp, list, TclString.newInstance((String)(info instanceof TimerInfo ? "timer" : "idle")));
                interp.setResult(list);
            }
        }
    }

    private TclObject getCmdObject(TclObject[] argv) {
        if (argv.length == 3) {
            return argv[2];
        }
        TclObject cmd = TclString.newInstance((String)Util.concat(2, argv.length - 1, argv));
        return cmd;
    }

    private Object getAfterEvent(String string) {
        if (!string.startsWith("after#")) {
            return null;
        }
        StrtoulResult res = Util.strtoul(string, 6, 10);
        if (res.errno != 0) {
            return null;
        }
        for (int i = 0; i < this.assocData.handlers.size(); ++i) {
            Object obj = this.assocData.handlers.elementAt(i);
            if (!(obj instanceof TimerInfo ? (long)((TimerInfo)obj).id == res.value : (long)((IdleInfo)obj).id == res.value)) continue;
            return obj;
        }
        return null;
    }

    class IdleInfo
    extends IdleHandler {
        Interp interp;
        TclObject command;
        int id;

        IdleInfo(Notifier n) {
            super(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processIdleEvent() {
            try {
                AfterCmd.this.assocData.handlers.removeElement(this);
                this.interp.eval(this.command, 131072);
            }
            catch (TclException e) {
                this.interp.addErrorInfo("\n    (\"after\" script)");
                this.interp.backgroundError();
            }
            finally {
                this.command.release();
                this.command = null;
            }
        }
    }

    class TimerInfo
    extends TimerHandler {
        Interp interp;
        TclObject command;
        int id;

        TimerInfo(Notifier n, int milliseconds) {
            super(n, milliseconds);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processTimerEvent() {
            try {
                AfterCmd.this.assocData.handlers.removeElement(this);
                this.interp.eval(this.command, 131072);
            }
            catch (TclException e) {
                this.interp.addErrorInfo("\n    (\"after\" script)");
                this.interp.backgroundError();
            }
            finally {
                this.command.release();
                this.command = null;
            }
        }
    }

    class AfterAssocData
    implements AssocData {
        Vector handlers = new Vector();
        int lastAfterId = 0;

        AfterAssocData() {
        }

        public void disposeAssocData(Interp interp) {
            for (int i = AfterCmd.this.assocData.handlers.size() - 1; i >= 0; --i) {
                Object info = AfterCmd.this.assocData.handlers.elementAt(i);
                AfterCmd.this.assocData.handlers.removeElementAt(i);
                if (info instanceof TimerInfo) {
                    ((TimerInfo)info).cancel();
                    ((TimerInfo)info).command.release();
                    continue;
                }
                ((IdleInfo)info).cancel();
                ((IdleInfo)info).command.release();
            }
            AfterCmd.this.assocData = null;
        }
    }
}

