/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.tracker;

import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import blue.soundObject.tracker.Column;
import blue.soundObject.tracker.Track;
import blue.soundObject.tracker.TrackerNote;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TrackList
implements TableModel {
    private final ArrayList<Track> tracks = new ArrayList();
    private transient Vector listeners;
    private int steps = 64;
    private transient TableModelListener columnChangeListener = e -> {
        TableModelEvent tme = new TableModelEvent(this, -1);
        this.fireTableModelEvent(tme);
    };

    public TrackList() {
    }

    public TrackList(TrackList tl) {
        this.steps = tl.steps;
        for (Track track : tl.tracks) {
            this.addTrack(new Track(track));
        }
    }

    public void addTrack(Track track) {
        this.tracks.add(track);
        track.resizeSteps(this.steps);
        track.addTableModelListener(this.columnChangeListener);
        if (this.listeners != null) {
            TableModelEvent tme = new TableModelEvent(this, -1);
            this.fireTableModelEvent(tme);
        }
    }

    public void addTrack(int index, Track track) {
        this.tracks.add(index, track);
        track.resizeSteps(this.steps);
        track.addTableModelListener(this.columnChangeListener);
        if (this.listeners != null) {
            TableModelEvent tme = new TableModelEvent(this, -1);
            this.fireTableModelEvent(tme);
        }
    }

    public void removeTrack(int index) {
        this.removeTrack(this.tracks.get(index));
    }

    public void removeTrack(Track track) {
        this.tracks.remove(track);
        track.removeAllPropertyChangeListeners();
        track.removeTableModelListener(this.columnChangeListener);
        if (this.listeners != null) {
            TableModelEvent tme = new TableModelEvent(this, -1);
            this.fireTableModelEvent(tme);
        }
    }

    public void duplicateTrack(int index) {
        if (index >= this.tracks.size()) {
            return;
        }
        Track t = this.getTrack(index);
        Track temp = new Track(t);
        this.addTrack(index, temp);
    }

    public void clearTrack(int index) {
        if (index >= this.tracks.size()) {
            return;
        }
        Track t = this.getTrack(index);
        t.clearNotes();
    }

    public Track getTrack(int index) {
        return this.tracks.get(index);
    }

    public String getNextTrackName() {
        int maxVal = 0;
        for (Track track : this.tracks) {
            String name = track.getName();
            if (!name.startsWith("track")) continue;
            try {
                int val = Integer.parseInt(name.substring(5));
                if (val <= maxVal) continue;
                maxVal = val;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return "track" + (maxVal + 1);
    }

    public boolean contains(Track track) {
        return this.tracks.contains(track);
    }

    public int size() {
        return this.tracks.size();
    }

    public void fireRowChanged(int row) {
        this.fireTableModelEvent(new TableModelEvent(this, row, row));
    }

    private void fireTableModelEvent(TableModelEvent tme) {
        if (this.listeners != null) {
            for (TableModelListener listener : this.listeners) {
                listener.tableChanged(tme);
            }
        }
    }

    public NoteList generateNotes() throws NoteParseException {
        NoteList retVal = new NoteList();
        for (Track tr : this.tracks) {
            retVal.merge(tr.generateNotes());
        }
        return retVal;
    }

    public int getSteps() {
        return this.steps;
    }

    public void setSteps(int steps) {
        this.steps = steps;
        for (Track tr : this.tracks) {
            tr.resizeSteps(steps);
        }
    }

    public Track getTrackForColumn(int index) {
        int counter = index;
        Track retVal = null;
        for (Track track : this.tracks) {
            if (counter >= track.getNumColumns()) {
                counter -= track.getNumColumns();
                continue;
            }
            retVal = track;
            break;
        }
        return retVal;
    }

    public Column getTrackColumn(int index) {
        int counter = index;
        Column retVal = null;
        for (Track track : this.tracks) {
            if (counter >= track.getNumColumns()) {
                counter -= track.getNumColumns();
                continue;
            }
            if (counter == 0) break;
            retVal = track.getColumn(counter);
            break;
        }
        return retVal;
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(l);
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        int count = 0;
        for (Track track : this.tracks) {
            count += track.getNumColumns();
        }
        return count;
    }

    @Override
    public String getColumnName(int columnIndex) {
        Column c = this.getTrackColumn(columnIndex);
        return c == null ? "-" : c.getName();
    }

    @Override
    public int getRowCount() {
        return this.steps;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        int counter = columnIndex;
        String retVal = null;
        for (Track track : this.tracks) {
            if (counter >= track.getNumColumns()) {
                counter -= track.getNumColumns();
                continue;
            }
            TrackerNote note = track.getTrackerNote(rowIndex);
            retVal = note.getValue(counter);
            break;
        }
        return retVal;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        int counter = columnIndex;
        for (Track track : this.tracks) {
            if (counter >= track.getNumColumns()) {
                counter -= track.getNumColumns();
                continue;
            }
            if (counter == 0) {
                return false;
            }
            return !track.getTrackerNote(rowIndex).isOff();
        }
        return true;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        int counter = columnIndex;
        String newVal = (String)aValue;
        for (Track track : this.tracks) {
            if (counter >= track.getNumColumns()) {
                counter -= track.getNumColumns();
                continue;
            }
            TrackerNote currentNote = track.getTrackerNote(rowIndex);
            if ("OFF".equals(newVal) && currentNote.isOff()) {
                return;
            }
            if (!currentNote.isActive()) {
                int i;
                if (newVal == null || newVal.trim().length() == 0) {
                    return;
                }
                TrackerNote previousNote = null;
                for (i = rowIndex - 1; i >= 0; --i) {
                    TrackerNote temp = track.getTrackerNote(i);
                    if (!temp.isActive()) continue;
                    previousNote = temp;
                    break;
                }
                if (previousNote != null) {
                    currentNote.copyValues(previousNote);
                } else {
                    for (i = 0; i < track.getRowCount(); ++i) {
                        Column c = track.getColumn(i + 1);
                        currentNote.setValue(i + 1, c.getDefaultValue());
                    }
                }
            }
            currentNote.setValue(counter, newVal);
            return;
        }
        this.fireRowChanged(rowIndex);
    }

    public int getTrackIndexForColumn(int column) {
        int counter = column;
        int index = 0;
        for (Track track : this.tracks) {
            if (counter < track.getNumColumns()) break;
            counter -= track.getNumColumns();
            ++index;
        }
        return index;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public Element saveAsXML() {
        Element retVal = new Element("trackList");
        retVal.addElement(XMLUtilities.writeInt("steps", this.steps));
        for (Track tr : this.tracks) {
            retVal.addElement(tr.saveAsXML());
        }
        return retVal;
    }

    public static TrackList loadFromXML(Element data) {
        TrackList trackList = new TrackList();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "steps": {
                    trackList.setSteps(XMLUtilities.readInt(node));
                    break;
                }
                case "track": {
                    trackList.addTrack(Track.loadFromXML(node));
                }
            }
        }
        return trackList;
    }

    public int getIndexOfTrack(Track t) {
        return this.tracks.indexOf(t);
    }
}

