/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.jmask;

import blue.components.lines.LineUtils;
import blue.soundObject.jmask.TablePoint;
import blue.soundObject.jmask.Utilities;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Table
extends AbstractTableModel {
    public static final int OFF = 0;
    public static final int ON = 1;
    public static final int COS = 2;
    public static final String[] TYPES = new String[]{"Off", "On", "Cosine"};
    ArrayList<TablePoint> points = new ArrayList();
    private double min = 0.0;
    private double max = 1.0;
    private int interpolationType = 1;
    double interpolation = 0.0;
    transient PropertyChangeSupport propChangeSupport = null;

    public Table() {
        this(true);
    }

    private Table(boolean init) {
        if (init) {
            TablePoint tablePoint1 = new TablePoint();
            TablePoint tablePoint2 = new TablePoint();
            tablePoint2.setTime(1.0);
            this.points.add(tablePoint1);
            this.points.add(tablePoint2);
        }
    }

    public Table(Table table) {
        this.min = table.min;
        this.max = table.max;
        this.interpolationType = table.interpolationType;
        this.interpolation = table.interpolation;
        for (TablePoint tp : table.points) {
            this.points.add(new TablePoint(tp));
        }
    }

    public double getValue(double time) {
        int size = this.points.size();
        if (size == 0) {
            return 0.0;
        }
        TablePoint a = this.getPoint(0);
        if (size == 1 || time <= 0.0) {
            return a.getValue();
        }
        TablePoint b = null;
        for (int i = 1; i < size; ++i) {
            b = this.getPoint(i);
            if (b.getTime() == time) {
                TablePoint temp;
                if (i == size - 1) {
                    return b.getValue();
                }
                while (i < size && (temp = this.getPoint(i)).getTime() == time) {
                    b = temp;
                    ++i;
                }
                return b.getValue();
            }
            if (!(b.getTime() < time)) break;
            a = b;
        }
        if (b == a) {
            return b.getValue();
        }
        double r = (time - a.getTime()) / (b.getTime() - a.getTime());
        double retVal = 0.0;
        switch (this.getInterpolationType()) {
            case 0: {
                retVal = a.getValue();
                break;
            }
            case 1: {
                retVal = this.interpolate(this.interpolation, r, a.getValue(), b.getValue());
                break;
            }
            case 2: {
                retVal = this.interpolateCosine(r, a.getValue(), b.getValue());
            }
        }
        return retVal;
    }

    double getphs(double xt) {
        double erg;
        int i;
        double phsum = 0.0;
        double xtr = Utilities.round(xt, 10L);
        int pointsSize = this.points.size();
        double[] x = new double[pointsSize];
        double[] y = new double[pointsSize];
        for (i = 0; i < pointsSize; ++i) {
            TablePoint tp = this.points.get(i);
            x[i] = tp.getTime();
            y[i] = tp.getValue();
        }
        if (pointsSize == 0) {
            erg = 0.0;
        } else if (pointsSize == 1) {
            erg = xtr * y[0];
        } else if (xtr <= x[0]) {
            erg = x[0] * y[0] - xtr * y[0];
        } else {
            for (i = 0; i < pointsSize && x[i] < xtr; ++i) {
            }
            if (this.interpolationType != 0) {
                if (i >= 2) {
                    for (int k = 0; k < i - 1; ++k) {
                        phsum += this.integrate(x[k + 1] - x[k], x[k + 1] - x[k], y[k], y[k + 1]);
                    }
                }
                phsum = xtr >= x[pointsSize - 1] ? (phsum += xtr * y[pointsSize - 1] - x[pointsSize - 1] * y[pointsSize - 1]) : (phsum += this.integrate(xtr - x[i - 1], x[i] - x[i - 1], y[i - 1], y[i]));
                erg = phsum;
            } else {
                if (i >= 2) {
                    for (int k = 0; k < i - 1; ++k) {
                        phsum += x[k + 1] * y[k] - x[k] * y[k];
                    }
                }
                erg = phsum += xtr * y[i - 1] - x[i - 1] * y[i - 1];
            }
        }
        return erg;
    }

    private double integrate(double x1, double xe, double y1, double y2) {
        double pw2 = Math.pow(2.0, this.interpolation);
        double retVal = x1 * y1 + Math.pow(x1, 1.0 + pw2) * (y2 - y1) / ((1.0 + pw2) * Math.pow(xe, pw2));
        return retVal;
    }

    private double interpolate(double ex, double r, double a, double b) {
        double retVal = 0.0;
        if (ex == 0.0) {
            retVal = a + r * (b - a);
        } else if (ex > 0.0 && b >= a) {
            retVal = a + Math.pow(r, ex + 1.0) * (b - a);
        } else if (ex > 0.0 && b < a) {
            retVal = b + Math.pow(1.0 - r, ex + 1.0) * (a - b);
        } else if (ex < 0.0 && b >= a) {
            retVal = b + Math.pow(1.0 - r, Math.abs(ex) + 1.0) * (a - b);
        } else if (ex < 0.0 && b < a) {
            retVal = a + Math.pow(r, Math.abs(ex) + 1.0) * (b - a);
        }
        return retVal;
    }

    double interpolateCosine(double r, double a, double b) {
        double cx = Math.cos(Math.PI * r + Math.PI) / 2.0 + 0.5;
        double erg = a + cx * (b - a);
        return erg;
    }

    public TablePoint getPoint(int index) {
        return this.points.get(index);
    }

    public void addPoint(int index, TablePoint point) {
        this.points.add(index, point);
        this.fireTableRowsInserted(index, index);
    }

    public void removePoint(int index) {
        this.points.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    public void removePoint(TablePoint selectedPoint) {
        this.removePoint(this.points.indexOf(selectedPoint));
    }

    public Class getColumnClass(int columnIndex) {
        return Double.class;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Time";
        }
        return "Value";
    }

    @Override
    public int getRowCount() {
        return this.points.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        TablePoint tp = this.getPoint(rowIndex);
        if (columnIndex == 0) {
            return new Double(tp.getTime());
        }
        return new Double(tp.getValue());
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (!(aValue instanceof Double)) {
            return;
        }
        double val = (Double)aValue;
        TablePoint tp = this.getPoint(rowIndex);
        if (columnIndex == 0) {
            TablePoint next;
            boolean isLeft = rowIndex == 0;
            boolean isRight = rowIndex == this.points.size() - 1;
            TablePoint previous = isLeft ? null : this.getPoint(rowIndex - 1);
            TablePoint tablePoint = next = isRight ? null : this.getPoint(rowIndex + 1);
            if (isLeft) {
                return;
            }
            if (isRight) {
                return;
            }
            if (val < previous.getTime()) {
                val = previous.getTime();
            }
            if (val > next.getTime()) {
                val = next.getTime();
            }
            tp.setTime(val);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        } else {
            tp.setValue(val);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    public double getInterpolation() {
        return this.interpolation;
    }

    public void setInterpolation(double interpolation) {
        if (interpolation == this.interpolation) {
            return;
        }
        double oldVal = this.interpolation;
        this.interpolation = interpolation;
        if (this.propChangeSupport != null) {
            this.propChangeSupport.firePropertyChange("interpolation", new Double(oldVal), new Double(interpolation));
        }
    }

    public static Table loadFromXML(Element data) {
        Table retVal = new Table(false);
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "min": {
                    retVal.min = Double.parseDouble(node.getTextString());
                    break;
                }
                case "max": {
                    retVal.max = Double.parseDouble(node.getTextString());
                    break;
                }
                case "interpolationType": {
                    retVal.setInterpolationType(Integer.parseInt(node.getTextString()));
                    break;
                }
                case "interpolation": {
                    retVal.interpolation = Double.parseDouble(node.getTextString());
                    break;
                }
                case "points": {
                    Elements pointNodes = node.getElements();
                    while (pointNodes.hasMoreElements()) {
                        Element pointNode = pointNodes.next();
                        String pointNodeName = pointNode.getName();
                        if (!pointNodeName.equals("point")) continue;
                        retVal.points.add(TablePoint.loadFromXML(pointNode));
                    }
                    break;
                }
            }
        }
        return retVal;
    }

    public Element saveAsXML() {
        Element retVal = new Element("table");
        retVal.addElement(XMLUtilities.writeDouble("min", this.getMin()));
        retVal.addElement(XMLUtilities.writeDouble("max", this.getMax()));
        retVal.addElement(XMLUtilities.writeInt("interpolationType", this.getInterpolationType()));
        retVal.addElement(XMLUtilities.writeDouble("interpolation", this.interpolation));
        Element pointsNode = new Element("points");
        for (TablePoint tPoint : this.points) {
            pointsNode.addElement(tPoint.saveAsXML());
        }
        retVal.addElement(pointsNode);
        return retVal;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (boolean)false, this.getClass(), (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min, boolean truncate) {
        if (this.min == min) {
            return;
        }
        double oldVal = this.min;
        this.min = min;
        for (TablePoint point : this.points) {
            double newVal = truncate ? LineUtils.truncate(point.getValue(), this.min, this.max) : LineUtils.rescale(point.getValue(), oldVal, this.max, this.min, this.max, new BigDecimal(-1));
            point.setLocation(point.getTime(), newVal);
        }
        if (this.propChangeSupport != null) {
            this.propChangeSupport.firePropertyChange("min", new Double(oldVal), new Double(this.min));
        }
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max, boolean truncate) {
        if (this.max == max) {
            return;
        }
        double oldVal = this.max;
        this.max = max;
        for (TablePoint point : this.points) {
            double newVal = truncate ? LineUtils.truncate(point.getValue(), this.min, this.max) : LineUtils.rescale(point.getValue(), this.min, oldVal, this.min, this.max, new BigDecimal(-1.0));
            point.setLocation(point.getTime(), newVal);
        }
        if (this.propChangeSupport != null) {
            this.propChangeSupport.firePropertyChange("max", new Double(oldVal), new Double(this.max));
        }
    }

    public TablePoint getTablePoint(int index) {
        return this.points.get(index);
    }

    public int getInterpolationType() {
        return this.interpolationType;
    }

    public void setInterpolationType(int interpolationType) {
        if (interpolationType == this.interpolationType) {
            return;
        }
        int oldVal = this.interpolationType;
        this.interpolationType = interpolationType;
        if (this.propChangeSupport != null) {
            this.propChangeSupport.firePropertyChange("interpolationType", new Double(oldVal), new Double(interpolationType));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.propChangeSupport == null) {
            this.propChangeSupport = new PropertyChangeSupport(this);
        }
        for (PropertyChangeListener listener : this.propChangeSupport.getPropertyChangeListeners()) {
            if (pcl != listener) continue;
            return;
        }
        this.propChangeSupport.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (this.propChangeSupport != null) {
            this.propChangeSupport.removePropertyChangeListener(pcl);
        }
    }

    @Override
    public void addTableModelListener(TableModelListener tml) {
        for (TableModelListener listener : this.getTableModelListeners()) {
            if (tml != listener) continue;
            return;
        }
        super.addTableModelListener(tml);
    }
}

